/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import no.rmz.blobee.rpc.client.ConnectingRpcClientImpl;
import no.rmz.blobee.rpc.client.RpcClient;
import no.rmz.blobee.rpc.client.SingeltonClientFactory;
import no.rmz.blobee.rpc.peer.RpcMessageListener;
import no.rmz.blobee.rpc.peer.RpcPeerPipelineFactory;
import no.rmz.blobee.rpc.server.ExecutionServiceListener;
import no.rmz.blobee.rpc.server.RpcExecutionServiceImpl;
import no.rmz.blobee.rpc.server.RpcServerImpl;
import no.rmz.blobee.threads.ErrorLoggingThreadFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public final class RpcSetup {
    public static final Logger log = Logger.getLogger(RpcSetup.class.getName());
    public static final int DEFAULT_BUFFER_SIZE = 1000;

    private RpcSetup() {
    }

    public static RpcClient newClient(InetSocketAddress socketAddress) {
        Preconditions.checkNotNull((Object)socketAddress);
        RpcExecutionServiceImpl executor = new RpcExecutionServiceImpl("Client execution service");
        ExecutorService bossExecutor = Executors.newCachedThreadPool(new ErrorLoggingThreadFactory("RpcClient bossExecutor", log));
        ExecutorService workerExcecutor = Executors.newCachedThreadPool(new ErrorLoggingThreadFactory("RpcClient workerExcecutor", log));
        ClientBootstrap clientBootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExcecutor));
        ConnectingRpcClientImpl rpcClient = new ConnectingRpcClientImpl(clientBootstrap, socketAddress);
        String name = "RPC client connecting to " + socketAddress.toString();
        SingeltonClientFactory rcf = new SingeltonClientFactory(rpcClient);
        RpcPeerPipelineFactory clientPipelineFactory = new RpcPeerPipelineFactory(name, executor, rcf);
        clientBootstrap.setPipelineFactory((ChannelPipelineFactory)clientPipelineFactory);
        return rpcClient;
    }

    public static RpcServerImpl newServer(InetSocketAddress inetSocketAddress, RpcMessageListener rpcMessageListener) {
        Preconditions.checkNotNull((Object)inetSocketAddress);
        return new RpcServerImpl(inetSocketAddress, rpcMessageListener);
    }

    public static RpcServerImpl newServer(InetSocketAddress inetSocketAddress, RpcMessageListener rpcMessageListener, ExecutionServiceListener esListener) {
        Preconditions.checkNotNull((Object)inetSocketAddress);
        return new RpcServerImpl(inetSocketAddress, rpcMessageListener, esListener);
    }

    public static RpcServerImpl newServer(InetSocketAddress inetSocketAddress) {
        return RpcSetup.newServer(inetSocketAddress, null);
    }
}

