/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.client;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import no.rmz.blobee.rpc.client.ChannelShutdownCleaner;
import no.rmz.blobee.rpc.client.RpcClient;
import no.rmz.blobee.rpc.client.RpcClientImpl;
import no.rmz.blobee.rpc.client.RpcClientSideInvocationListener;
import no.rmz.blobee.rpc.methods.MethodSignatureResolver;
import no.rmz.blobee.rpc.peer.RemoteExecutionContext;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFuture;

public final class ConnectingRpcClientImpl
implements RpcClient {
    private final RpcClientImpl rpcClient = new RpcClientImpl(1000);
    private final ClientBootstrap clientBootstrap;
    private final InetSocketAddress socketAddress;

    public ConnectingRpcClientImpl(ClientBootstrap clientBootstrap, InetSocketAddress socketAddress) {
        this.socketAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)socketAddress);
        this.clientBootstrap = (ClientBootstrap)Preconditions.checkNotNull((Object)clientBootstrap);
    }

    @Override
    public RpcClient start() {
        Preconditions.checkNotNull((Object)this.socketAddress);
        ChannelFuture future = this.clientBootstrap.connect((SocketAddress)this.socketAddress);
        this.rpcClient.start(future.getChannel(), new ChannelShutdownCleaner(){

            @Override
            public void shutdownHook() {
                ConnectingRpcClientImpl.this.clientBootstrap.releaseExternalResources();
            }
        });
        return this;
    }

    @Override
    public void cancelInvocation(long rpcIndex) {
        this.rpcClient.cancelInvocation(rpcIndex);
    }

    @Override
    public void failInvocation(long rpcIndex, String errorMessage) {
        this.rpcClient.failInvocation(rpcIndex, errorMessage);
    }

    @Override
    public RpcChannel newClientRpcChannel() {
        return this.rpcClient.newClientRpcChannel();
    }

    @Override
    public RpcController newController() {
        return this.rpcClient.newController();
    }

    @Override
    public void returnCall(RemoteExecutionContext dc, Message message) {
        Preconditions.checkNotNull((Object)dc);
        Preconditions.checkNotNull((Object)message);
        this.rpcClient.returnCall(dc, message);
    }

    @Override
    public MethodSignatureResolver getResolver() {
        return this.rpcClient.getResolver();
    }

    @Override
    public RpcClient addProtobuferRpcInterface(Object instance) {
        this.rpcClient.addProtobuferRpcInterface(instance);
        return this;
    }

    @Override
    public RpcClient addInterface(Class serviceInterface) {
        this.rpcClient.addInterface(serviceInterface);
        return this;
    }

    @Override
    public RpcClient addInvocationListener(RpcClientSideInvocationListener listener) {
        this.rpcClient.addInvocationListener(listener);
        return this;
    }

    @Override
    public void stop() {
        this.rpcClient.stop();
    }
}

