/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.peer;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import no.rmz.blobee.controllers.RpcServiceController;
import no.rmz.blobee.controllers.RpcServiceControllerImpl;
import no.rmz.blobee.rpc.peer.RpcDirection;
import no.rmz.blobee.rpc.peer.RpcPeerHandler;
import no.rmz.blobee.rpc.peer.wireprotocol.OutgoingRpcAdapter;
import no.rmz.blobee.rpc.peer.wireprotocol.WireFactory;
import no.rmz.blobeeproto.api.proto.Rpc;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;

public final class RemoteExecutionContext {
    private final Rpc.MethodSignature methodSignature;
    private final long rpcIndex;
    private final RpcPeerHandler peerHandler;
    private final ChannelHandlerContext ctx;
    private final RpcDirection direction;
    private final RpcServiceController controller;
    private final OutgoingRpcAdapter wire;

    public RemoteExecutionContext(RpcPeerHandler peerHandler, ChannelHandlerContext ctx, Rpc.MethodSignature methodSignature, long rpcIndex, RpcDirection direction) {
        this.ctx = (ChannelHandlerContext)Preconditions.checkNotNull((Object)ctx);
        this.peerHandler = (RpcPeerHandler)((Object)Preconditions.checkNotNull((Object)((Object)peerHandler)));
        this.methodSignature = (Rpc.MethodSignature)((Object)Preconditions.checkNotNull((Object)((Object)methodSignature)));
        this.rpcIndex = (Long)Preconditions.checkNotNull((Object)rpcIndex);
        this.direction = (RpcDirection)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
        this.controller = new RpcServiceControllerImpl(this);
        Channel channel = this.getCtx().getChannel();
        this.wire = WireFactory.getWireForChannel(channel);
    }

    public RpcDirection getDirection() {
        return this.direction;
    }

    public Rpc.MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public long getRpcIndex() {
        return this.rpcIndex;
    }

    public void returnResult(Message result) {
        long rpcIndex = this.getRpcIndex();
        Rpc.MethodSignature methodSignature = this.getMethodSignature();
        this.wire.returnRpcResult(rpcIndex, methodSignature, result);
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public void startCancel() {
        this.controller.startCancel();
    }
}

