/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.peer;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import no.rmz.blobee.rpc.client.RpcClientFactory;
import no.rmz.blobee.rpc.methods.MethodSignatureResolver;
import no.rmz.blobee.rpc.peer.RpcMessageListener;
import no.rmz.blobee.rpc.peer.RpcPeerHandler;
import no.rmz.blobee.rpc.server.RpcExecutionService;
import no.rmz.blobeeproto.api.proto.Rpc;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;

public final class RpcPeerPipelineFactory
implements ChannelPipelineFactory {
    private final String name;
    private RpcMessageListener listener;
    private final RpcExecutionService executionService;
    private final MethodSignatureResolver clientResolver;
    private final RpcClientFactory rcf;

    public RpcPeerPipelineFactory(String name, RpcExecutionService executor, RpcClientFactory rcf) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.executionService = (RpcExecutionService)Preconditions.checkNotNull((Object)executor);
        this.rcf = (RpcClientFactory)Preconditions.checkNotNull((Object)rcf);
        this.clientResolver = rcf.getResolver();
    }

    public RpcPeerPipelineFactory(String name, RpcExecutionService executor, RpcClientFactory rcf, RpcMessageListener listener) {
        this(name, executor, rcf);
        this.listener = listener;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ProtobufDecoder protbufDecoder = new ProtobufDecoder((MessageLite)Rpc.RpcControl.getDefaultInstance());
        ChannelPipeline p = Channels.pipeline();
        p.addLast("frameDecoder", (ChannelHandler)new ProtobufVarint32FrameDecoder());
        p.addLast("protobufDecoder", (ChannelHandler)protbufDecoder);
        p.addLast("frameEncoder", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender());
        p.addLast("protobufEncoder", (ChannelHandler)new ProtobufEncoder());
        RpcPeerHandler handler = new RpcPeerHandler(this.clientResolver, this.executionService, this.rcf);
        if (this.listener != null) {
            handler.setListener(this.listener);
        }
        p.addLast("handler", (ChannelHandler)handler);
        return p;
    }
}

