/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import no.rmz.blobee.controllers.RpcServiceControllerImpl;
import no.rmz.blobee.rpc.peer.RemoteExecutionContext;
import no.rmz.blobee.rpc.server.ControllerStorage;
import no.rmz.blobee.rpc.server.RpcExecutionServiceImpl;
import org.jboss.netty.channel.ChannelHandlerContext;

final class MethodInvokingRunnable
implements Runnable {
    private final Object implementation;
    private final RemoteExecutionContext dc;
    private final ChannelHandlerContext ctx;
    private final Object parameter;
    private final RpcExecutionServiceImpl executor;

    public MethodInvokingRunnable(Object implementation, RemoteExecutionContext dc, ChannelHandlerContext ctx, Object parameter, ControllerStorage ctStor, RpcExecutionServiceImpl executor) {
        this.implementation = Preconditions.checkNotNull((Object)implementation);
        this.dc = (RemoteExecutionContext)Preconditions.checkNotNull((Object)dc);
        this.ctx = (ChannelHandlerContext)Preconditions.checkNotNull((Object)ctx);
        this.parameter = Preconditions.checkNotNull((Object)parameter);
        this.executor = (RpcExecutionServiceImpl)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    public void run() {
        Method method = this.executor.getMethod(this.dc.getMethodSignature());
        final RpcServiceControllerImpl controller = new RpcServiceControllerImpl(this.dc);
        this.executor.storeController(this.ctx, this.dc.getRpcIndex(), controller);
        RpcCallback<Message> callbackAdapter = new RpcCallback<Message>(){

            public void run(Message response) {
                controller.invokeCancelledCallback();
                MethodInvokingRunnable.this.dc.returnResult(response);
            }
        };
        try {
            method.invoke(this.implementation, controller, this.parameter, callbackAdapter);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.executor.removeController(this.ctx, this.dc.getRpcIndex());
        }
    }
}

