/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.controllers;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcCallback;
import no.rmz.blobee.controllers.RpcServiceController;
import no.rmz.blobee.rpc.peer.RemoteExecutionContext;
import no.rmz.blobee.rpc.peer.wireprotocol.OutgoingRpcAdapter;
import no.rmz.blobee.rpc.peer.wireprotocol.WireFactory;

public final class RpcServiceControllerImpl
implements RpcServiceController {
    private final RemoteExecutionContext executionContext;
    private final Object monitor = new Object();
    private boolean failed = false;
    private boolean startCancelInvokedAlready = false;
    private boolean cancelled = false;
    private RpcCallback<Object> callbackOnFailure;
    private OutgoingRpcAdapter wire;

    public RpcServiceControllerImpl(RemoteExecutionContext dc) {
        this.executionContext = (RemoteExecutionContext)Preconditions.checkNotNull((Object)dc);
        this.wire = WireFactory.getWireForChannel(this.executionContext.getCtx().getChannel());
    }

    public void reset() {
        throw new UnsupportedOperationException("Reset not supported on server side controller");
    }

    public boolean failed() {
        return this.failed;
    }

    public String errorText() {
        throw new UnsupportedOperationException("Not supported in server side RpcController");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOnCancel(RpcCallback<Object> callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.monitor;
        synchronized (object) {
            if (this.callbackOnFailure != null) {
                throw new IllegalStateException("notifyOnCancel invoked more than once");
            }
            this.callbackOnFailure = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeCancelledCallback() {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.startCancelInvokedAlready) {
                this.startCancelInvokedAlready = true;
                if (this.callbackOnFailure != null) {
                    this.callbackOnFailure.run(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCancel() {
        Object object = this.monitor;
        synchronized (object) {
            this.cancelled = true;
            this.invokeCancelledCallback();
        }
    }

    public void setFailed(String reason) {
        Preconditions.checkNotNull((Object)reason);
        this.failed = true;
        long rpcIndex = this.executionContext.getRpcIndex();
        this.wire.sendInvocationFailedMessage(rpcIndex, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.monitor;
        synchronized (object) {
            return this.cancelled;
        }
    }
}

