/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.peer;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.rmz.blobee.rpc.client.RpcClient;
import no.rmz.blobee.rpc.client.RpcClientFactory;
import no.rmz.blobee.rpc.methods.MethodSignatureResolver;
import no.rmz.blobee.rpc.peer.HeartbeatMonitor;
import no.rmz.blobee.rpc.peer.RemoteExecutionContext;
import no.rmz.blobee.rpc.peer.RpcDirection;
import no.rmz.blobee.rpc.peer.RpcMessageListener;
import no.rmz.blobee.rpc.peer.RpcPeerHandlerException;
import no.rmz.blobee.rpc.server.RpcExecutionService;
import no.rmz.blobeeproto.api.proto.Rpc;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public final class RpcPeerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger log = Logger.getLogger(RpcPeerHandler.class.getName());
    private RpcMessageListener listener;
    private final Object listenerLock = new Object();
    private final RpcExecutionService executionService;
    private final RpcClientFactory rcf;
    private HeartbeatMonitor heartbeatMonitor;
    private final Map<Channel, Object> lockMap = new WeakHashMap<Channel, Object>();
    private final MethodSignatureResolver clientResolver;

    protected RpcPeerHandler(MethodSignatureResolver clientResolver, RpcExecutionService executionService, RpcClientFactory rcf) {
        this.clientResolver = (MethodSignatureResolver)Preconditions.checkNotNull((Object)clientResolver);
        this.executionService = (RpcExecutionService)Preconditions.checkNotNull((Object)executionService);
        this.rcf = (RpcClientFactory)Preconditions.checkNotNull((Object)rcf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(RpcMessageListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = listener;
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.heartbeatMonitor = new HeartbeatMonitor(e.getChannel());
        this.registerChannel(ctx.getChannel());
    }

    private void registerChannel(Channel channel) {
        Preconditions.checkNotNull((Object)channel);
    }

    private RpcClient getRpcChannel(Channel channel) {
        Preconditions.checkNotNull((Object)channel);
        return this.rcf.getClientFor(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runListener(ChannelHandlerContext ctx, Object message) {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkNotNull((Object)message);
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listener != null) {
                this.listener.receiveMessage(message, ctx);
            }
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (!(object instanceof Message)) {
            throw new RuntimeException("Unknown type of incoming message in " + (Object)((Object)this) + ".  Type of message was " + object.getClass().getName());
        }
        Message message = (Message)object;
        this.runListener(ctx, message);
        try {
            if (message instanceof Rpc.RpcControl) {
                Rpc.RpcControl msg = (Rpc.RpcControl)((Object)e.getMessage());
                Rpc.MessageType messageType = msg.getMessageType();
                switch (messageType) {
                    case HEARTBEAT: {
                        this.processHeartbeatMessage();
                        break;
                    }
                    case RPC_INV: {
                        this.processInvocationMessage(msg, ctx);
                        break;
                    }
                    case RPC_RET: {
                        this.processReturnValueMessage(msg, ctx);
                        break;
                    }
                    case SHUTDOWN: {
                        this.processChannelShutdownMessage(ctx);
                        break;
                    }
                    case INVOCATION_FAILED: {
                        this.processInvocationFailedMessage(ctx.getChannel(), msg);
                        break;
                    }
                    case RPC_CANCEL: {
                        this.processCancelMessage(msg, ctx);
                        break;
                    }
                    default: {
                        log.warning("Unknown type of control message: " + message);
                        break;
                    }
                }
            } else {
                log.log(Level.SEVERE, "Unknown message type detected, shutting down channel", message);
                e.getChannel().close();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Caught exception while handling  message, shutting down connection", ex);
            e.getChannel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        log.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkNotNull((Object)e);
        log.log(Level.INFO, "Channel closed");
        super.channelClosed(ctx, e);
        this.rcf.removeClientFor(ctx.getChannel());
    }

    private MessageLite getPrototypeForMessageClass(Class theClass) throws RpcPeerHandlerException {
        Preconditions.checkNotNull((Object)theClass);
        try {
            Method[] methods;
            for (Method method : methods = theClass.getMethods()) {
                if (!method.getName().equals("getDefaultInstance")) continue;
                Object foo = method.invoke(null, null);
                MessageLite returnValue = (MessageLite)foo;
                return returnValue;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            throw new RpcPeerHandlerException(ex);
        }
        throw new RpcPeerHandlerException("Couldn't find getDefaultIntance method for class " + theClass);
    }

    private MessageLite getPrototypeForParameter(Rpc.MethodSignature methodSignature) throws RpcPeerHandlerException {
        Preconditions.checkNotNull((Object)((Object)methodSignature));
        Class parameterType = this.executionService.getParameterType(methodSignature);
        Preconditions.checkNotNull((Object)parameterType);
        return this.getPrototypeForMessageClass(parameterType);
    }

    private MessageLite getPrototypeForReturnValue(Rpc.MethodSignature methodSignature) {
        Preconditions.checkNotNull((Object)((Object)methodSignature));
        return this.clientResolver.getPrototypeForReturnValue(methodSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getChannelLock(Channel channel) {
        Map<Channel, Object> map = this.lockMap;
        synchronized (map) {
            if (this.lockMap.containsKey(channel)) {
                return this.lockMap.containsKey(channel);
            }
            Object lock = new Object();
            this.lockMap.put(channel, lock);
            return lock;
        }
    }

    private void processCancelMessage(Rpc.RpcControl msg, ChannelHandlerContext ctx) {
        long rpcIndex = msg.getRpcIndex();
        this.executionService.startCancel(ctx, rpcIndex);
    }

    private void processInvocationFailedMessage(Channel channel, Rpc.RpcControl msg) {
        Preconditions.checkNotNull((Object)channel);
        Preconditions.checkNotNull((Object)((Object)msg));
        String errorMessage = msg.getFailed();
        long rpcIndex = msg.getRpcIndex();
        this.getRpcChannel(channel).failInvocation(rpcIndex, errorMessage);
    }

    private void processChannelShutdownMessage(ChannelHandlerContext ctx) {
        ctx.getChannel().close();
    }

    private void processReturnValueMessage(Rpc.RpcControl msg, ChannelHandlerContext ctx) throws RpcPeerHandlerException {
        MessageLite payload;
        Rpc.MethodSignature methodSignature = msg.getMethodSignature();
        long rpcIndex = msg.getRpcIndex();
        MessageLite prototypeForReturnValue = this.getPrototypeForReturnValue(methodSignature);
        Preconditions.checkNotNull((Object)prototypeForReturnValue);
        RemoteExecutionContext dc = new RemoteExecutionContext(this, ctx, methodSignature, rpcIndex, RpcDirection.RETURNING);
        try {
            payload = prototypeForReturnValue.newBuilderForType().mergeFrom(msg.getPayload()).build();
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RpcPeerHandlerException((Exception)((Object)ex));
        }
        Preconditions.checkNotNull((Object)payload);
        Message pld = (Message)payload;
        Preconditions.checkNotNull((Object)dc);
        this.getRpcChannel(ctx.getChannel()).returnCall(dc, pld);
    }

    private void processInvocationMessage(Rpc.RpcControl msg, ChannelHandlerContext ctx) throws RpcPeerHandlerException {
        try {
            Rpc.MethodSignature methodSignature = msg.getMethodSignature();
            long rpcIndex = msg.getRpcIndex();
            MessageLite prototypeForParameter = this.getPrototypeForParameter(methodSignature);
            RemoteExecutionContext rec = new RemoteExecutionContext(this, ctx, methodSignature, rpcIndex, RpcDirection.INVOKING);
            Preconditions.checkNotNull((Object)rec);
            MessageLite payload = prototypeForParameter.newBuilderForType().mergeFrom(msg.getPayload()).build();
            Preconditions.checkNotNull((Object)payload);
            Message pld = (Message)payload;
            Preconditions.checkNotNull((Object)ctx);
            this.executionService.execute(rec, ctx, pld);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RpcPeerHandlerException((Exception)((Object)ex));
        }
    }

    private void processHeartbeatMessage() {
        this.heartbeatMonitor.receiveHeartbeat();
    }
}

