/**
 * Copyright 2013 Bjørn Remseth (la3lma@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package no.rmz.blobee.controllers;

import com.google.protobuf.RpcController;
import no.rmz.blobee.rpc.client.BlobeeRpcController;

/**
 * An implementation of the RpcController interface that is used by
 * server implementations.
 */
public interface RpcServiceController extends BlobeeRpcController {

    /**
     * Invoke the "cancelled callback" callback that is used to
     * inform the service that it has been cancelled by the client.
     */
    void invokeCancelledCallback();
}
