/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.controllers;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcCallback;
import no.rmz.blobee.controllers.RpcClientController;
import no.rmz.blobee.rpc.client.RpcClientImpl;
import no.rmz.blobee.rpc.client.RpcClientSideInvocation;

public final class RpcClientControllerImpl
implements RpcClientController {
    private boolean failed = false;
    private boolean cancelled = false;
    private String reason = "";
    private final Object monitor = new Object();
    private RpcClientImpl rpcClient;
    private long rpcIndex = -1L;
    private boolean active = false;
    private RpcClientSideInvocation invocation;
    private boolean multiReturn;
    private boolean noReturn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.rpcClient != null) {
                if (this.active) {
                    throw new IllegalStateException("Cannot reset controller, it is already connected to  rpcClient = " + this.rpcClient + " rpcIndex = " + this.rpcIndex);
                }
                this.rpcClient = null;
                this.rpcIndex = -1L;
                this.multiReturn = false;
                this.noReturn = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindToInvocation(RpcClientSideInvocation invocation) {
        Preconditions.checkNotNull((Object)invocation);
        Object object = this.monitor;
        synchronized (object) {
            if (this.invocation != null) {
                throw new IllegalStateException("invocation was non null");
            }
            this.invocation = invocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.monitor;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActive(boolean active) {
        Object object = this.monitor;
        synchronized (object) {
            this.active = active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed() {
        Object object = this.monitor;
        synchronized (object) {
            return this.failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String errorText() {
        String string = this.reason;
        synchronized (string) {
            return this.reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCancel() {
        Object object = this.monitor;
        synchronized (object) {
            this.cancelled = true;
            if (this.rpcClient != null) {
                this.rpcClient.cancelInvocation(this.rpcIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailed(String reason) {
        Preconditions.checkNotNull((Object)reason);
        Object object = this.monitor;
        synchronized (object) {
            this.failed = true;
            this.reason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.monitor;
        synchronized (object) {
            return this.cancelled;
        }
    }

    public void notifyOnCancel(RpcCallback<Object> callback) {
        throw new UnsupportedOperationException("notifyOnCancel callback not supported on client side");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientAndIndex(RpcClientImpl rpcClient, long rpcIndex) {
        Preconditions.checkNotNull((Object)rpcClient);
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        Object object = this.monitor;
        synchronized (object) {
            if (this.rpcClient != null) {
                throw new IllegalArgumentException("Controller is already in use, can't be reset");
            }
            this.rpcClient = (RpcClientImpl)Preconditions.checkNotNull((Object)rpcClient);
            Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
            this.rpcIndex = rpcIndex;
        }
    }

    @Override
    public long getIndex() {
        return this.rpcIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMultiReturn() {
        Object object = this.monitor;
        synchronized (object) {
            this.multiReturn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMultiReturn() {
        Object object = this.monitor;
        synchronized (object) {
            return this.multiReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoReturn() {
        Object object = this.monitor;
        synchronized (object) {
            this.noReturn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNoReturn() {
        Object object = this.monitor;
        synchronized (object) {
            return this.noReturn;
        }
    }
}

