/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.client;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.rmz.blobee.controllers.RpcClientController;
import no.rmz.blobee.controllers.RpcClientControllerImpl;
import no.rmz.blobee.protobuf.MethodTypeException;
import no.rmz.blobee.protobuf.TypeExctractor;
import no.rmz.blobee.rpc.client.BlobeeRpcController;
import no.rmz.blobee.rpc.client.ChannelShutdownCleaner;
import no.rmz.blobee.rpc.client.RpcClient;
import no.rmz.blobee.rpc.client.RpcClientSideInvocation;
import no.rmz.blobee.rpc.client.RpcClientSideInvocationListener;
import no.rmz.blobee.rpc.methods.MethodSignatureResolver;
import no.rmz.blobee.rpc.methods.ResolverImpl;
import no.rmz.blobee.rpc.peer.RemoteExecutionContext;
import no.rmz.blobee.rpc.peer.wireprotocol.OutgoingRpcAdapter;
import no.rmz.blobee.rpc.peer.wireprotocol.WireFactory;
import org.jboss.netty.channel.Channel;

public final class RpcClientImpl
implements RpcClient {
    private static final Logger log = Logger.getLogger(RpcClientImpl.class.getName());
    private static final int MILLIS_TO_SLEEP_BETWEEN_ATTEMPTS = 20;
    private static final int NUM_OF_TIMES_BEFORE_FAILING = 200;
    private static final int MAX_CAPACITY_FOR_INPUT_BUFFER = 10000;
    private static final int TIME_TO_WAIT_WHEN_QUEUE_IS_EMPTY_IN_MILLIS = 50;
    public static final int MAXIMUM_TCP_PORT_NUMBER = 65535;
    private final int capacity;
    private final BlockingQueue<RpcClientSideInvocation> incoming;
    private volatile boolean running = false;
    private final Map<Long, RpcClientSideInvocation> invocations = new TreeMap<Long, RpcClientSideInvocation>();
    private OutgoingRpcAdapter wire;
    private long nextIndex;
    private Channel channel;
    private final Object mutationMonitor = new Object();
    private final Object runLock = new Object();
    private final MethodSignatureResolver resolver;
    private final Runnable incomingDispatcher = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (RpcClientImpl.this.running) {
                RpcClientImpl.this.sendFirstAvailableOutgoingInvocation();
            }
            try {
                RpcClientImpl.this.runningLock.lock();
                RpcClientImpl.this.noLongerRunning.signal();
            }
            finally {
                RpcClientImpl.this.runningLock.unlock();
            }
        }
    };
    private final Lock runningLock;
    private final Condition noLongerRunning;
    private RpcClientSideInvocationListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnCall(RemoteExecutionContext dc, Message message) {
        Preconditions.checkNotNull((Object)dc);
        Preconditions.checkNotNull((Object)message);
        Map<Long, RpcClientSideInvocation> map = this.invocations;
        synchronized (map) {
            long rpcIndex = dc.getRpcIndex();
            RpcClientSideInvocation invocation = this.invocations.get(rpcIndex);
            if (invocation == null) {
                log.log(Level.FINEST, "Attempt to return  nonexistant invocation: " + rpcIndex + " with message message " + message);
                return;
            }
            RpcCallback<Message> done = invocation.getDone();
            done.run((Object)message);
            if (!dc.isMultiReturn()) {
                this.deactivateInvocation(dc.getRpcIndex());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateMultiSequence(long rpcIndex) {
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        Map<Long, RpcClientSideInvocation> map = this.invocations;
        synchronized (map) {
            RpcClientSideInvocation invocation = this.invocations.get(rpcIndex);
            if (invocation == null) {
                log.log(Level.FINEST, "Attempt to terminate  nonexistant  multiinvocation sequence: " + rpcIndex);
                return;
            }
            this.deactivateInvocation(rpcIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateInvocation(Long index) {
        Map<Long, RpcClientSideInvocation> map = this.invocations;
        synchronized (map) {
            RpcClientSideInvocation invocation = this.invocations.get(index);
            if (invocation == null) {
                throw new IllegalStateException("Couldn't find call stub for invocation " + index);
            }
            this.invocations.remove(index);
            if (this.invocations.containsKey(index)) {
                log.info("Removal of index did not succeed for index " + index);
            }
            invocation.getController().setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFirstAvailableOutgoingInvocation() {
        try {
            RpcClientSideInvocation invocation = this.incoming.poll(50L, TimeUnit.MILLISECONDS);
            if (invocation == null) {
                return;
            }
            if (invocation.getController().isCanceled()) {
                return;
            }
            if (this.listener != null) {
                this.listener.listenToInvocation(invocation);
            }
            Long currentIndex = this.nextIndex++;
            RpcClientController rcci = invocation.getController();
            if (!rcci.isNoReturn()) {
                Map<Long, RpcClientSideInvocation> map = this.invocations;
                synchronized (map) {
                    this.invocations.put(currentIndex, invocation);
                }
            }
            rcci.setClientAndIndex(this, currentIndex);
            this.sendInvocation(invocation, currentIndex);
        }
        catch (InterruptedException ex) {
            log.warning("Something went south");
        }
    }

    public RpcClientImpl(int capacity) {
        this(capacity, new ResolverImpl());
    }

    public RpcClientImpl(int capacity, MethodSignatureResolver resolver) {
        Preconditions.checkArgument((0 < capacity && capacity < 10000 ? 1 : 0) != 0);
        this.capacity = capacity;
        this.incoming = new ArrayBlockingQueue<RpcClientSideInvocation>(capacity);
        this.resolver = (MethodSignatureResolver)Preconditions.checkNotNull((Object)resolver);
        this.runningLock = new ReentrantLock();
        this.noLongerRunning = this.runningLock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannel(Channel channel) {
        Object object = this.mutationMonitor;
        synchronized (object) {
            if (this.channel != null) {
                throw new IllegalStateException("Can't set channel since channel is already set");
            }
            this.channel = (Channel)Preconditions.checkNotNull((Object)channel);
            this.wire = WireFactory.getWireForChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final Channel channel, final ChannelShutdownCleaner channelCleanupRunnable) {
        Preconditions.checkNotNull((Object)channel);
        Preconditions.checkNotNull((Object)channelCleanupRunnable);
        Object object = this.runLock;
        synchronized (object) {
            this.setChannel(channel);
            Runnable channelCleanup = new Runnable(){

                @Override
                public void run() {
                    channel.getCloseFuture().awaitUninterruptibly();
                    channelCleanupRunnable.shutdownHook();
                }
            };
            this.running = true;
            Thread thread = new Thread(channelCleanup, "client shutdown cleaner");
            thread.start();
            Thread dispatcherThread = new Thread(this.incomingDispatcher, "Incoming dispatcher for client");
            dispatcherThread.start();
        }
    }

    @Override
    public RpcChannel newClientRpcChannel() {
        return new RpcChannel(){

            public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
                Preconditions.checkNotNull((Object)method);
                Preconditions.checkNotNull((Object)controller);
                Preconditions.checkNotNull((Object)request);
                Preconditions.checkNotNull((Object)responsePrototype);
                Preconditions.checkNotNull(done);
                if (controller instanceof RpcClientController) {
                    RpcClientController ctrl = (RpcClientController)controller;
                    if (ctrl.isActive()) {
                        throw new IllegalStateException("Attempt to activate already active controller");
                    }
                    ctrl.setActive(RpcClientImpl.this.running);
                }
                RpcClientSideInvocation invocation = new RpcClientSideInvocation(method, controller, request, responsePrototype, done);
                for (int i = 0; i < 200; ++i) {
                    if (RpcClientImpl.this.incoming.offer(invocation)) {
                        return;
                    }
                    try {
                        Thread.sleep(20L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        log.info("Ignoring interruption " + ex);
                    }
                }
                throw new RuntimeException("Couldn't add to queue");
            }
        };
    }

    @Override
    public BlobeeRpcController newController() {
        return new RpcClientControllerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failInvocation(long rpcIndex, String errorMessage) {
        RpcClientSideInvocation invocation;
        Preconditions.checkNotNull((Object)errorMessage);
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        Map<Long, RpcClientSideInvocation> map = this.invocations;
        synchronized (map) {
            invocation = this.invocations.get(rpcIndex);
        }
        if (invocation == null) {
            log.log(Level.FINEST, "Attempt to fail nonexistant invocation: " + rpcIndex + " with error message " + errorMessage);
            return;
        }
        Preconditions.checkNotNull((Object)invocation);
        invocation.getController().setFailed(errorMessage);
        this.deactivateInvocation(rpcIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelInvocation(long rpcIndex) {
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        Map<Long, RpcClientSideInvocation> map = this.invocations;
        synchronized (map) {
            RpcClientSideInvocation invocation = this.invocations.get(rpcIndex);
            if (invocation == null) {
                log.log(Level.FINEST, "Attempt to cancel nonexistant invocation: " + rpcIndex);
                return;
            }
        }
        this.wire.sendCancelMessage(rpcIndex);
        this.deactivateInvocation(rpcIndex);
    }

    @Override
    public RpcClient start() {
        return this;
    }

    @Override
    public RpcClient addInvocationListener(RpcClientSideInvocationListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listener = listener;
        return this;
    }

    @Override
    public MethodSignatureResolver getResolver() {
        return this.resolver;
    }

    @Override
    public RpcClient addProtobuferRpcInterface(Object instance) {
        if (!(instance instanceof Service)) {
            throw new IllegalArgumentException("Expected a class extending com.google.protobuf.Service");
        }
        Service service = (Service)instance;
        Descriptors.ServiceDescriptor descriptor = service.getDescriptorForType();
        List methods = descriptor.getMethods();
        for (Descriptors.MethodDescriptor md : methods) {
            try {
                Message inputType = TypeExctractor.getReqestPrototype(service, md);
                Message outputType = TypeExctractor.getResponsePrototype(service, md);
                this.resolver.addTypes(md, (MessageLite)inputType, (MessageLite)outputType);
            }
            catch (MethodTypeException ex) {
                Logger.getLogger(RpcClientImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this;
    }

    @Override
    public RpcClient addInterface(Class serviceDefinition) {
        Object instance;
        Preconditions.checkNotNull((Object)serviceDefinition);
        Method newReflectiveService = null;
        for (Method m : serviceDefinition.getMethods()) {
            if (!m.getName().equals("newReflectiveService")) continue;
            newReflectiveService = m;
            break;
        }
        if (newReflectiveService == null) {
            throw new IllegalStateException("class " + serviceDefinition + " is not a service defining class");
        }
        try {
            instance = newReflectiveService.invoke(null, new Object[]{null});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        this.addProtobuferRpcInterface(instance);
        return this;
    }

    @Override
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public void stop() {
        this.running = false;
        try {
            this.runningLock.lock();
            this.noLongerRunning.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.runningLock.unlock();
        }
        if (this.channel.isOpen() && this.channel.isBound()) {
            try {
                log.info("about to close stuff");
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Something went wrong when closing channel:  " + this.channel, e);
            }
        }
    }

    private void sendInvocation(RpcClientSideInvocation invocation, Long rpcIndex) {
        Preconditions.checkNotNull((Object)invocation);
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        Descriptors.MethodDescriptor md = invocation.getMethod();
        String methodName = md.getFullName();
        String inputType = md.getInputType().getFullName();
        String outputType = md.getOutputType().getFullName();
        Message request = invocation.getRequest();
        RpcClientController controller = invocation.getController();
        boolean multiReturn = controller.isMultiReturn();
        boolean noReturn = controller.isNoReturn();
        this.wire.sendInvocation(methodName, inputType, outputType, rpcIndex, request, multiReturn, noReturn);
    }
}

