/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.peer.wireprotocol;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.rmz.blobee.rpc.peer.wireprotocol.OutgoingRpcAdapter;
import no.rmz.blobeeproto.api.proto.Rpc;
import org.jboss.netty.channel.Channel;

public final class OutgoingRpcAdapterImpl
implements OutgoingRpcAdapter {
    private static final Logger log = Logger.getLogger(OutgoingRpcAdapterImpl.class.getName());
    private static final Rpc.RpcControl HEARTBEAT = Rpc.RpcControl.newBuilder().setMessageType(Rpc.MessageType.HEARTBEAT).build();
    private final Channel channel;

    public OutgoingRpcAdapterImpl(Channel channel) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel);
    }

    private ByteString messageToByteString(Message msg) {
        Preconditions.checkNotNull((Object)msg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(msg.getSerializedSize());
        try {
            msg.writeTo((OutputStream)baos);
            baos.close();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Couldn't serialize payload", ex);
        }
        ByteString payload = ByteString.copyFrom((byte[])baos.toByteArray());
        Preconditions.checkNotNull((Object)payload);
        return payload;
    }

    @Override
    public void sendInvocation(String methodName, String inputType, String outputType, Long rpcIndex, Message rpParameter, boolean multiReturn, boolean noReturn) {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)inputType);
        Preconditions.checkNotNull((Object)outputType);
        Preconditions.checkNotNull((Object)rpParameter);
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        ByteString payload = this.messageToByteString(rpParameter);
        Rpc.MethodSignature ms = Rpc.MethodSignature.newBuilder().setMethodName(methodName).setInputType(inputType).setOutputType(outputType).build();
        Rpc.RpcControl rpcInvocationMessage = Rpc.RpcControl.newBuilder().setMessageType(Rpc.MessageType.RPC_INV).setRpcIndex(rpcIndex).setMethodSignature(ms).setMultiReturn(multiReturn).setNoReturn(noReturn).setPayload(payload).build();
        this.channel.write((Object)rpcInvocationMessage);
    }

    @Override
    public void returnRpcResult(long rpcIndex, Rpc.MethodSignature methodSignature, Message result, boolean multiReturn) {
        ByteString payload = this.messageToByteString(result);
        Rpc.RpcControl returnValueMessage = Rpc.RpcControl.newBuilder().setMessageType(Rpc.MessageType.RPC_RET).setRpcIndex(rpcIndex).setPayload(payload).setMethodSignature(methodSignature).setMultiReturn(multiReturn).build();
        this.channel.write((Object)returnValueMessage);
    }

    @Override
    public void sendHeartbeat() {
        this.channel.write((Object)HEARTBEAT);
    }

    @Override
    public void sendCancelMessage(long rpcIndex) {
        Rpc.RpcControl cancelMessage = Rpc.RpcControl.newBuilder().setMessageType(Rpc.MessageType.RPC_CANCEL).setRpcIndex(rpcIndex).build();
        this.channel.write((Object)cancelMessage);
    }

    @Override
    public void sendInvocationFailedMessage(long rpcIndex, String reason) {
        Preconditions.checkNotNull((Object)reason);
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        Rpc.RpcControl failedMessage = Rpc.RpcControl.newBuilder().setMessageType(Rpc.MessageType.INVOCATION_FAILED).setRpcIndex(rpcIndex).setFailed(reason).build();
        this.channel.write((Object)failedMessage);
    }

    @Override
    public void terminateMultiReturnSequence(long rpcIndex) {
        Rpc.RpcControl failedMessage = Rpc.RpcControl.newBuilder().setMessageType(Rpc.MessageType.TERMINATE_MULTI_SEQUENCE).setRpcIndex(rpcIndex).build();
    }
}

