/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.server;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import no.rmz.blobee.controllers.RpcServiceController;
import no.rmz.blobee.rpc.server.RpcExecutionServiceImpl;
import org.jboss.netty.channel.ChannelHandlerContext;

public final class ControllerStorage {
    private final Map<RpcExecutionServiceImpl.ControllerCoordinate, RpcServiceController> map = new ConcurrentHashMap<RpcExecutionServiceImpl.ControllerCoordinate, RpcServiceController>();

    public void storeController(ChannelHandlerContext ctx, long rpcIdx, RpcServiceController controller) {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkArgument((rpcIdx >= 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)controller);
        this.map.put(new RpcExecutionServiceImpl.ControllerCoordinate(ctx, rpcIdx), controller);
    }

    public RpcServiceController removeController(ChannelHandlerContext ctx, long rpcIdx) {
        return this.map.remove(new RpcExecutionServiceImpl.ControllerCoordinate(ctx, rpcIdx));
    }

    public RpcServiceController getController(ChannelHandlerContext ctx, long rpcIdx) {
        RpcServiceController result = this.map.get(new RpcExecutionServiceImpl.ControllerCoordinate(ctx, rpcIdx));
        return result;
    }
}

