/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.server;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.rmz.blobee.controllers.RpcServiceController;
import no.rmz.blobee.rpc.methods.ResolverImpl;
import no.rmz.blobee.rpc.methods.ServerSideMethodDesc;
import no.rmz.blobee.rpc.peer.RemoteExecutionContext;
import no.rmz.blobee.rpc.server.ControllerStorage;
import no.rmz.blobee.rpc.server.MethodInvokingRunnable;
import no.rmz.blobee.rpc.server.RpcExecutionService;
import no.rmz.blobee.rpc.server.RpcServerException;
import no.rmz.blobee.rpc.server.ServiceAnnotationMapper;
import no.rmz.blobee.threads.ErrorLoggingThreadFactory;
import no.rmz.blobeeproto.api.proto.Rpc;
import org.jboss.netty.channel.ChannelHandlerContext;

public final class RpcExecutionServiceImpl
implements RpcExecutionService {
    private static final Logger log = Logger.getLogger(RpcExecutionServiceImpl.class.getName());
    private final ExecutorService threadPool = Executors.newCachedThreadPool(new ErrorLoggingThreadFactory("Executor thread for RpcExecutionServiceImpl", log));
    private Map<Rpc.MethodSignature, ServerSideMethodDesc> xmap = new ConcurrentHashMap<Rpc.MethodSignature, ServerSideMethodDesc>();
    private Object implementation;
    private Map<Class, Object> implementations = new HashMap<Class, Object>();
    private final ControllerStorage controllerStorage = new ControllerStorage();
    private final String name;

    @Override
    public Class getReturnType(Rpc.MethodSignature sig) {
        Preconditions.checkNotNull((Object)((Object)sig));
        Class result = this.xmap.get((Object)sig).getReturnType();
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    @Override
    public Class getParameterType(Rpc.MethodSignature sig) {
        Preconditions.checkNotNull((Object)((Object)sig));
        ServerSideMethodDesc ms = this.xmap.get((Object)sig);
        if (ms != null) {
            return ms.getPmType();
        }
        return null;
    }

    public RpcExecutionServiceImpl(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public void addImplementation(Object implementation, Class interfaceClasses) throws RpcServerException {
        this.addImplementation(implementation, new Class[]{interfaceClasses});
    }

    private void addImplementation(Object implementation, Class[] interfaceClasses) throws RpcServerException {
        this.implementation = Preconditions.checkNotNull((Object)implementation);
        HashSet ifaces = new HashSet();
        for (Class<?> clazz : implementation.getClass().getClasses()) {
            ifaces.add(clazz);
        }
        for (Class<?> clazz : interfaceClasses) {
            if (!this.implementations.containsKey(clazz)) continue;
            throw new RpcServerException("Interface " + clazz + " already has an implementation");
        }
        log.info("The interfaces are " + ifaces);
        for (Class<?> clazz : interfaceClasses) {
            if (!ifaces.contains(clazz)) {
                throw new RpcServerException("The implementation " + implementation + "does not implement interface " + clazz);
            }
            for (Method interfaceMethod : clazz.getMethods()) {
                Descriptors.MethodDescriptor descriptor;
                TypeVariable<Method>[] typeParameters = interfaceMethod.getTypeParameters();
                String name = interfaceMethod.getName();
                try {
                    descriptor = ServiceAnnotationMapper.getMethodDescriptor(implementation.getClass(), name);
                }
                catch (Exception ex) {
                    throw new RpcServerException(ex);
                }
                Rpc.MethodSignature methodSignature = ResolverImpl.getMethodSignatureFromMethodDescriptor(descriptor);
                Method implementationMethod = this.findMethod(name, implementation.getClass());
                if (implementationMethod == null) {
                    throw new IllegalStateException("Unknown method " + name);
                }
                Class<?>[] parameterTypes = implementationMethod.getParameterTypes();
                Class<?> pmtype = parameterTypes[1];
                Type typeOfReturnvalue = RpcExecutionServiceImpl.extractCallbackParamType(interfaceMethod);
                ServerSideMethodDesc methodDesc = new ServerSideMethodDesc(implementationMethod, (Class)typeOfReturnvalue, pmtype);
                this.xmap.put(methodSignature, methodDesc);
                this.implementations.put(clazz, implementation);
            }
        }
    }

    private static Type extractCallbackParamType(Method interfaceMethod) {
        Preconditions.checkNotNull((Object)interfaceMethod);
        Type rpcCallbackType = interfaceMethod.getGenericParameterTypes()[2];
        ParameterizedType ptype = (ParameterizedType)rpcCallbackType;
        Type[] actualTypeArguments = ptype.getActualTypeArguments();
        Type typeOfReturnvalue = actualTypeArguments[0];
        return typeOfReturnvalue;
    }

    private Method findMethod(String name, Class clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public void removeController(ChannelHandlerContext ctx, long rpcIndex) {
        this.controllerStorage.removeController(ctx, rpcIndex);
    }

    @Override
    public void execute(RemoteExecutionContext dc, ChannelHandlerContext ctx, Message parameter, boolean multiReturn, boolean noReturn) {
        Preconditions.checkNotNull((Object)dc);
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkNotNull((Object)parameter);
        MethodInvokingRunnable runnable = new MethodInvokingRunnable(this.implementation, dc, ctx, parameter, this.controllerStorage, this, multiReturn, noReturn);
        try {
            this.threadPool.submit(runnable);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't submit runnable.  That's awful!", e);
        }
    }

    @Override
    public void startCancel(ChannelHandlerContext ctx, long rpcIndex) {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkArgument((rpcIndex >= 0L ? 1 : 0) != 0);
        this.controllerStorage.getController(ctx, rpcIndex).startCancel();
        this.controllerStorage.removeController(ctx, rpcIndex);
    }

    public Method getMethod(Rpc.MethodSignature ms) {
        Preconditions.checkNotNull((Object)((Object)ms));
        ServerSideMethodDesc item = this.xmap.get((Object)ms);
        if (item != null) {
            return item.getMethod();
        }
        return null;
    }

    public void storeController(ChannelHandlerContext ctx, long rpcIdx, RpcServiceController controller) {
        Preconditions.checkArgument((rpcIdx >= 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)controller);
        Preconditions.checkNotNull((Object)ctx);
        this.controllerStorage.storeController(ctx, rpcIdx, controller);
    }

    public static final class ControllerCoordinate {
        private final ChannelHandlerContext ctx;
        private final Long rpcIdx;

        public ControllerCoordinate(ChannelHandlerContext ctx, long rpcIdx) {
            this.ctx = (ChannelHandlerContext)Preconditions.checkNotNull((Object)ctx);
            Preconditions.checkArgument((rpcIdx >= 0L ? 1 : 0) != 0);
            this.rpcIdx = rpcIdx;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.rpcIdx, this.ctx});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ControllerCoordinate) {
                ControllerCoordinate ob = (ControllerCoordinate)obj;
                return Objects.equal((Object)this.ctx, (Object)ob.ctx) && Objects.equal((Object)this.rpcIdx, (Object)ob.rpcIdx);
            }
            return false;
        }
    }
}

