/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.rpc.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.Service;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import no.rmz.blobee.rpc.client.MultiChannelClientFactory;
import no.rmz.blobee.rpc.peer.RpcMessageListener;
import no.rmz.blobee.rpc.peer.RpcPeerPipelineFactory;
import no.rmz.blobee.rpc.server.RpcExecutionService;
import no.rmz.blobee.rpc.server.RpcExecutionServiceImpl;
import no.rmz.blobee.rpc.server.RpcServer;
import no.rmz.blobee.rpc.server.RpcServerException;
import no.rmz.blobee.threads.ErrorLoggingThreadFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public final class RpcServerImpl
implements RpcServer {
    private static final Logger log = Logger.getLogger(RpcServerImpl.class.getName());
    private final InetSocketAddress socket;
    private final RpcExecutionService executionService;
    private final RpcMessageListener listener;
    private final ServerBootstrap bootstrap;
    private final ExecutorService bossExecutor;
    private final ExecutorService workerExcecutor;

    public RpcServerImpl(InetSocketAddress socket, RpcMessageListener listener) {
        this(socket, new RpcExecutionServiceImpl("Execution service for server listening on " + socket.toString()), listener);
    }

    public RpcServerImpl(InetSocketAddress socket, RpcExecutionService executionService, RpcMessageListener listener) {
        this.socket = (InetSocketAddress)Preconditions.checkNotNull((Object)socket);
        this.executionService = (RpcExecutionService)Preconditions.checkNotNull((Object)executionService);
        this.listener = listener;
        this.bossExecutor = Executors.newCachedThreadPool(new ErrorLoggingThreadFactory("RpcServerImpl bossExecutor", log));
        this.workerExcecutor = Executors.newCachedThreadPool(new ErrorLoggingThreadFactory("RpcServerImpl workerExcecutor", log));
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExcecutor));
        String name = "RPC Server at " + socket.toString();
        RpcPeerPipelineFactory serverChannelPipelineFactory = new RpcPeerPipelineFactory(name, executionService, new MultiChannelClientFactory(), listener);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)serverChannelPipelineFactory);
    }

    @Override
    public RpcServer start() {
        this.bootstrap.bind((SocketAddress)this.socket);
        return this;
    }

    public RpcServer addImplementation(Service service, Class implementation) throws RpcServerException {
        Preconditions.checkNotNull((Object)service);
        Preconditions.checkNotNull((Object)implementation);
        this.executionService.addImplementation(service, implementation);
        return this;
    }

    @Override
    public void stop() {
        this.bootstrap.shutdown();
        this.bossExecutor.shutdownNow();
        this.workerExcecutor.shutdownNow();
    }
}

