/*
 * Decompiled with CFR 0.152.
 */
package no.rmz.blobee.threads;

import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ErrorLoggingThreadFactory
implements ThreadFactory {
    private final Logger log;
    private final String name;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public ErrorLoggingThreadFactory(String name, final Logger log) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.log(Level.SEVERE, "Uncaught exception in thrad " + t, e);
            }
        };
    }

    @Override
    public Thread newThread(Runnable r) {
        Preconditions.checkNotNull((Object)r);
        Thread thread = new Thread(r, this.name);
        thread.setUncaughtExceptionHandler(this.exceptionHandler);
        return thread;
    }
}

