/*
 * Decompiled with CFR 0.152.
 */
package no.shhsoft.k3aembedded;

import java.nio.file.Path;
import no.shhsoft.k3aembedded.FileUtils;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;

final class ZooKeeper {
    private final int port;
    private Path zkDirectory;
    private ZooKeeperServerMain zooKeeperServerMain;

    public ZooKeeper(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.zkDirectory = FileUtils.createTempDirectory("zk");
            ServerConfig config = new ServerConfig();
            config.parse(new String[]{String.valueOf(this.port), this.zkDirectory.toString()});
            this.zooKeeperServerMain = new ZooKeeperServerMain(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void serverStarted() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        ((Object)((Object)this)).notifyAll();
                    }
                }
            };
            Thread thread = new Thread(() -> {
                try {
                    this.zooKeeperServerMain.runFromConfig(config);
                    System.out.println("ZooKeeper stopped");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            thread.setDaemon(true);
            thread.start();
            ZooKeeperServerMain zooKeeperServerMain = this.zooKeeperServerMain;
            synchronized (zooKeeperServerMain) {
                this.zooKeeperServerMain.wait();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.zooKeeperServerMain == null) {
            return;
        }
        this.zooKeeperServerMain.close();
        FileUtils.deleteRecursively(this.zkDirectory.toFile());
        this.zooKeeperServerMain = null;
    }

    public static void main(String[] args) {
        ZooKeeper zk = new ZooKeeper(2181);
        zk.start();
        System.out.println("Started");
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Stopping...");
        zk.stop();
        System.out.println("Done stopping");
    }
}

