/*
 * Decompiled with CFR 0.152.
 */
package no.shhsoft.k3aembedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class FileUtils {
    private FileUtils() {
    }

    public static Path createTempDirectory(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursively(File directory) {
        File[] filesAndDirectories = directory.listFiles();
        if (filesAndDirectories != null) {
            for (File containedFileOrDirectory : filesAndDirectories) {
                if (containedFileOrDirectory.isDirectory()) {
                    FileUtils.deleteRecursively(containedFileOrDirectory);
                }
                FileUtils.delete(containedFileOrDirectory);
            }
        }
        FileUtils.delete(directory);
    }

    private static void delete(File fileOrDirectory) {
        if (!fileOrDirectory.delete()) {
            System.err.println("Unable to delete \"" + fileOrDirectory + "\". Ignoring.");
        }
    }
}

