/*
 * Decompiled with CFR 0.152.
 */
package no.shhsoft.k3aembedded;

import java.util.HashMap;
import java.util.Map;
import no.shhsoft.k3aembedded.K3aEmbedded;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public final class K3aTestUtils {
    private K3aTestUtils() {
    }

    public static Map<String, Object> consumerProps(String group, boolean autoCommit, K3aEmbedded k3aEmbedded) {
        return K3aTestUtils.consumerProps(k3aEmbedded.getBootstrapServers(), group, autoCommit);
    }

    public static Map<String, Object> producerProps(K3aEmbedded k3aEmbedded) {
        return K3aTestUtils.producerProps(k3aEmbedded.getBootstrapServers());
    }

    public static Map<String, Object> adminProps(K3aEmbedded k3aEmbedded) {
        return K3aTestUtils.adminProps(k3aEmbedded.getBootstrapServers());
    }

    public static Map<String, Object> consumerProps(String bootstrapServers, String group, boolean autoCommit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", bootstrapServers);
        map.put("group.id", group);
        map.put("enable.auto.commit", autoCommit);
        map.put("auto.commit.interval.ms", "10");
        map.put("auto.offset.reset", "earliest");
        map.put("key.deserializer", IntegerDeserializer.class);
        map.put("value.deserializer", StringDeserializer.class);
        return map;
    }

    public static Map<String, Object> producerProps(String bootstrapServers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", bootstrapServers);
        map.put("acks", "all");
        map.put("delivery.timeout.ms", "3000");
        map.put("request.timeout.ms", "3000");
        map.put("linger.ms", "0");
        map.put("retries", "0");
        map.put("key.serializer", IntegerSerializer.class);
        map.put("value.serializer", StringSerializer.class);
        return map;
    }

    public static Map<String, Object> adminProps(String bootstrapServers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", bootstrapServers);
        return map;
    }
}

