/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.cluster.services;

import com.genghis.tools.cluster.services.GenghisServicesKt;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Deployable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.serviceproxy.ServiceBinder;
import io.vertx.serviceproxy.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\u00020\u0001:\u00029:B\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00142\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000fH\u0007J$\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000f2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001c0\u001bH\u0007J$\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000f2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0007J)\u0010\"\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010!\u001a\u0002H#H\u0007\u00a2\u0006\u0002\u0010&J1\u0010\"\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u0002H#H\u0007\u00a2\u0006\u0002\u0010(J=\u0010\"\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010!\u001a\u0002H#2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001c0\u001bH\u0007\u00a2\u0006\u0002\u0010)JE\u0010\"\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u0002H#2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001c0\u001bH\u0007\u00a2\u0006\u0002\u0010*J$\u0010+\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010!\u001a\u00020\u000fH\u0007J8\u0010+\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010!\u001a\u00020\u000f2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0007J.\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000f2\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0007J$\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\u001c0\u001bH\u0007J0\u00100\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u001c0\u001bH\u0007J8\u00100\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010'\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u001c0\u001bH\u0007J$\u00101\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\u001c0\u001bH\u0002J0\u00102\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u001c0\u001bH\u0002J8\u00102\u001a\u00020\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010,\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u001c0\u001bH\u0002J\u001c\u00103\u001a\u00020\u000f\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0002J$\u00103\u001a\u00020\u000f\"\u0004\b\u0000\u0010#2\u0006\u0010,\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0002J2\u0010\"\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u000f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000f062\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001c0\u001bH\u0002J\u0016\u00107\u001a\u00020\u00142\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001cH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/genghis/tools/cluster/services/ServiceManager;", "", "<init>", "()V", "vertx", "Lio/vertx/core/Vertx;", "(Lio/vertx/core/Vertx;)V", "serviceDiscovery", "Lio/vertx/servicediscovery/ServiceDiscovery;", "registeredServices", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/vertx/core/eventbus/MessageConsumer;", "Lio/vertx/core/json/JsonObject;", "registeredRecords", "Lio/vertx/servicediscovery/Record;", "fetchedServices", "", "serviceAnnounceConsumer", "startServiceManagerKillVerticle", "", "openDiscovery", "handleServiceEvent", "serviceEvent", "Lio/vertx/core/eventbus/Message;", "closeDiscovery", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Ljava/lang/Void;", "publishApi", "httpRecord", "unPublishApi", "service", "publishService", "T", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;Ljava/lang/Object;)Lcom/genghis/tools/cluster/services/ServiceManager;", "customName", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Object;)Lcom/genghis/tools/cluster/services/ServiceManager;", "(Ljava/lang/Class;Ljava/lang/Object;Lio/vertx/core/Handler;)Lcom/genghis/tools/cluster/services/ServiceManager;", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Object;Lio/vertx/core/Handler;)Lcom/genghis/tools/cluster/services/ServiceManager;", "unPublishService", "serviceName", "consumeApi", "name", "Lio/vertx/core/http/HttpClient;", "consumeService", "getApi", "getService", "createRecord", "record", "recordLogic", "Ljava/util/function/Consumer;", "handlePublishResult", "publishResult", "KillVerticle", "Companion", "genghis-tools-cluster"})
public final class ServiceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ServiceDiscovery serviceDiscovery;
    @NotNull
    private final ConcurrentHashMap<String, MessageConsumer<JsonObject>> registeredServices = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, Record> registeredRecords = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, Set<Object>> fetchedServices = new ConcurrentHashMap();
    private Vertx vertx;
    @Nullable
    private MessageConsumer<JsonObject> serviceAnnounceConsumer;
    private static final int NOT_FOUND = 404;
    private static final int INTERNAL_ERROR = 500;
    @NotNull
    private static final Map<Vertx, ServiceManager> instanceMap = new LinkedHashMap();
    private static ServiceManager singleton;

    private ServiceManager() {
        throw new IllegalArgumentException("Should never run!");
    }

    private ServiceManager(Vertx vertx) {
        this.vertx = vertx;
        this.openDiscovery();
        this.startServiceManagerKillVerticle();
    }

    private final void startServiceManagerKillVerticle() {
        Vertx vertx = this.vertx;
        if (vertx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
            vertx = null;
        }
        vertx.deployVerticle((Deployable)new KillVerticle());
    }

    private final void openDiscovery() {
        GenghisServicesKt.access$getLogger$p().debug(ServiceManager::openDiscovery$lambda$0);
        if (this.serviceDiscovery == null) {
            Vertx vertx = this.vertx;
            if (vertx == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
                vertx = null;
            }
            this.serviceDiscovery = ServiceDiscovery.create((Vertx)vertx, (ServiceDiscoveryOptions)new ServiceDiscoveryOptions().setAnnounceAddress("com.genghis.services.manager.announce").setUsageAddress("com.genghis.services.manager.announce").setName("genghis-service-manager-service-discovery"));
            GenghisServicesKt.access$getLogger$p().debug(ServiceManager::openDiscovery$lambda$1);
            Vertx vertx2 = this.vertx;
            if (vertx2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
                vertx2 = null;
            }
            this.serviceAnnounceConsumer = vertx2.eventBus().consumer("com.genghis.services.manager.announce", arg_0 -> ServiceManager.openDiscovery$lambda$2(this, arg_0));
        }
        GenghisServicesKt.access$getLogger$p().debug(ServiceManager::openDiscovery$lambda$3);
    }

    private final void handleServiceEvent(Message<JsonObject> serviceEvent) {
        MultiMap headers = serviceEvent.headers();
        JsonObject body = (JsonObject)serviceEvent.body();
        GenghisServicesKt.access$getLogger$p().trace(() -> ServiceManager.handleServiceEvent$lambda$4(serviceEvent, headers, body));
        String name = body.getString("name");
        String status = body.getString("status");
        if (status != null && Intrinsics.areEqual((Object)status, (Object)"DOWN")) {
            GenghisServicesKt.access$getLogger$p().debug(() -> ServiceManager.handleServiceEvent$lambda$5(name));
            this.fetchedServices.remove(name);
        }
    }

    private final void closeDiscovery(Handler<AsyncResult<Void>> resultHandler) {
        if (this.serviceDiscovery != null) {
            ServiceDiscovery serviceDiscovery = this.serviceDiscovery;
            Intrinsics.checkNotNull((Object)serviceDiscovery);
            serviceDiscovery.close();
        }
        this.serviceDiscovery = null;
        GenghisServicesKt.access$getLogger$p().debug(ServiceManager::closeDiscovery$lambda$6);
        if (this.serviceAnnounceConsumer != null) {
            MessageConsumer<JsonObject> messageConsumer = this.serviceAnnounceConsumer;
            Intrinsics.checkNotNull(messageConsumer);
            messageConsumer.unregister().onFailure(arg_0 -> ServiceManager.closeDiscovery$lambda$8(arg_0 -> ServiceManager.closeDiscovery$lambda$7(resultHandler, arg_0), arg_0)).onSuccess(arg_0 -> ServiceManager.closeDiscovery$lambda$10(arg_0 -> ServiceManager.closeDiscovery$lambda$9(resultHandler, arg_0), arg_0));
        }
    }

    @Fluent
    @NotNull
    public final ServiceManager publishApi(@NotNull Record httpRecord) {
        Intrinsics.checkNotNullParameter((Object)httpRecord, (String)"httpRecord");
        return this.publishService(httpRecord, arg_0 -> ServiceManager.publishApi$lambda$11(this, arg_0), (Handler<AsyncResult<Record>>)((Handler)arg_0 -> ServiceManager.publishApi$lambda$12(this, arg_0)));
    }

    @Fluent
    @NotNull
    public final ServiceManager publishApi(@NotNull Record httpRecord, @NotNull Handler<AsyncResult<Record>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)httpRecord, (String)"httpRecord");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        return this.publishService(httpRecord, arg_0 -> ServiceManager.publishApi$lambda$13(this, arg_0), resultHandler);
    }

    @Fluent
    @NotNull
    public final ServiceManager unPublishApi(@NotNull Record service, @NotNull Handler<AsyncResult<Void>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        this.registeredRecords.remove(service.getRegistration());
        ServiceDiscovery serviceDiscovery = this.serviceDiscovery;
        Intrinsics.checkNotNull((Object)serviceDiscovery);
        serviceDiscovery.unpublish(service.getRegistration()).onComplete(resultHandler);
        Set<Object> objects = this.fetchedServices.get(service.getName());
        if (objects != null && objects.size() > 0) {
            Iterator<Object> iterator = objects.iterator();
            iterator.next();
            iterator.remove();
        }
        return this;
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager publishService(@NotNull Class<T> type, T service) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String serviceName = type.getSimpleName();
        Intrinsics.checkNotNull((Object)serviceName);
        return this.publishService(this.createRecord(serviceName, type), arg_0 -> ServiceManager.publishService$lambda$14(this, serviceName, type, service, arg_0), (Handler<AsyncResult<Record>>)((Handler)arg_0 -> ServiceManager.publishService$lambda$15(this, arg_0)));
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager publishService(@NotNull Class<T> type, @NotNull String customName, T service) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)customName, (String)"customName");
        return this.publishService(this.createRecord(customName, type), arg_0 -> ServiceManager.publishService$lambda$16(this, customName, type, service, arg_0), (Handler<AsyncResult<Record>>)((Handler)arg_0 -> ServiceManager.publishService$lambda$17(this, arg_0)));
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager publishService(@NotNull Class<T> type, T service, @NotNull Handler<AsyncResult<Record>> resultHandler) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        return this.publishService(this.createRecord(type), arg_0 -> ServiceManager.publishService$lambda$18(this, type, service, arg_0), resultHandler);
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager publishService(@NotNull Class<T> type, @NotNull String customName, T service, @NotNull Handler<AsyncResult<Record>> resultHandler) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)customName, (String)"customName");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        return this.publishService(this.createRecord(customName, type), arg_0 -> ServiceManager.publishService$lambda$19(this, customName, type, service, arg_0), resultHandler);
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager unPublishService(@NotNull Class<T> type, @NotNull Record service) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        String serviceName = type.getSimpleName();
        Intrinsics.checkNotNull((Object)serviceName);
        return ServiceManager.unPublishService$default(this, serviceName, service, null, 4, null);
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager unPublishService(@NotNull Class<T> type, @NotNull Record service, @NotNull Handler<AsyncResult<Void>> resultHandler) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        String serviceName = type.getSimpleName();
        Intrinsics.checkNotNull((Object)serviceName);
        return this.unPublishService(serviceName, service, resultHandler);
    }

    @Fluent
    @JvmOverloads
    @NotNull
    public final ServiceManager unPublishService(@NotNull String serviceName, @NotNull Record service, @NotNull Handler<AsyncResult<Void>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        Vertx vertx = this.vertx;
        if (vertx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
            vertx = null;
        }
        new ServiceBinder(vertx).setAddress(serviceName).unregister(this.registeredServices.get(service.getRegistration()));
        ServiceDiscovery serviceDiscovery = this.serviceDiscovery;
        Intrinsics.checkNotNull((Object)serviceDiscovery);
        serviceDiscovery.unpublish(service.getRegistration()).onComplete(arg_0 -> ServiceManager.unPublishService$lambda$22(this, service, resultHandler, arg_0));
        return this;
    }

    public static /* synthetic */ ServiceManager unPublishService$default(ServiceManager serviceManager, String string, Record record, Handler handler, int n, Object object) {
        if ((n & 4) != 0) {
            handler = ServiceManager::unPublishService$lambda$21;
        }
        return serviceManager.unPublishService(string, record, (Handler<AsyncResult<Void>>)handler);
    }

    @Fluent
    @NotNull
    public final ServiceManager consumeApi(@NotNull String name, @NotNull Handler<AsyncResult<HttpClient>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        return this.getApi(name, resultHandler);
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager consumeService(@NotNull Class<T> type, @NotNull Handler<AsyncResult<T>> resultHandler) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        String string = type.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return this.consumeService(type, string, resultHandler);
    }

    @Fluent
    @NotNull
    public final <T> ServiceManager consumeService(@NotNull Class<T> type, @NotNull String customName, @NotNull Handler<AsyncResult<T>> resultHandler) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)customName, (String)"customName");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        return this.getService(type, customName, resultHandler);
    }

    private final ServiceManager getApi(String name, Handler<AsyncResult<HttpClient>> resultHandler) {
        GenghisServicesKt.access$getLogger$p().debug(() -> ServiceManager.getApi$lambda$23(name));
        Set<Object> existingServices = this.fetchedServices.get(name);
        if (existingServices != null && existingServices.size() > 0) {
            GenghisServicesKt.access$getLogger$p().debug(ServiceManager::getApi$lambda$24);
            ArrayList objects = new ArrayList(existingServices);
            Collections.shuffle(objects);
            Object e = objects.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type io.vertx.core.http.HttpClient");
            resultHandler.handle((Object)Future.succeededFuture((Object)((HttpClient)e)));
        } else {
            ServiceDiscovery serviceDiscovery = this.serviceDiscovery;
            Intrinsics.checkNotNull((Object)serviceDiscovery);
            HttpEndpoint.getClient((ServiceDiscovery)serviceDiscovery, (JsonObject)new JsonObject().put("name", (Object)name)).onComplete(arg_0 -> ServiceManager.getApi$lambda$26(resultHandler, this, name, arg_0));
        }
        return this;
    }

    private final <T> ServiceManager getService(Class<T> type, Handler<AsyncResult<T>> resultHandler) {
        String string = type.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return this.getService(type, string, resultHandler);
    }

    private final <T> ServiceManager getService(Class<T> type, String serviceName, Handler<AsyncResult<T>> resultHandler) {
        GenghisServicesKt.access$getLogger$p().debug(() -> ServiceManager.getService$lambda$27(serviceName));
        Set<Object> existingServices = this.fetchedServices.get(serviceName);
        if (existingServices != null && existingServices.size() > 0) {
            GenghisServicesKt.access$getLogger$p().debug(ServiceManager::getService$lambda$28);
            ArrayList objects = new ArrayList(existingServices);
            Collections.shuffle(objects);
            resultHandler.handle((Object)Future.succeededFuture(objects.get(0)));
        } else {
            ServiceDiscovery serviceDiscovery = this.serviceDiscovery;
            Intrinsics.checkNotNull((Object)serviceDiscovery);
            EventBusService.getProxy((ServiceDiscovery)serviceDiscovery, type).onComplete(arg_0 -> ServiceManager.getService$lambda$31(resultHandler, serviceName, this, arg_0));
        }
        return this;
    }

    private final <T> Record createRecord(Class<T> type) {
        String string = type.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return this.createRecord(string, type);
    }

    private final <T> Record createRecord(String serviceName, Class<T> type) {
        Record record = EventBusService.createRecord((String)serviceName, (String)serviceName, type);
        Intrinsics.checkNotNullExpressionValue((Object)record, (String)"createRecord(...)");
        return record;
    }

    private final ServiceManager publishService(Record record, Consumer<Record> recordLogic, Handler<AsyncResult<Record>> resultHandler) {
        ServiceDiscovery serviceDiscovery = this.serviceDiscovery;
        Intrinsics.checkNotNull((Object)serviceDiscovery);
        serviceDiscovery.publish(record).onComplete(arg_0 -> ServiceManager.publishService$lambda$34(resultHandler, this, recordLogic, record, arg_0));
        return this;
    }

    private final void handlePublishResult(AsyncResult<Record> publishResult) {
        if (publishResult.failed()) {
            if (publishResult.cause() instanceof ServiceException) {
                Throwable throwable = publishResult.cause();
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type io.vertx.serviceproxy.ServiceException");
                ServiceException serviceException = (ServiceException)throwable;
                GenghisServicesKt.access$getLogger$p().error(() -> ServiceManager.handlePublishResult$lambda$35(serviceException));
            } else {
                GenghisServicesKt.access$getLogger$p().error(() -> ServiceManager.handlePublishResult$lambda$36(publishResult));
            }
        } else {
            Record record = (Record)publishResult.result();
            GenghisServicesKt.access$getLogger$p().debug(() -> ServiceManager.handlePublishResult$lambda$37(record));
        }
    }

    @Fluent
    @JvmOverloads
    @NotNull
    public final ServiceManager unPublishService(@NotNull String serviceName, @NotNull Record service) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return ServiceManager.unPublishService$default(this, serviceName, service, null, 4, null);
    }

    private static final Object openDiscovery$lambda$0() {
        return "Opening Discovery...";
    }

    private static final Object openDiscovery$lambda$1() {
        return "Setting Discovery message consumer...";
    }

    private static final void openDiscovery$lambda$2(ServiceManager this$0, Message it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.handleServiceEvent((Message<JsonObject>)it);
    }

    private static final Object openDiscovery$lambda$3() {
        return "Discovery ready...";
    }

    private static final Object handleServiceEvent$lambda$4(Message $serviceEvent, MultiMap $headers, JsonObject $body) {
        return "Service Event:\n" + Json.encodePrettily((Object)$serviceEvent) + "\nHeaders:\n" + Json.encodePrettily((Object)$headers) + "\nBody:\n" + Json.encodePrettily((Object)$body);
    }

    private static final Object handleServiceEvent$lambda$5(String $name) {
        return "Removing downed service: " + $name;
    }

    private static final Object closeDiscovery$lambda$6() {
        return "Unregistering Service Event Listener...";
    }

    private static final Unit closeDiscovery$lambda$7(Handler $resultHandler, Throwable it) {
        $resultHandler.handle((Object)ServiceException.fail((int)500, (String)"Unable to unregister Service Event Listener..."));
        return Unit.INSTANCE;
    }

    private static final void closeDiscovery$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit closeDiscovery$lambda$9(Handler $resultHandler, Void it) {
        $resultHandler.handle((Object)Future.succeededFuture());
        return Unit.INSTANCE;
    }

    private static final void closeDiscovery$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void publishApi$lambda$11(ServiceManager this$0, Record it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Map)this$0.registeredRecords).put(it.getRegistration(), it);
    }

    private static final void publishApi$lambda$12(ServiceManager this$0, AsyncResult it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.handlePublishResult((AsyncResult<Record>)it);
    }

    private static final void publishApi$lambda$13(ServiceManager this$0, Record it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Map)this$0.registeredRecords).put(it.getRegistration(), it);
    }

    private static final void publishService$lambda$14(ServiceManager this$0, String $serviceName, Class $type, Object $service, Record it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map map = this$0.registeredServices;
        String string = it.getRegistration();
        Vertx vertx = this$0.vertx;
        if (vertx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
            vertx = null;
        }
        MessageConsumer messageConsumer = new ServiceBinder(vertx).setTimeoutSeconds(5L).setAddress($serviceName).register($type, $service);
        map.put(string, messageConsumer);
    }

    private static final void publishService$lambda$15(ServiceManager this$0, AsyncResult it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.handlePublishResult((AsyncResult<Record>)it);
    }

    private static final void publishService$lambda$16(ServiceManager this$0, String $customName, Class $type, Object $service, Record it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map map = this$0.registeredServices;
        String string = it.getRegistration();
        Vertx vertx = this$0.vertx;
        if (vertx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
            vertx = null;
        }
        MessageConsumer messageConsumer = new ServiceBinder(vertx).setTimeoutSeconds(5L).setAddress($customName).register($type, $service);
        map.put(string, messageConsumer);
    }

    private static final void publishService$lambda$17(ServiceManager this$0, AsyncResult it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.handlePublishResult((AsyncResult<Record>)it);
    }

    private static final void publishService$lambda$18(ServiceManager this$0, Class $type, Object $service, Record it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map map = this$0.registeredServices;
        String string = it.getRegistration();
        Vertx vertx = this$0.vertx;
        if (vertx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
            vertx = null;
        }
        MessageConsumer messageConsumer = new ServiceBinder(vertx).setTimeoutSeconds(5L).setAddress($type.getSimpleName()).register($type, $service);
        map.put(string, messageConsumer);
    }

    private static final void publishService$lambda$19(ServiceManager this$0, String $customName, Class $type, Object $service, Record it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map map = this$0.registeredServices;
        String string = it.getRegistration();
        Vertx vertx = this$0.vertx;
        if (vertx == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vertx");
            vertx = null;
        }
        MessageConsumer messageConsumer = new ServiceBinder(vertx).setTimeoutSeconds(5L).setAddress($customName).register($type, $service);
        map.put(string, messageConsumer);
    }

    private static final Object unPublishService$lambda$21$lambda$20(AsyncResult $it) {
        return "Unpublish res: " + $it.succeeded();
    }

    private static final void unPublishService$lambda$21(AsyncResult it) {
        GenghisServicesKt.access$getLogger$p().info(() -> ServiceManager.unPublishService$lambda$21$lambda$20(it));
    }

    private static final void unPublishService$lambda$22(ServiceManager this$0, Record $service, Handler $resultHandler, AsyncResult it) {
        if (it.succeeded()) {
            this$0.registeredServices.remove($service.getRegistration());
            Set<Object> objects = this$0.fetchedServices.get($service.getName());
            if (objects != null && objects.size() > 0) {
                Iterator<Object> iterator = objects.iterator();
                iterator.next();
                iterator.remove();
            }
            $resultHandler.handle((Object)Future.succeededFuture());
        } else {
            $resultHandler.handle((Object)ServiceException.fail((int)500, (String)"Unable to unpublish Service..."));
        }
    }

    private static final Object getApi$lambda$23(String $name) {
        return "Getting API: " + $name;
    }

    private static final Object getApi$lambda$24() {
        return "Returning fetched Api...";
    }

    private static final Object getApi$lambda$26$lambda$25() {
        return "Unable to fetch API...";
    }

    private static final void getApi$lambda$26(Handler $resultHandler, ServiceManager this$0, String $name, AsyncResult it) {
        if (it.failed()) {
            GenghisServicesKt.access$getLogger$p().error(ServiceManager::getApi$lambda$26$lambda$25);
            $resultHandler.handle((Object)ServiceException.fail((int)404, (String)"API not found..."));
        } else {
            HttpClient client = (HttpClient)it.result();
            Set<Object> objects = this$0.fetchedServices.get($name);
            if (objects == null) {
                ((Map)this$0.fetchedServices).put($name, new HashSet());
                objects = this$0.fetchedServices.get($name);
            }
            Set<Object> set = objects;
            Intrinsics.checkNotNull(set);
            if (!set.contains(client)) {
                Intrinsics.checkNotNull((Object)client);
                objects.add(client);
            }
            ((Map)this$0.fetchedServices).put($name, objects);
            $resultHandler.handle((Object)Future.succeededFuture((Object)client));
        }
    }

    private static final Object getService$lambda$27(String $serviceName) {
        return "Getting service: " + $serviceName;
    }

    private static final Object getService$lambda$28() {
        return "Returning fetched Api...";
    }

    private static final Object getService$lambda$31$lambda$29(String $serviceName) {
        return "ERROR: Unable to get service for " + $serviceName;
    }

    private static final Object getService$lambda$31$lambda$30(Object $service) {
        return "Successful fetch of: " + $service;
    }

    private static final void getService$lambda$31(Handler $resultHandler, String $serviceName, ServiceManager this$0, AsyncResult it) {
        if (it.failed()) {
            GenghisServicesKt.access$getLogger$p().error(() -> ServiceManager.getService$lambda$31$lambda$29($serviceName));
            $resultHandler.handle((Object)ServiceException.fail((int)404, (String)("Unable to get service for " + $serviceName + " : " + it.cause())));
        } else {
            Object service = it.result();
            Set<Object> objects = this$0.fetchedServices.get($serviceName);
            if (objects == null) {
                ((Map)this$0.fetchedServices).put($serviceName, (Set)new LinkedHashSet());
                objects = this$0.fetchedServices.get($serviceName);
            }
            Set<Object> set = objects;
            Intrinsics.checkNotNull(set);
            if (!CollectionsKt.contains((Iterable)set, (Object)service)) {
                Intrinsics.checkNotNull((Object)service, (String)"null cannot be cast to non-null type kotlin.Any");
                objects.add(service);
            }
            ((Map)this$0.fetchedServices).put($serviceName, objects);
            GenghisServicesKt.access$getLogger$p().debug(() -> ServiceManager.getService$lambda$31$lambda$30(service));
            $resultHandler.handle((Object)Future.succeededFuture((Object)service));
        }
    }

    private static final Object publishService$lambda$34$lambda$32(Record $record) {
        return "ERROR: Failed publish of " + $record.getName() + " to " + $record.getLocation().encodePrettily() + " with " + $record.getType() + " : " + $record.getStatus();
    }

    private static final Object publishService$lambda$34$lambda$33(Record $publishedRecord) {
        return "Successful publish of: " + $publishedRecord.getName() + " to " + $publishedRecord.getLocation().encodePrettily() + " with " + $publishedRecord.getType() + " : " + $publishedRecord.getStatus();
    }

    private static final void publishService$lambda$34(Handler $resultHandler, ServiceManager this$0, Consumer $recordLogic, Record $record, AsyncResult ar) {
        if (ar.failed()) {
            GenghisServicesKt.access$getLogger$p().error(() -> ServiceManager.publishService$lambda$34$lambda$32($record));
            $resultHandler.handle((Object)ServiceException.fail((int)500, (String)ar.cause().getMessage()));
        } else {
            Record publishedRecord = (Record)ar.result();
            ((Map)this$0.registeredRecords).put(publishedRecord.getRegistration(), publishedRecord);
            $recordLogic.accept(publishedRecord);
            GenghisServicesKt.access$getLogger$p().debug(() -> ServiceManager.publishService$lambda$34$lambda$33(publishedRecord));
            $resultHandler.handle((Object)Future.succeededFuture((Object)publishedRecord));
        }
    }

    private static final Object handlePublishResult$lambda$35(ServiceException $serviceException) {
        return "Unable to publish service: " + $serviceException.failureCode() + " : " + $serviceException.getMessage();
    }

    private static final Object handlePublishResult$lambda$36(AsyncResult $publishResult) {
        return "Unable to publish service: " + $publishResult.cause();
    }

    private static final Object handlePublishResult$lambda$37(Record $record) {
        return "Published Service Record: " + $record.getName() + " : " + $record.getLocation() + " : " + $record.getType() + " : " + $record.getStatus();
    }

    public /* synthetic */ ServiceManager(Vertx vertx, DefaultConstructorMarker $constructor_marker) {
        this(vertx);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/genghis/tools/cluster/services/ServiceManager$Companion;", "", "<init>", "()V", "NOT_FOUND", "", "INTERNAL_ERROR", "instanceMap", "", "Lio/vertx/core/Vertx;", "Lcom/genghis/tools/cluster/services/ServiceManager;", "singleton", "getInstance", "vertx", "handleResultFailed", "", "t", "", "genghis-tools-cluster"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServiceManager getInstance() {
            Vertx vertx = Vertx.currentContext().owner();
            Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"owner(...)");
            return this.getInstance(vertx);
        }

        @NotNull
        public final ServiceManager getInstance(@NotNull Vertx vertx) {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            ServiceManager instance = (ServiceManager)instanceMap.get(vertx);
            if (instance != null) {
                return instance;
            }
            singleton = new ServiceManager(vertx, null);
            Map map = instanceMap;
            ServiceManager serviceManager = singleton;
            if (serviceManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"singleton");
                serviceManager = null;
            }
            ServiceManager serviceManager2 = serviceManager;
            map.put(vertx, serviceManager2);
            ServiceManager serviceManager3 = singleton;
            if (serviceManager3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"singleton");
                serviceManager3 = null;
            }
            return serviceManager3;
        }

        public final void handleResultFailed(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (t instanceof ServiceException) {
                GenghisServicesKt.access$getLogger$p().error(t, () -> Companion.handleResultFailed$lambda$0(t));
            } else {
                GenghisServicesKt.access$getLogger$p().error(t, () -> Companion.handleResultFailed$lambda$1(t));
            }
        }

        private static final Object handleResultFailed$lambda$0(Throwable $t) {
            return ((ServiceException)$t).failureCode() + " : " + $t.getMessage();
        }

        private static final Object handleResultFailed$lambda$1(Throwable $t) {
            return String.valueOf($t.getMessage());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/genghis/tools/cluster/services/ServiceManager$KillVerticle;", "Lio/vertx/core/AbstractVerticle;", "<init>", "(Lcom/genghis/tools/cluster/services/ServiceManager;)V", "stop", "", "stopFuture", "Lio/vertx/core/Promise;", "Ljava/lang/Void;", "genghis-tools-cluster"})
    @SourceDebugExtension(value={"SMAP\nGenghisServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenghisServices.kt\ncom/genghis/tools/cluster/services/ServiceManager$KillVerticle\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,832:1\n216#2,2:833\n216#2,2:839\n1563#3:835\n1634#3,3:836\n1869#3,2:841\n*S KotlinDebug\n*F\n+ 1 GenghisServices.kt\ncom/genghis/tools/cluster/services/ServiceManager$KillVerticle\n*L\n287#1:833,2\n311#1:839,2\n305#1:835\n305#1:836,3\n321#1:841,2\n*E\n"})
    private final class KillVerticle
    extends AbstractVerticle {
        /*
         * WARNING - void declaration
         */
        public void stop(@NotNull Promise<Void> stopFuture) throws Exception {
            Intrinsics.checkNotNullParameter(stopFuture, (String)"stopFuture");
            GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$0);
            if (ServiceManager.this.serviceDiscovery != null) {
                void $this$mapTo$iv$iv;
                Record v;
                void $this$forEach$iv;
                GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$1);
                ArrayList<Promise> unPublishFutures = new ArrayList<Promise>();
                Map map = ServiceManager.this.registeredRecords;
                ServiceManager serviceManager = ServiceManager.this;
                boolean $i$f$forEach22 = false;
                for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                    Map.Entry entry = element$iv;
                    boolean bl = false;
                    v = (Record)entry.getValue();
                    Promise unpublish = Promise.promise();
                    ServiceDiscovery serviceDiscovery = serviceManager.serviceDiscovery;
                    Intrinsics.checkNotNull((Object)serviceDiscovery);
                    serviceDiscovery.unpublish(v.getRegistration()).onFailure(arg_0 -> KillVerticle.stop$lambda$8$lambda$4(arg_0 -> KillVerticle.stop$lambda$8$lambda$3(unpublish, v, arg_0), arg_0)).onSuccess(arg_0 -> KillVerticle.stop$lambda$8$lambda$7(arg_0 -> KillVerticle.stop$lambda$8$lambda$6(unpublish, v, arg_0), arg_0));
                    unPublishFutures.add(unpublish);
                }
                Iterable $this$map$iv = unPublishFutures;
                boolean $i$f$map = false;
                Iterable $i$f$forEach22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    v = (Promise)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.future());
                }
                v1 = Future.all((List)((List)destination$iv$iv)).andThen(arg_0 -> KillVerticle.stop$lambda$19(ServiceManager.this, this, stopFuture, arg_0));
            } else {
                GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$20);
                instanceMap.remove(this.vertx);
                v1 = stopFuture.tryComplete();
            }
        }

        private static final Object stop$lambda$0() {
            return "Destroying ServiceManager";
        }

        private static final Object stop$lambda$1() {
            return "Unpublishing all records...";
        }

        private static final Object stop$lambda$8$lambda$3$lambda$2(Record $v) {
            return "Failed Unpublish: " + $v.getName();
        }

        private static final Unit stop$lambda$8$lambda$3(Promise $unpublish, Record $v, Throwable it) {
            GenghisServicesKt.access$getLogger$p().info(it, () -> KillVerticle.stop$lambda$8$lambda$3$lambda$2($v));
            $unpublish.fail(it);
            return Unit.INSTANCE;
        }

        private static final void stop$lambda$8$lambda$4(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object stop$lambda$8$lambda$6$lambda$5(Record $v) {
            return "Unpublished: " + $v.getName();
        }

        private static final Unit stop$lambda$8$lambda$6(Promise $unpublish, Record $v, Void it) {
            GenghisServicesKt.access$getLogger$p().info(() -> KillVerticle.stop$lambda$8$lambda$6$lambda$5($v));
            $unpublish.complete();
            return Unit.INSTANCE;
        }

        private static final void stop$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object stop$lambda$19$lambda$10() {
            return "UnPublish complete, Unregistering all services...";
        }

        private static final Object stop$lambda$19$lambda$12$lambda$11(MessageConsumer $v) {
            return "Unregistering " + $v.address();
        }

        private static final Object stop$lambda$19$lambda$13() {
            return "Releasing all consumed service objects...";
        }

        private static final Object stop$lambda$19$lambda$17$lambda$15() {
            return "Discovery Closed!";
        }

        private static final Object stop$lambda$19$lambda$17$lambda$16() {
            return "ServiceManager destroyed...";
        }

        private static final void stop$lambda$19$lambda$17(ServiceManager this$0, KillVerticle this$1, Promise $stopFuture, AsyncResult it) {
            this$0.serviceAnnounceConsumer = null;
            GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$19$lambda$17$lambda$15);
            instanceMap.remove(this$1.vertx);
            $stopFuture.tryComplete();
            GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$19$lambda$17$lambda$16);
        }

        private static final Object stop$lambda$19$lambda$18() {
            return "ServiceManager destroyed...";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void stop$lambda$19(ServiceManager this$0, KillVerticle this$1, Promise $stopFuture, AsyncResult it) {
            try {
                Map.Entry element$iv;
                this$0.registeredRecords.clear();
                GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$19$lambda$10);
                Object $this$forEach$iv = this$0.registeredServices;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    MessageConsumer v = (MessageConsumer)entry.getValue();
                    new ServiceBinder(this$1.vertx).setAddress(v.address()).unregister(v);
                    GenghisServicesKt.access$getLogger$p().info(() -> KillVerticle.stop$lambda$19$lambda$12$lambda$11(v));
                }
                this$0.registeredServices.clear();
                GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$19$lambda$13);
                Collection collection = this$0.fetchedServices.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                $this$forEach$iv = collection;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    Set it2 = (Set)((Object)element$iv);
                    boolean bl = false;
                    ServiceDiscovery serviceDiscovery = this$0.serviceDiscovery;
                    Intrinsics.checkNotNull((Object)serviceDiscovery);
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)serviceDiscovery, (Object)it2);
                }
                this$0.fetchedServices.clear();
                this$0.closeDiscovery((Handler<AsyncResult<Void>>)arg_0 -> KillVerticle.stop$lambda$19$lambda$17(this$0, this$1, $stopFuture, arg_0));
            }
            finally {
                instanceMap.remove(this$1.vertx);
                $stopFuture.tryComplete();
                GenghisServicesKt.access$getLogger$p().info(KillVerticle::stop$lambda$19$lambda$18);
            }
        }

        private static final Object stop$lambda$20() {
            return "Discovery is null...";
        }
    }
}

