/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.cluster;

import com.genghis.tools.cluster.CircuitBreakerUtilsKt;
import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\r0\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u000fJ\u001c\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a8\u0006\u0015"}, d2={"Lcom/genghis/tools/cluster/CircuitBreakerUtils;", "", "<init>", "()V", "performRequestWithCircuitBreaker", "", "T", "circuitBreaker", "Lio/vertx/circuitbreaker/CircuitBreaker;", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "handler", "Lio/vertx/core/Promise;", "backup", "Lkotlin/Function1;", "", "handleCircuitBreakerEvent", "serviceEvent", "Lio/vertx/core/eventbus/Message;", "Lio/vertx/core/json/JsonObject;", "genghis-tools-cluster"})
public final class CircuitBreakerUtils {
    @NotNull
    public static final CircuitBreakerUtils INSTANCE = new CircuitBreakerUtils();

    private CircuitBreakerUtils() {
    }

    public final <T> void performRequestWithCircuitBreaker(@NotNull CircuitBreaker circuitBreaker, @NotNull Handler<AsyncResult<T>> resultHandler, @NotNull Handler<Promise<T>> handler, @NotNull Function1<? super Throwable, Unit> backup) {
        Intrinsics.checkNotNullParameter((Object)circuitBreaker, (String)"circuitBreaker");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(backup, (String)"backup");
        Promise result = Promise.promise();
        result.future().andThen(arg_0 -> CircuitBreakerUtils.performRequestWithCircuitBreaker$lambda$3(resultHandler, backup, circuitBreaker, arg_0));
        circuitBreaker.executeAndReport(result, handler);
    }

    public final void handleCircuitBreakerEvent(@NotNull CircuitBreaker circuitBreaker, @NotNull Message<JsonObject> serviceEvent) {
        Intrinsics.checkNotNullParameter((Object)circuitBreaker, (String)"circuitBreaker");
        Intrinsics.checkNotNullParameter(serviceEvent, (String)"serviceEvent");
    }

    private static final Object performRequestWithCircuitBreaker$lambda$3$lambda$0(CircuitBreaker $circuitBreaker, AsyncResult $it) {
        return "Received " + $circuitBreaker.name() + " Result: " + $it.succeeded();
    }

    private static final Object performRequestWithCircuitBreaker$lambda$3$lambda$1(AsyncResult $it) {
        return "Failed: " + $it.cause();
    }

    private static final Object performRequestWithCircuitBreaker$lambda$3$lambda$2(CircuitBreaker $circuitBreaker) {
        return $circuitBreaker.name() + " Timeout, failures: " + $circuitBreaker.failureCount() + ", state: " + $circuitBreaker.state().name();
    }

    private static final void performRequestWithCircuitBreaker$lambda$3(Handler $resultHandler, Function1 $backup, CircuitBreaker $circuitBreaker, AsyncResult it) {
        CircuitBreakerUtilsKt.access$getLogger$p().debug(() -> CircuitBreakerUtils.performRequestWithCircuitBreaker$lambda$3$lambda$0($circuitBreaker, it));
        if (it.succeeded()) {
            $resultHandler.handle((Object)Future.succeededFuture((Object)it.result()));
        } else {
            CircuitBreakerUtilsKt.access$getLogger$p().debug(() -> CircuitBreakerUtils.performRequestWithCircuitBreaker$lambda$3$lambda$1(it));
            if (it.cause() instanceof ServiceException) {
                $resultHandler.handle((Object)Future.failedFuture((Throwable)it.cause()));
            } else {
                if (it.cause() != null && Intrinsics.areEqual((Object)it.cause().getMessage(), (Object)"operation timeout")) {
                    CircuitBreakerUtilsKt.access$getLogger$p().error(() -> CircuitBreakerUtils.performRequestWithCircuitBreaker$lambda$3$lambda$2($circuitBreaker));
                }
                Throwable throwable = it.cause();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"cause(...)");
                $backup.invoke((Object)throwable);
            }
        }
    }
}

