/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.cluster;

import com.genghis.tools.cluster.ClusterUtilsKt;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/genghis/tools/cluster/ClusterUtils;", "", "<init>", "()V", "clusterReport", "", "aLong", "", "(Ljava/lang/Long;)V", "setSSLEventBus", "Lio/vertx/core/eventbus/EventBusOptions;", "keystoreName", "", "keyStoreKey", "eventBusOptions", "createModifiedClusterConfigByPortScanning", "subnetBase", "thirdElementScanRange", "", "clusterConfigFileName", "dev", "", "readClusterConfig", "readZipInputStream", "stream", "Ljava/util/zip/ZipInputStream;", "setClusterMembersForSubnet", "thirdElement", "contents", "genghis-tools-cluster"})
@SourceDebugExtension(value={"SMAP\nClusterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterUtils.kt\ncom/genghis/tools/cluster/ClusterUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1869#2,2:286\n*S KotlinDebug\n*F\n+ 1 ClusterUtils.kt\ncom/genghis/tools/cluster/ClusterUtils\n*L\n249#1:286,2\n*E\n"})
public final class ClusterUtils {
    @NotNull
    public static final ClusterUtils INSTANCE = new ClusterUtils();

    private ClusterUtils() {
    }

    public final void clusterReport(@Nullable Long aLong) {
        Vertx vertx = Vertx.currentContext().owner();
        if (vertx.isClustered()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cluster Members:\n");
            sb.append("----------------\n");
            Set instances = Hazelcast.getAllHazelcastInstances();
            instances.stream().findFirst().ifPresent(arg_0 -> ClusterUtils.clusterReport$lambda$5(arg_0 -> ClusterUtils.clusterReport$lambda$4(sb, arg_0), arg_0));
            sb.append("----------------");
            ClusterUtilsKt.access$getLogger$p().info(() -> ClusterUtils.clusterReport$lambda$6(sb));
        } else {
            ClusterUtilsKt.access$getLogger$p().error(ClusterUtils::clusterReport$lambda$7);
        }
    }

    @NotNull
    public final EventBusOptions setSSLEventBus(@NotNull String keystoreName, @NotNull String keyStoreKey, @NotNull EventBusOptions eventBusOptions) {
        Intrinsics.checkNotNullParameter((Object)keystoreName, (String)"keystoreName");
        Intrinsics.checkNotNullParameter((Object)keyStoreKey, (String)"keyStoreKey");
        Intrinsics.checkNotNullParameter((Object)eventBusOptions, (String)"eventBusOptions");
        eventBusOptions.setSsl(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setPath(keystoreName).setPassword(keyStoreKey)).setTrustOptions((TrustOptions)new JksOptions().setPath(keystoreName).setPassword(keyStoreKey)).setClientAuth(ClientAuth.REQUIRED);
        return eventBusOptions;
    }

    public final void createModifiedClusterConfigByPortScanning(@NotNull String subnetBase, int thirdElementScanRange, @NotNull String clusterConfigFileName) {
        Intrinsics.checkNotNullParameter((Object)subnetBase, (String)"subnetBase");
        Intrinsics.checkNotNullParameter((Object)clusterConfigFileName, (String)"clusterConfigFileName");
        String string = this.readClusterConfig(clusterConfigFileName);
        if (string == null) {
            throw new IllegalArgumentException("Could not load cluster config!");
        }
        String contents = string;
        this.setClusterMembersForSubnet(subnetBase, thirdElementScanRange, contents, true);
    }

    public final void createModifiedClusterConfigByPortScanning(@NotNull String subnetBase, int thirdElementScanRange, @NotNull String clusterConfigFileName, boolean dev) {
        Intrinsics.checkNotNullParameter((Object)subnetBase, (String)"subnetBase");
        Intrinsics.checkNotNullParameter((Object)clusterConfigFileName, (String)"clusterConfigFileName");
        String string = this.readClusterConfig(clusterConfigFileName);
        if (string == null) {
            throw new IllegalArgumentException("Could not load cluster config!");
        }
        String contents = string;
        this.setClusterMembersForSubnet(subnetBase, thirdElementScanRange, contents, dev);
    }

    private final String readClusterConfig(String clusterConfigFileName) {
        String fileContents;
        block3: {
            fileContents = null;
            try {
                CodeSource src = ClusterUtils.class.getProtectionDomain().getCodeSource();
                if (src == null) break block3;
                URL jar = src.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                while (zip.getNextEntry() != null) {
                    ZipEntry e;
                    if (!StringsKt.equals((String)e.getName(), (String)clusterConfigFileName, (boolean)true)) continue;
                    fileContents = this.readZipInputStream(zip);
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileContents;
    }

    private final String readZipInputStream(ZipInputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder();
        List lines = IOUtils.readLines((InputStream)stream, (Charset)Charset.defaultCharset());
        lines.forEach(arg_0 -> ClusterUtils.readZipInputStream$lambda$8(sb, arg_0));
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setClusterMembersForSubnet(String subnetBase, int thirdElement, String contents, boolean dev) {
        try {
            AtomicInteger scans = new AtomicInteger();
            AtomicInteger scansComplete = new AtomicInteger();
            StringBuilder replacer = new StringBuilder();
            CopyOnWriteArrayList clusterMemberList = new CopyOnWriteArrayList();
            ExecutorService executorService = Executors.newCachedThreadPool();
            System.out.println((Object)"Initializing Port Scan!");
            CopyOnWriteArrayList<Runnable> portScanners = new CopyOnWriteArrayList<Runnable>();
            IntStream.rangeClosed(0, thirdElement).parallel().forEach(arg_0 -> ClusterUtils.setClusterMembersForSubnet$lambda$13(portScanners, clusterMemberList, scans, scansComplete, subnetBase, arg_0));
            portScanners.forEach(arg_0 -> ClusterUtils.setClusterMembersForSubnet$lambda$14(executorService, arg_0));
            executorService.shutdown();
            while (!executorService.isTerminated()) {
                Thread.sleep(2000L);
                System.out.println((Object)("Scan completion Status: (" + scansComplete.get() + "/" + scans.get() + ")"));
                if (clusterMemberList.size() <= 0) continue;
                System.out.println((Object)"Scan found at least one member, killing all scanners!");
                executorService.shutdownNow();
                break;
            }
            String clusterConfig = null;
            clusterConfig = contents;
            if (clusterMemberList.size() > 0) {
                void $this$forEach$iv;
                List list = clusterMemberList.subList(0, clusterMemberList.size() - 1);
                Intrinsics.checkNotNullExpressionValue(list, (String)"subList(...)");
                Iterable iterable = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String member = (String)element$iv;
                    boolean bl = false;
                    replacer.append(member).append("\n");
                }
                replacer.append((String)clusterMemberList.get(clusterMemberList.size() - 1));
                String string = replacer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String memberOverview = string;
                System.out.println((Object)("Finalized Port Scan. Members at: " + memberOverview));
                clusterConfig = dev ? StringsKt.replace$default((String)contents, (String)("<interface>" + subnetBase + "0.0-15</interface>"), (String)memberOverview, (boolean)false, (int)4, null) : StringsKt.replace$default((String)contents, (String)("<interface>" + subnetBase + "0.*</interface>"), (String)memberOverview, (boolean)false, (int)4, null);
            } else {
                System.out.println((Object)"Skipping memberlist due to it being empty, doing broad sweep...");
            }
            Path dir = Paths.get("/usr/verticles/cluster-modified.xml", new String[0]);
            File file = dir.toFile();
            file.createNewFile();
            file.setWritable(true);
            Closeable closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl = false;
                it.write(clusterConfig);
                it.flush();
                it.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            ClusterUtilsKt.access$getLogger$p().error((Throwable)e, ClusterUtils::setClusterMembersForSubnet$lambda$17);
        }
        catch (InterruptedException e) {
            ClusterUtilsKt.access$getLogger$p().error((Throwable)e, ClusterUtils::setClusterMembersForSubnet$lambda$18);
        }
    }

    private static final String clusterReport$lambda$4$lambda$0(Member member) {
        return member.getSocketAddress().getAddress() + ":" + member.getSocketAddress().getPort();
    }

    private static final String clusterReport$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit clusterReport$lambda$4$lambda$2(StringBuilder $sb, String name) {
        $sb.append(name).append("\n");
        return Unit.INSTANCE;
    }

    private static final void clusterReport$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit clusterReport$lambda$4(StringBuilder $sb, HazelcastInstance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.getCluster().getMembers().stream().map(arg_0 -> ClusterUtils.clusterReport$lambda$4$lambda$1(ClusterUtils::clusterReport$lambda$4$lambda$0, arg_0)).forEach(arg_0 -> ClusterUtils.clusterReport$lambda$4$lambda$3(arg_0 -> ClusterUtils.clusterReport$lambda$4$lambda$2($sb, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void clusterReport$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object clusterReport$lambda$6(StringBuilder $sb) {
        return $sb.toString();
    }

    private static final Object clusterReport$lambda$7() {
        return "Vertx is not clustered!";
    }

    private static final void readZipInputStream$lambda$8(StringBuilder $sb, String it) {
        $sb.append(it);
    }

    private static final Object setClusterMembersForSubnet$lambda$13$lambda$12$lambda$11$lambda$10(String $subnetBase, int $baseIpInt, int $lastIpInt) {
        return "No connection on: " + $subnetBase + $baseIpInt + "." + $lastIpInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setClusterMembersForSubnet$lambda$13$lambda$12$lambda$11(int $baseIpInt, int $lastIpInt, CopyOnWriteArrayList $clusterMemberList, AtomicInteger $scans, AtomicInteger $scansComplete, String $subnetBase) {
        System.out.println((Object)("Now running scan for: " + $baseIpInt + "." + $lastIpInt));
        if ($clusterMemberList.size() == 0) {
            $scans.incrementAndGet();
            try {
                Closeable closeable = new Socket();
                Throwable throwable = null;
                try {
                    Socket socket = (Socket)closeable;
                    boolean bl = false;
                    socket.connect(new InetSocketAddress($subnetBase + $baseIpInt + "." + $lastIpInt, 5701), 2000);
                    if (socket.isConnected()) {
                        $clusterMemberList.add("<member>" + $subnetBase + $baseIpInt + "." + $lastIpInt + "</member>");
                        String string = "Member detected at " + $subnetBase + $baseIpInt + "." + $lastIpInt;
                        System.out.println((Object)string);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                ClusterUtilsKt.access$getLogger$p().trace(() -> ClusterUtils.setClusterMembersForSubnet$lambda$13$lambda$12$lambda$11$lambda$10($subnetBase, $baseIpInt, $lastIpInt));
            }
            $scansComplete.incrementAndGet();
        }
    }

    private static final void setClusterMembersForSubnet$lambda$13$lambda$12(CopyOnWriteArrayList $portScanners, int $baseIpInt, CopyOnWriteArrayList $clusterMemberList, AtomicInteger $scans, AtomicInteger $scansComplete, String $subnetBase, int lastIpInt) {
        $portScanners.add(() -> ClusterUtils.setClusterMembersForSubnet$lambda$13$lambda$12$lambda$11($baseIpInt, lastIpInt, $clusterMemberList, $scans, $scansComplete, $subnetBase));
    }

    private static final void setClusterMembersForSubnet$lambda$13(CopyOnWriteArrayList $portScanners, CopyOnWriteArrayList $clusterMemberList, AtomicInteger $scans, AtomicInteger $scansComplete, String $subnetBase, int baseIpInt) {
        IntStream.rangeClosed(0, 254).parallel().forEach(arg_0 -> ClusterUtils.setClusterMembersForSubnet$lambda$13$lambda$12($portScanners, baseIpInt, $clusterMemberList, $scans, $scansComplete, $subnetBase, arg_0));
    }

    private static final void setClusterMembersForSubnet$lambda$14(ExecutorService $executorService, Runnable it) {
        $executorService.submit(it);
    }

    private static final Object setClusterMembersForSubnet$lambda$17() {
        return "Error in finding other services!";
    }

    private static final Object setClusterMembersForSubnet$lambda$18() {
        return "Error in finding other services!";
    }
}

