/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/// <reference path="./heartbeat_service-proxy.d.ts" />

/** @module genghisHeartbeatService-js/heartbeat_service */
!function (factory) {
  if (typeof require === 'function' && typeof module !== 'undefined') {
    factory();
  } else if (typeof define === 'function' && define.amd) {
    // AMD loader
    define('genghisHeartbeatService-js/heartbeat_service-proxy', [], factory);
  } else {
    // plain old include
    HeartbeatService = factory();
  }
}(function () {

  /**
   This class defines a service declaration for the HeartbeatService. It responds to pings, to enable clients to ensure
   connection to eventbus services.

   @class
  */
  var HeartbeatService = function(eb, address) {
    var j_eb = eb;
    var j_address = address;
    var closed = false;
    var that = this;
    var convCharCollection = function(coll) {
      var ret = [];
      for (var i = 0;i < coll.length;i++) {
        ret.push(String.fromCharCode(coll[i]));
      }
      return ret;
    };

    /**

     @public

     @return {todo}
     */
    this.ping =  function() {
      var __args = arguments;
      if (__args.length === 1) {
        if (closed) {
          throw new Error('Proxy is closed');
        }
        j_eb.send(j_address, {}, {"action":"ping"}, function(err, result) { __args[0](err, result && result.body); });
        return;
      } else throw new TypeError('function invoked with invalid arguments');
    };

  };

  if (typeof exports !== 'undefined') {
    if (typeof module !== 'undefined' && module.exports) {
      exports = module.exports = HeartbeatService;
    } else {
      exports.HeartbeatService = HeartbeatService;
    }
  } else {
    return HeartbeatService;
  }
});