/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.fcm.server;

import com.genghis.tools.cluster.apis.APIManager;
import com.genghis.tools.fcm.server.DeviceGroupManagerKt;
import com.genghis.tools.fcm.server.FcmServer;
import com.genghis.tools.fcm.server.MessageSender;
import com.genghis.tools.fcm.server.data.FcmDevice;
import com.genghis.tools.repository.repository.redis.GenghisRedisClient;
import com.google.common.net.MediaType;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.kotlin.core.http.RequestOptionsKt;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\b\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u0014J2\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0082@\u00a2\u0006\u0002\u0010\u001aJR\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0002JX\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0082@\u00a2\u0006\u0002\u0010\"J6\u0010#\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/genghis/tools/fcm/server/DeviceGroupManager;", "", "server", "Lcom/genghis/tools/fcm/server/FcmServer;", "sender", "Lcom/genghis/tools/fcm/server/MessageSender;", "redisClient", "Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;", "GCM_SENDER_ID", "", "GCM_API_KEY", "<init>", "(Lcom/genghis/tools/fcm/server/FcmServer;Lcom/genghis/tools/fcm/server/MessageSender;Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;Ljava/lang/String;Ljava/lang/String;)V", "addDeviceToDeviceGroupForUser", "", "device", "Lcom/genghis/tools/fcm/server/data/FcmDevice;", "appPackageName", "channelKeyName", "fcmId", "(Lcom/genghis/tools/fcm/server/data/FcmDevice;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addDeviceToDeviceGroup", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "", "(Lcom/genghis/tools/fcm/server/data/FcmDevice;Ljava/lang/String;Lio/vertx/core/Handler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doDeviceGroupResult", "notificationKey", "channelMap", "", "notificationKeyName", "setNewKey", "newNotificationKey", "(Lcom/genghis/tools/fcm/server/data/FcmDevice;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Lio/vertx/core/Handler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addToGroup", "keyName", "key", "genghis-tools-fcm"})
public final class DeviceGroupManager {
    @NotNull
    private final FcmServer server;
    @NotNull
    private final MessageSender sender;
    @NotNull
    private final GenghisRedisClient redisClient;
    @NotNull
    private final String GCM_SENDER_ID;
    @NotNull
    private final String GCM_API_KEY;

    public DeviceGroupManager(@NotNull FcmServer server, @NotNull MessageSender sender, @NotNull GenghisRedisClient redisClient, @NotNull String GCM_SENDER_ID, @NotNull String GCM_API_KEY) {
        Intrinsics.checkNotNullParameter((Object)((Object)server), (String)"server");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)redisClient, (String)"redisClient");
        Intrinsics.checkNotNullParameter((Object)GCM_SENDER_ID, (String)"GCM_SENDER_ID");
        Intrinsics.checkNotNullParameter((Object)GCM_API_KEY, (String)"GCM_API_KEY");
        this.server = server;
        this.sender = sender;
        this.redisClient = redisClient;
        this.GCM_SENDER_ID = GCM_SENDER_ID;
        this.GCM_API_KEY = GCM_API_KEY;
    }

    @Nullable
    public final Object addDeviceToDeviceGroupForUser(@NotNull FcmDevice device, @NotNull String appPackageName, @NotNull String channelKeyName, @NotNull String fcmId, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.addDeviceToDeviceGroup(device, channelKeyName, (Handler<AsyncResult<Boolean>>)((Handler)arg_0 -> DeviceGroupManager.addDeviceToDeviceGroupForUser$lambda$3(this, appPackageName, fcmId, arg_0)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object addDeviceToDeviceGroup(FcmDevice device, String channelKeyName, Handler<AsyncResult<Boolean>> resultHandler, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    private final void doDeviceGroupResult(String notificationKey, Map<String, String> channelMap, FcmDevice device, String notificationKeyName, String channelKeyName, Handler<AsyncResult<Boolean>> resultHandler) {
        block0: {
            DeviceGroupManagerKt.access$getLogger$p().info(() -> DeviceGroupManager.doDeviceGroupResult$lambda$4(notificationKey));
            if (notificationKey != null) break block0;
            Consumer<String> checkKey = arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$5(resultHandler, arg_0);
            Handler httpResultHandler = arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$9(checkKey, arg_0);
            String url = "https://android.googleapis.com/gcm/notification?notification_key_name=" + notificationKeyName;
            APIManager.Companion.performRequestWithCircuitBreaker(httpResultHandler, arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$19(url, this, arg_0), DeviceGroupManager::doDeviceGroupResult$lambda$21);
        }
    }

    private final Object setNewKey(FcmDevice device, String channelKeyName, Map<String, String> channelMap, String notificationKeyName, String newNotificationKey, Handler<AsyncResult<Boolean>> resultHandler, Continuation<? super Unit> $completion) {
        if (newNotificationKey != null) {
            channelMap.put(notificationKeyName, newNotificationKey);
        }
        JsonObject mapAsJson = new JsonObject(Json.encode(channelMap));
        return Unit.INSTANCE;
    }

    private final void addToGroup(String fcmId, String keyName, String key, Handler<AsyncResult<Boolean>> resultHandler) {
        String addJson = Json.encode((Object)MessageSender.Companion.createAddDeviceGroupJson(fcmId, keyName, key));
        String url = "https://android.googleapis.com/gcm/notification";
        APIManager.Companion.performRequestWithCircuitBreaker(resultHandler, arg_0 -> DeviceGroupManager.addToGroup$lambda$28(this, url, addJson, arg_0), arg_0 -> DeviceGroupManager.addToGroup$lambda$30(resultHandler, arg_0));
    }

    private static final Object addDeviceToDeviceGroupForUser$lambda$3$lambda$0() {
        return "Could not add device to device group...";
    }

    private static final Object addDeviceToDeviceGroupForUser$lambda$3$lambda$1() {
        return "User updated, device added...";
    }

    private static final Object addDeviceToDeviceGroupForUser$lambda$3$lambda$2() {
        return "Sent message of correct device registration...";
    }

    private static final void addDeviceToDeviceGroupForUser$lambda$3(DeviceGroupManager this$0, String $appPackageName, String $fcmId, AsyncResult it) {
        if (it.failed()) {
            DeviceGroupManagerKt.access$getLogger$p().error(DeviceGroupManager::addDeviceToDeviceGroupForUser$lambda$3$lambda$0);
        } else {
            DeviceGroupManagerKt.access$getLogger$p().info(DeviceGroupManager::addDeviceToDeviceGroupForUser$lambda$3$lambda$1);
            this$0.sender.replyWithSuccessfullDeviceRegistration($appPackageName, $fcmId);
            DeviceGroupManagerKt.access$getLogger$p().info(DeviceGroupManager::addDeviceToDeviceGroupForUser$lambda$3$lambda$2);
        }
    }

    private static final Object doDeviceGroupResult$lambda$4(String $notificationKey) {
        return "New key for device group is: " + $notificationKey;
    }

    private static final void doDeviceGroupResult$lambda$5(Handler $resultHandler, String it) {
        if (it == null) {
            $resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("Could not fetch key...")));
        }
    }

    private static final Object doDeviceGroupResult$lambda$9$lambda$6() {
        return "Completed Fetch key...";
    }

    private static final Object doDeviceGroupResult$lambda$9$lambda$7() {
        return "Failed Fetch key...";
    }

    private static final Object doDeviceGroupResult$lambda$9$lambda$8() {
        return "Failed Fetch key...";
    }

    private static final void doDeviceGroupResult$lambda$9(Consumer $checkKey, AsyncResult it) {
        if (it.succeeded()) {
            if (it.result() != null) {
                DeviceGroupManagerKt.access$getLogger$p().info(DeviceGroupManager::doDeviceGroupResult$lambda$9$lambda$6);
            } else {
                DeviceGroupManagerKt.access$getLogger$p().error(DeviceGroupManager::doDeviceGroupResult$lambda$9$lambda$7);
            }
        } else {
            DeviceGroupManagerKt.access$getLogger$p().error(DeviceGroupManager::doDeviceGroupResult$lambda$9$lambda$8);
        }
        $checkKey.accept(it.result());
    }

    private static final Object doDeviceGroupResult$lambda$19$lambda$10(String $url) {
        return "Querying: " + $url;
    }

    private static final Object doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$11(int $status) {
        return "Fetch Notification key response: " + ($status == 200);
    }

    private static final Object doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$14$lambda$12(HttpClientResponse $res) {
        return $res.statusMessage();
    }

    private static final Object doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$14$lambda$13(Buffer $body) {
        return $body.toString();
    }

    private static final void doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$14(HttpClientResponse $res, Buffer body) {
        DeviceGroupManagerKt.access$getLogger$p().error(() -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$14$lambda$12($res));
        DeviceGroupManagerKt.access$getLogger$p().error(() -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$14$lambda$13(body));
    }

    private static final Object doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$16$lambda$15(JsonObject $bodyObject) {
        return "Response from GCM: " + Json.encodePrettily((Object)$bodyObject);
    }

    private static final void doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$16(Promise $it, Buffer body) {
        JsonObject bodyObject = body.toJsonObject();
        DeviceGroupManagerKt.access$getLogger$p().info(() -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$16$lambda$15(bodyObject));
        $it.complete((Object)bodyObject.getString("notification_key"));
    }

    private static final void doDeviceGroupResult$lambda$19$lambda$18$lambda$17(Promise $it, AsyncResult response) {
        HttpClientResponse res = (HttpClientResponse)response.result();
        int status = res.statusCode();
        DeviceGroupManagerKt.access$getLogger$p().info(() -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$11(status));
        if (status != 200) {
            res.bodyHandler(arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$14(res, arg_0));
            $it.fail((Throwable)new UnknownError(res.statusMessage()));
        } else {
            res.bodyHandler(arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17$lambda$16($it, arg_0));
        }
    }

    private static final void doDeviceGroupResult$lambda$19$lambda$18(DeviceGroupManager this$0, Promise $it, AsyncResult request) {
        HttpClientRequest req = (HttpClientRequest)request.result();
        req.putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("key=" + this$0.GCM_API_KEY));
        req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MediaType.JSON_UTF_8.toString());
        req.putHeader("project_id", this$0.GCM_SENDER_ID);
        req.end();
        req.response().onComplete(arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18$lambda$17($it, arg_0));
    }

    private static final void doDeviceGroupResult$lambda$19(String $url, DeviceGroupManager this$0, Promise it) {
        HttpClientOptions options = new HttpClientOptions().setSsl(true);
        DeviceGroupManagerKt.access$getLogger$p().info(() -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$10($url));
        Vertx.currentContext().owner().createHttpClient(options).request(RequestOptionsKt.requestOptionsOf$default(null, null, null, null, null, null, null, null, null, null, null, (String)$url, null, null, (int)14335, null)).onComplete(arg_0 -> DeviceGroupManager.doDeviceGroupResult$lambda$19$lambda$18(this$0, it, arg_0));
    }

    private static final Object doDeviceGroupResult$lambda$21$lambda$20(Throwable $it) {
        return "HttpFetchFailed: " + $it;
    }

    private static final Unit doDeviceGroupResult$lambda$21(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DeviceGroupManagerKt.access$getLogger$p().error(() -> DeviceGroupManager.doDeviceGroupResult$lambda$21$lambda$20(it));
        return Unit.INSTANCE;
    }

    private static final Object addToGroup$lambda$28$lambda$27$lambda$26$lambda$22(int $status) {
        return "Add To Group response: " + ($status == 200);
    }

    private static final Object addToGroup$lambda$28$lambda$27$lambda$26$lambda$25$lambda$23(HttpClientResponse $clientResponse) {
        return $clientResponse.statusMessage();
    }

    private static final Object addToGroup$lambda$28$lambda$27$lambda$26$lambda$25$lambda$24(Buffer $body) {
        return $body.toString();
    }

    private static final void addToGroup$lambda$28$lambda$27$lambda$26$lambda$25(HttpClientResponse $clientResponse, Buffer body) {
        DeviceGroupManagerKt.access$getLogger$p().error(() -> DeviceGroupManager.addToGroup$lambda$28$lambda$27$lambda$26$lambda$25$lambda$23($clientResponse));
        DeviceGroupManagerKt.access$getLogger$p().error(() -> DeviceGroupManager.addToGroup$lambda$28$lambda$27$lambda$26$lambda$25$lambda$24(body));
    }

    private static final void addToGroup$lambda$28$lambda$27$lambda$26(Promise $it, AsyncResult response) {
        HttpClientResponse clientResponse = (HttpClientResponse)response.result();
        int status = clientResponse.statusCode();
        DeviceGroupManagerKt.access$getLogger$p().info(() -> DeviceGroupManager.addToGroup$lambda$28$lambda$27$lambda$26$lambda$22(status));
        if (status != 200) {
            clientResponse.bodyHandler(arg_0 -> DeviceGroupManager.addToGroup$lambda$28$lambda$27$lambda$26$lambda$25(clientResponse, arg_0));
        }
        $it.complete((Object)(status == 200 ? 1 : 0));
    }

    private static final void addToGroup$lambda$28$lambda$27(DeviceGroupManager this$0, String $addJson, Promise $it, AsyncResult request) {
        HttpClientRequest req = (HttpClientRequest)request.result();
        req.putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("key=" + this$0.GCM_API_KEY));
        req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MediaType.JSON_UTF_8.toString());
        req.putHeader("project_id", this$0.GCM_SENDER_ID);
        req.end($addJson);
        req.response().onComplete(arg_0 -> DeviceGroupManager.addToGroup$lambda$28$lambda$27$lambda$26($it, arg_0));
    }

    private static final void addToGroup$lambda$28(DeviceGroupManager this$0, String $url, String $addJson, Promise it) {
        HttpClientOptions opts = new HttpClientOptions().setSsl(true);
        this$0.server.getVertx().createHttpClient(opts).request(HttpMethod.POST, $url).onComplete(arg_0 -> DeviceGroupManager.addToGroup$lambda$28$lambda$27(this$0, $addJson, it, arg_0));
    }

    private static final Object addToGroup$lambda$30$lambda$29() {
        return "Failed Add to Group...";
    }

    private static final Unit addToGroup$lambda$30(Handler $resultHandler, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DeviceGroupManagerKt.access$getLogger$p().error(DeviceGroupManager::addToGroup$lambda$30$lambda$29);
        $resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException()));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$addDeviceToDeviceGroup(DeviceGroupManager $this, FcmDevice device, String channelKeyName, Handler resultHandler, Continuation $completion) {
        return $this.addDeviceToDeviceGroup(device, channelKeyName, (Handler<AsyncResult<Boolean>>)resultHandler, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$setNewKey(DeviceGroupManager $this, FcmDevice device, String channelKeyName, Map channelMap, String notificationKeyName, String newNotificationKey, Handler resultHandler, Continuation $completion) {
        return $this.setNewKey(device, channelKeyName, channelMap, notificationKeyName, newNotificationKey, (Handler<AsyncResult<Boolean>>)resultHandler, (Continuation<? super Unit>)$completion);
    }
}

