/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.fcm.server;

import com.genghis.tools.fcm.server.FcmServer;
import com.genghis.tools.fcm.server.MessageSenderKt;
import com.genghis.tools.fcm.server.messageutils.FcmNotification;
import com.genghis.tools.fcm.server.messageutils.MessageUtils;
import com.genghis.tools.repository.repository.redis.GenghisRedisClient;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J\u0016\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012J\u0016\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012J\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/genghis/tools/fcm/server/MessageSender;", "", "server", "Lcom/genghis/tools/fcm/server/FcmServer;", "<init>", "(Lcom/genghis/tools/fcm/server/FcmServer;)V", "redisClient", "Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;", "delayedSendingService", "Ljava/util/concurrent/ExecutorService;", "setRedisClient", "", "setRedisClient$genghis_tools_fcm", "send", "json", "Lio/vertx/core/json/JsonObject;", "send$genghis_tools_fcm", "messageId", "", "jsonValue", "sendToNewRecipient", "regId", "messageAsJson", "sendToNewRecipient$genghis_tools_fcm", "replyWithSuccessfullDeviceRegistration", "packageName", "gcmId", "replyWithDeviceAlreadyExists", "replyWithNewDeviceIdSet", "addSuccessCreate", "message", "Companion", "genghis-tools-fcm"})
public final class MessageSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FcmServer server;
    @Nullable
    private GenghisRedisClient redisClient;
    @NotNull
    private final ExecutorService delayedSendingService;
    @NotNull
    private static final String GCM_PACKET_CONTENT_AVAILABLE_NOTATION = "content_available";
    @NotNull
    private static final String GCM_PACKET_NOTIFICATION_NOTATION = "notification";
    @NotNull
    private static final String GCM_PACKET_PRIORITY_NOTATION = "priority";
    @NotNull
    private static final String MESSAGE_STATUS = "message";
    @NotNull
    private static final String DELIVERY_RECEIPT_REQUESTED = "delivery_receipt_requested";
    @NotNull
    private static final String STATUS_CODE = "status";
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String FAILURE = "Failure";
    private static final int ALREADY_EXISTS = 208;
    private static final int CREATED = 200;
    private static final int NO_CONTENT = 204;
    private static final int UPDATED = 204;
    private static final int INTERNAL_ERROR = 500;
    @NotNull
    private static final String GCM_DEVICE_GROUP_OPERATION_NOTATION = "operation";
    @NotNull
    private static final String GCM_DEVICE_GROUP_CREATE_GROUP_NOTATION = "create";
    @NotNull
    private static final String GCM_DEVICE_GROUP_ADD_ACTION_NOTATION = "add";
    @NotNull
    private static final String GCM_DEVICE_GROUP_REMOVE_ACTION_NOTATION = "remove";
    @NotNull
    private static final String GCM_DEVICE_NOTIFICATION_KEY_NAME_NOTATION = "notification_key_name";
    @NotNull
    private static final String GCM_DEVICE_NOTIFICATION_KEY_NOTATION = "notification_key";
    @NotNull
    private static final String GCM_PACKET_NOTIFICATION_SOUND_NOTATION = "sound";
    @NotNull
    private static final String GCM_PACKET_NOTIFICATION_SOUND_DEFAULT = "default";
    @NotNull
    private static final String GCM_DEVICE_REG_IDS_NOTATION = "registration_ids";
    @NotNull
    public static final String REDIS_MESSAGE_HASH = "MESSAGE_QUEUE";

    public MessageSender(@NotNull FcmServer server) {
        Intrinsics.checkNotNullParameter((Object)((Object)server), (String)"server");
        this.server = server;
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.delayedSendingService = executorService;
    }

    public final void setRedisClient$genghis_tools_fcm(@NotNull GenghisRedisClient redisClient) {
        Intrinsics.checkNotNullParameter((Object)redisClient, (String)"redisClient");
        this.redisClient = redisClient;
    }

    public final void send$genghis_tools_fcm(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String messageId = json.getString("message_id");
        Intrinsics.checkNotNull((Object)messageId);
        String string = Json.encode((Object)json);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        this.send$genghis_tools_fcm(messageId, string);
    }

    public final void send$genghis_tools_fcm(@NotNull String messageId, @NotNull String jsonValue) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        if (this.redisClient == null) {
            return;
        }
        String retryKey = messageId + "_retry_count";
    }

    public final void sendToNewRecipient$genghis_tools_fcm(@NotNull String regId, @NotNull String messageAsJson) {
        Intrinsics.checkNotNullParameter((Object)regId, (String)"regId");
        Intrinsics.checkNotNullParameter((Object)messageAsJson, (String)"messageAsJson");
        JsonObject messageJson = new JsonObject(messageAsJson);
        messageJson.put("to", (Object)regId);
        this.send$genghis_tools_fcm(messageJson);
    }

    public final void replyWithSuccessfullDeviceRegistration(@NotNull String packageName, @NotNull String gcmId) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)gcmId, (String)"gcmId");
        MessageSenderKt.access$getLogger$p().info(MessageSender::replyWithSuccessfullDeviceRegistration$lambda$0);
        JsonObject body = new JsonObject();
        body = this.addSuccessCreate(body);
        this.send$genghis_tools_fcm(MessageUtils.INSTANCE.createJsonMessage(gcmId, "Register Device", body, "Register Device", packageName));
    }

    public final void replyWithDeviceAlreadyExists(@NotNull String packageName, @NotNull String gcmId) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)gcmId, (String)"gcmId");
        MessageSenderKt.access$getLogger$p().info(MessageSender::replyWithDeviceAlreadyExists$lambda$1);
        JsonObject body = new JsonObject();
        body.put(MESSAGE_STATUS, (Object)FAILURE);
        body.put(STATUS_CODE, (Object)208);
        this.send$genghis_tools_fcm(MessageUtils.INSTANCE.createJsonMessage(gcmId, "Register Device", body, "Register Device", packageName));
    }

    public final void replyWithNewDeviceIdSet(@NotNull String gcmId, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)gcmId, (String)"gcmId");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        MessageSenderKt.access$getLogger$p().info(MessageSender::replyWithNewDeviceIdSet$lambda$2);
        JsonObject body = new JsonObject();
        body.put(MESSAGE_STATUS, (Object)SUCCESS);
        body.put(STATUS_CODE, (Object)204);
        this.send$genghis_tools_fcm(MessageUtils.INSTANCE.createJsonMessage(gcmId, "Update Id", body, "Update Id", packageName));
    }

    private final JsonObject addSuccessCreate(JsonObject message) {
        message.put(MESSAGE_STATUS, (Object)SUCCESS);
        message.put(STATUS_CODE, (Object)200);
        return message;
    }

    private static final Object replyWithSuccessfullDeviceRegistration$lambda$0() {
        return "Returning message of correct registration...";
    }

    private static final Object replyWithDeviceAlreadyExists$lambda$1() {
        return "Device already exists...";
    }

    private static final Object replyWithNewDeviceIdSet$lambda$2() {
        return "Returning message of correct re-registration...";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J,\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0007J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005J \u0010,\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u0005J\u001e\u0010/\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005J\"\u00100\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J \u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/genghis/tools/fcm/server/MessageSender$Companion;", "", "<init>", "()V", "GCM_PACKET_CONTENT_AVAILABLE_NOTATION", "", "GCM_PACKET_NOTIFICATION_NOTATION", "GCM_PACKET_PRIORITY_NOTATION", "MESSAGE_STATUS", "DELIVERY_RECEIPT_REQUESTED", "STATUS_CODE", "SUCCESS", "FAILURE", "ALREADY_EXISTS", "", "CREATED", "NO_CONTENT", "UPDATED", "INTERNAL_ERROR", "GCM_DEVICE_GROUP_OPERATION_NOTATION", "GCM_DEVICE_GROUP_CREATE_GROUP_NOTATION", "GCM_DEVICE_GROUP_ADD_ACTION_NOTATION", "GCM_DEVICE_GROUP_REMOVE_ACTION_NOTATION", "GCM_DEVICE_NOTIFICATION_KEY_NAME_NOTATION", "GCM_DEVICE_NOTIFICATION_KEY_NOTATION", "GCM_PACKET_NOTIFICATION_SOUND_NOTATION", "GCM_PACKET_NOTIFICATION_SOUND_DEFAULT", "GCM_DEVICE_REG_IDS_NOTATION", "REDIS_MESSAGE_HASH", "createJsonAck", "Lio/vertx/core/json/JsonObject;", "from", "messageId", "createJsonNack", "createCustomNotification", "appPackageName", "to", "customNotification", "Lcom/genghis/tools/fcm/server/messageutils/FcmNotification;", "dryRun", "", "createDeviceGroupCreationJson", "uniqueId", "gcmId", "createAddDeviceGroupJson", "notificationKeyName", "key", "createRemoveDeviceGroupJson", "buildDeviceGroupOperator", "prepareJsonAckNack", "type", "genghis-tools-fcm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonObject createJsonAck(@NotNull String from, @NotNull String messageId) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
            MessageSenderKt.access$getLogger$p().info(() -> Companion.createJsonAck$lambda$0(from, messageId));
            return this.prepareJsonAckNack(from, messageId, "ack");
        }

        @NotNull
        public final JsonObject createJsonNack(@NotNull String from, @NotNull String messageId) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
            MessageSenderKt.access$getLogger$p().info(() -> Companion.createJsonNack$lambda$1(from, messageId));
            return this.prepareJsonAckNack(from, messageId, "nack");
        }

        @JvmOverloads
        @NotNull
        public final JsonObject createCustomNotification(@Nullable String appPackageName, @NotNull String to, @NotNull FcmNotification customNotification, boolean dryRun) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)customNotification, (String)"customNotification");
            JsonObject message = new JsonObject();
            message.put("to", (Object)to);
            message.put("message_id", (Object)UUID.randomUUID().toString());
            message.put(MessageSender.GCM_PACKET_CONTENT_AVAILABLE_NOTATION, (Object)(customNotification.getData() != null && !customNotification.getData().isEmpty() ? 1 : 0));
            message.put(MessageSender.GCM_PACKET_PRIORITY_NOTATION, (Object)(customNotification.getPriority() != null ? customNotification.getPriority() : "high"));
            message.put("collapse_key", (Object)customNotification.getCollapseKey());
            Map notification = MapsKt.toMutableMap(customNotification.getNotification());
            if (notification != null) {
                notification.put(MessageSender.GCM_PACKET_NOTIFICATION_SOUND_NOTATION, MessageSender.GCM_PACKET_NOTIFICATION_SOUND_DEFAULT);
            }
            customNotification.setNotification(MapsKt.toMap((Map)notification));
            message.put(MessageSender.GCM_PACKET_NOTIFICATION_NOTATION, (Object)notification);
            message.put("data", customNotification.getData());
            message.put(MessageSender.DELIVERY_RECEIPT_REQUESTED, (Object)true);
            message.put("time_to_live", (Object)86400);
            message.put("delay_while_idle", (Object)false);
            message.put("restricted_package_name", (Object)appPackageName);
            if (dryRun) {
                message.put("dry_run", (Object)true);
            }
            return message;
        }

        public static /* synthetic */ JsonObject createCustomNotification$default(Companion companion, String string, String string2, FcmNotification fcmNotification, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.createCustomNotification(string, string2, fcmNotification, bl);
        }

        @NotNull
        public final JsonObject createDeviceGroupCreationJson(@NotNull String uniqueId, @NotNull String gcmId) {
            Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
            Intrinsics.checkNotNullParameter((Object)gcmId, (String)"gcmId");
            JsonObject message = new JsonObject();
            message.put(MessageSender.GCM_DEVICE_GROUP_OPERATION_NOTATION, (Object)MessageSender.GCM_DEVICE_GROUP_CREATE_GROUP_NOTATION);
            message.put(MessageSender.GCM_DEVICE_NOTIFICATION_KEY_NAME_NOTATION, (Object)uniqueId);
            message.put(MessageSender.GCM_DEVICE_REG_IDS_NOTATION, (Object)CollectionsKt.listOf((Object)gcmId));
            return MessageUtils.INSTANCE.createJsonMessage(message);
        }

        @NotNull
        public final JsonObject createAddDeviceGroupJson(@NotNull String gcmId, @NotNull String notificationKeyName, @Nullable String key) {
            Intrinsics.checkNotNullParameter((Object)gcmId, (String)"gcmId");
            Intrinsics.checkNotNullParameter((Object)notificationKeyName, (String)"notificationKeyName");
            JsonObject message = this.buildDeviceGroupOperator(gcmId, notificationKeyName, key);
            message.put(MessageSender.GCM_DEVICE_GROUP_OPERATION_NOTATION, (Object)MessageSender.GCM_DEVICE_GROUP_ADD_ACTION_NOTATION);
            return MessageUtils.INSTANCE.createJsonMessage(message);
        }

        @NotNull
        public final JsonObject createRemoveDeviceGroupJson(@NotNull String gcmId, @NotNull String notificationKeyName, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)gcmId, (String)"gcmId");
            Intrinsics.checkNotNullParameter((Object)notificationKeyName, (String)"notificationKeyName");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JsonObject message = this.buildDeviceGroupOperator(gcmId, notificationKeyName, key);
            message.put(MessageSender.GCM_DEVICE_GROUP_OPERATION_NOTATION, (Object)MessageSender.GCM_DEVICE_GROUP_REMOVE_ACTION_NOTATION);
            return MessageUtils.INSTANCE.createJsonMessage(message);
        }

        private final JsonObject buildDeviceGroupOperator(String gcmId, String notificationKeyName, String key) {
            JsonObject message = new JsonObject();
            message.put(MessageSender.GCM_DEVICE_NOTIFICATION_KEY_NAME_NOTATION, (Object)notificationKeyName);
            message.put(MessageSender.GCM_DEVICE_NOTIFICATION_KEY_NOTATION, (Object)key);
            message.put(MessageSender.GCM_DEVICE_REG_IDS_NOTATION, (Object)CollectionsKt.listOf((Object)gcmId));
            return message;
        }

        private final JsonObject prepareJsonAckNack(String from, String messageId, String type) {
            JsonObject message = new JsonObject();
            message.put("to", (Object)from);
            message.put("message_id", (Object)messageId);
            message.put("message_type", (Object)type);
            return message;
        }

        @JvmOverloads
        @NotNull
        public final JsonObject createCustomNotification(@Nullable String appPackageName, @NotNull String to, @NotNull FcmNotification customNotification) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)customNotification, (String)"customNotification");
            return com.genghis.tools.fcm.server.MessageSender$Companion.createCustomNotification$default(this, appPackageName, to, customNotification, false, 8, null);
        }

        private static final Object createJsonAck$lambda$0(String $from, String $messageId) {
            return "Responding with ack to: " + $from + " based on " + $messageId;
        }

        private static final Object createJsonNack$lambda$1(String $from, String $messageId) {
            return "Responding with nack to: " + $from + " based on " + $messageId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

