/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.fcm.server.messageutils;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\tH\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eJ@\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/genghis/tools/fcm/server/messageutils/MessageUtils;", "", "<init>", "()V", "TIME_TO_LIVE", "", "DELAY_WHILE_IDLE", "", "GCM_PACKET_CONTENT_AVAILABLE_NOTATION", "", "GCM_PACKET_PRIORITY_NOTATION", "DELIVERY_RECEIPT_REQUESTED", "generateNewMessageId", "createJsonMessage", "Lio/vertx/core/json/JsonObject;", "to", "action", "payload", "collapseKey", "packageName", "map", "createAttributeMap", "messageId", "genghis-tools-fcm"})
public final class MessageUtils {
    @NotNull
    public static final MessageUtils INSTANCE = new MessageUtils();
    public static final int TIME_TO_LIVE = 86400;
    public static final boolean DELAY_WHILE_IDLE = false;
    @NotNull
    private static final String GCM_PACKET_CONTENT_AVAILABLE_NOTATION = "content_available";
    @NotNull
    private static final String GCM_PACKET_PRIORITY_NOTATION = "priority";
    @NotNull
    private static final String DELIVERY_RECEIPT_REQUESTED = "delivery_receipt_requested";

    private MessageUtils() {
    }

    private final String generateNewMessageId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final JsonObject createJsonMessage(@NotNull String to, @NotNull String action, @NotNull JsonObject payload, @NotNull String collapseKey, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)collapseKey, (String)"collapseKey");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.createJsonMessage(this.createAttributeMap(to, action, this.generateNewMessageId(), payload, collapseKey, packageName));
    }

    @NotNull
    public final JsonObject createJsonMessage(@NotNull JsonObject map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return map;
    }

    private final JsonObject createAttributeMap(String to, String action, String messageId, JsonObject payload, String collapseKey, String packageName) {
        HashMap message = new HashMap();
        if (to != null) {
            ((Map)message).put("to", to);
        }
        if (collapseKey != null) {
            ((Map)message).put("collapse_key", collapseKey);
        }
        if (messageId != null) {
            ((Map)message).put("message_id", messageId);
        }
        ((Map)message).put("time_to_live", 86400);
        ((Map)message).put("delay_while_idle", false);
        ((Map)message).put(GCM_PACKET_CONTENT_AVAILABLE_NOTATION, payload != null);
        if (payload != null) {
            payload.put("action", (Object)action);
            ((Map)message).put("data", payload);
        }
        ((Map)message).put("restricted_package_name", packageName);
        ((Map)message).put("mutable_content", true);
        ((Map)message).put(GCM_PACKET_PRIORITY_NOTATION, "high");
        ((Map)message).put(DELIVERY_RECEIPT_REQUESTED, true);
        return new JsonObject(Json.encode(message));
    }
}

