/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.fcm.server.services;

import com.genghis.tools.fcm.server.services.NotificationsService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;

public class NotificationsServiceVertxEBProxy
implements NotificationsService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public NotificationsServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public NotificationsServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
        try {
            this._vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Future<Boolean> sendTopicNotification(JsonObject messageBody) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("messageBody", (Object)messageBody);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "sendTopicNotification");
        _deliveryOptions.getHeaders().set("action", "sendTopicNotification");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public Future<Boolean> sendUserNotification(JsonObject messageBody) {
        if (this.closed) {
            return Future.failedFuture((String)"Proxy is closed");
        }
        JsonObject _json = new JsonObject();
        _json.put("messageBody", (Object)messageBody);
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "sendUserNotification");
        _deliveryOptions.getHeaders().set("action", "sendUserNotification");
        return this._vertx.eventBus().request(this._address, (Object)_json, _deliveryOptions).map(msg -> (Boolean)msg.body());
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Proxy is closed");
        }
        this.closed = true;
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "close");
        _deliveryOptions.getHeaders().set("action", "close");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions);
    }
}

