/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.fcm.server;

import com.genghis.tools.fcm.server.FcmServer;
import com.genghis.tools.fcm.server.FcmServerKt;
import com.genghis.tools.fcm.server.MessageSender;
import com.genghis.tools.fcm.server.XMPPPacketListener;
import com.genghis.tools.fcm.server.data.DataMessageHandler;
import com.genghis.tools.fcm.server.data.DefaultDataMessageHandlerImpl;
import com.genghis.tools.fcm.server.data.DefaultRegistrationServiceImpl;
import com.genghis.tools.fcm.server.data.RegistrationService;
import com.genghis.tools.fcm.server.messageutils.FcmNotification;
import com.genghis.tools.fcm.server.messageutils.FcmPacketExtension;
import com.genghis.tools.repository.repository.redis.GenghisRedisClient;
import com.genghis.tools.repository.repository.redis.RedisUtils;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.kotlin.coroutines.CoroutineVerticle;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.util.Arrays;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 42\u00020\u0001:\u000234B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010!\u001a\u00020\"2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010#\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010%\u001a\u00020\"H\u0094@\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\"H\u0094@\u00a2\u0006\u0002\u0010&J\u0006\u0010(\u001a\u00020\"J\u0016\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\"H\u0002J\b\u0010.\u001a\u00020\u0017H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0017H\u0002J\u0010\u00101\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0017H\u0002J\u0006\u00102\u001a\u00020\"R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lcom/genghis/tools/fcm/server/FcmServer;", "Lio/vertx/kotlin/coroutines/CoroutineVerticle;", "dev", "", "<init>", "(Z)V", "packageNameBase", "", "gcmSenderId", "gcmApiKey", "gcmPort", "", "messageSender", "Lcom/genghis/tools/fcm/server/MessageSender;", "dataMessageHandler", "Lcom/genghis/tools/fcm/server/data/DataMessageHandler;", "registrationService", "Lcom/genghis/tools/fcm/server/data/RegistrationService;", "redisClient", "Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;", "connectionConfiguration", "Lorg/jivesoftware/smack/ConnectionConfiguration;", "primaryConnection", "Lorg/jivesoftware/smack/Connection;", "secondaryConnection", "primaryIsDraining", "primaryConnecting", "secondaryConnecting", "sendingConnection", "getSendingConnection$genghis_tools_fcm", "()Lorg/jivesoftware/smack/Connection;", "isOnline", "()Z", "setDataMessageHandler", "", "setRegistrationService", "setMessageSender", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "checkForDeadConnections", "sendNotification", "to", "notification", "Lcom/genghis/tools/fcm/server/messageutils/FcmNotification;", "setConfiguration", "connect", "auth", "connection", "addPacketListener", "setDraining", "FcmServerBuilder", "Companion", "genghis-tools-fcm"})
public final class FcmServer
extends CoroutineVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String packageNameBase;
    @Nullable
    private String gcmSenderId;
    @Nullable
    private String gcmApiKey;
    private final int gcmPort;
    @Nullable
    private MessageSender messageSender;
    @Nullable
    private DataMessageHandler dataMessageHandler;
    @Nullable
    private RegistrationService registrationService;
    @Nullable
    private GenghisRedisClient redisClient;
    @Nullable
    private ConnectionConfiguration connectionConfiguration;
    @Nullable
    private Connection primaryConnection;
    @Nullable
    private Connection secondaryConnection;
    private boolean primaryIsDraining;
    private boolean primaryConnecting;
    private boolean secondaryConnecting;
    @NotNull
    private static final String GCM_ENDPOINT = "fcm-xmpp.googleapis.com";
    @NotNull
    public static final String GCM_HTTP_ENDPOINT = "https://fcm.googleapis.com/fcm/send";
    @NotNull
    private static final String GCM_DEVICE_GROUP_BASE = "android.googleapis.com";
    @NotNull
    private static final String GCM_DEVICE_GROUP_HTTP_ENDPOINT = "/gcm/notification";
    @NotNull
    public static final String GCM_DEVICE_GROUP_HTTP_ENDPOINT_COMPLETE = "https://android.googleapis.com/gcm/notification";

    private FcmServer(boolean dev) {
        this.gcmPort = dev ? 5236 : 5235;
    }

    @Nullable
    public final Connection getSendingConnection$genghis_tools_fcm() {
        Connection connection;
        FcmServerKt.access$getLogger$p().info(() -> FcmServer._get_sendingConnection_$lambda$0(this));
        if (this.primaryIsDraining) {
            connection = this.secondaryConnection;
        } else {
            if (this.primaryConnection != null) {
                Connection connection2 = this.primaryConnection;
                Intrinsics.checkNotNull((Object)connection2);
                if (connection2.isConnected() && this.secondaryConnection != null) {
                    Connection connection3 = this.secondaryConnection;
                    Intrinsics.checkNotNull((Object)connection3);
                    if (connection3.isConnected()) {
                        this.primaryIsDraining = false;
                        Connection connection4 = this.secondaryConnection;
                        Intrinsics.checkNotNull((Object)connection4);
                        connection4.disconnect();
                    }
                }
            }
            connection = this.primaryConnection;
        }
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOnline() {
        if (this.primaryConnection != null) {
            Connection connection = this.primaryConnection;
            Intrinsics.checkNotNull((Object)connection);
            if (!connection.isConnected()) return false;
            Connection connection2 = this.primaryConnection;
            Intrinsics.checkNotNull((Object)connection2);
            if (!connection2.isAuthenticated()) return false;
            return true;
        }
        if (this.secondaryConnection == null) return false;
        Connection connection = this.secondaryConnection;
        Intrinsics.checkNotNull((Object)connection);
        if (!connection.isConnected()) return false;
        Connection connection3 = this.secondaryConnection;
        Intrinsics.checkNotNull((Object)connection3);
        if (!connection3.isAuthenticated()) return false;
        return true;
    }

    private final void setDataMessageHandler(DataMessageHandler dataMessageHandler) {
        this.dataMessageHandler = dataMessageHandler;
    }

    private final void setRegistrationService(RegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    private final void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    @Nullable
    protected Object start(@NotNull Continuation<? super Unit> $completion) throws Exception {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FcmServer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$withContext;
                        ResultKt.throwOnFailure((Object)$result);
                        FcmServerKt.access$getLogger$p().info(() -> start.2.invokeSuspend$lambda$0((CoroutineScope)$this$withContext));
                        FcmServer.access$setPackageNameBase$p(this.this$0, FcmServer.access$getConfig(this.this$0).getString("basePackageNameFcm"));
                        FcmServer.access$setGcmSenderId$p(this.this$0, FcmServer.access$getConfig(this.this$0).getString("gcmSenderId"));
                        FcmServer.access$setGcmApiKey$p(this.this$0, FcmServer.access$getConfig(this.this$0).getString("gcmApiKey"));
                        JsonObject errors = new JsonObject();
                        if (FcmServer.access$getPackageNameBase$p(this.this$0) == null) {
                            errors.put("packageNameBase_error", (Object)"Cannot be null!");
                        }
                        if (FcmServer.access$getGcmSenderId$p(this.this$0) == null) {
                            errors.put("gcmSenderId_error", (Object)"Cannot be null!");
                        }
                        if (FcmServer.access$getGcmApiKey$p(this.this$0) == null) {
                            errors.put("gcmApiKey_error", (Object)"Cannot be null!");
                        }
                        if (!errors.isEmpty()) throw new IllegalStateException(errors.encodePrettily());
                        FcmServer.access$setConnectionConfiguration$p(this.this$0, new ConnectionConfiguration("fcm-xmpp.googleapis.com", FcmServer.access$getGcmPort$p(this.this$0)));
                        FcmServer.access$setRedisClient$p(this.this$0, (GenghisRedisClient)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this.this$0.getVertx())), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GenghisRedisClient>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ FcmServer this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return RedisUtils.INSTANCE.getRedisClient(this.this$0.getVertx(), FcmServer.access$getConfig(this.this$0));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super GenghisRedisClient> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })));
                        MessageSender messageSender = FcmServer.access$getMessageSender$p(this.this$0);
                        if (messageSender != null) {
                            GenghisRedisClient genghisRedisClient = FcmServer.access$getRedisClient$p(this.this$0);
                            Intrinsics.checkNotNull((Object)genghisRedisClient);
                            messageSender.setRedisClient$genghis_tools_fcm(genghisRedisClient);
                        }
                        FcmServer.access$setConfiguration(this.this$0);
                        try {
                            if (FcmServer.access$getPrimaryConnection$p(this.this$0) != null) {
                                Connection connection = FcmServer.access$getPrimaryConnection$p(this.this$0);
                                Intrinsics.checkNotNull((Object)connection);
                                if (connection.isConnected()) return Unit.INSTANCE;
                            }
                            FcmServer.access$setPrimaryConnection$p(this.this$0, FcmServer.access$connect(this.this$0));
                            Connection connection = FcmServer.access$getPrimaryConnection$p(this.this$0);
                            Intrinsics.checkNotNull((Object)connection);
                            FcmServer.access$addPacketListener(this.this$0, connection);
                            Connection connection2 = FcmServer.access$getPrimaryConnection$p(this.this$0);
                            Intrinsics.checkNotNull((Object)connection2);
                            FcmServer.access$auth(this.this$0, connection2);
                            FcmServerKt.access$getLogger$p().info(start.2::invokeSuspend$lambda$1);
                            return Unit.INSTANCE;
                        }
                        catch (XMPPException e) {
                            FcmServerKt.access$getLogger$p().error((Throwable)e, start.2::invokeSuspend$lambda$2);
                            throw e;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0(CoroutineScope $$this$withContext) {
                return "Starting GCM Server: " + $$this$withContext;
            }

            private static final Object invokeSuspend$lambda$1() {
                return "GCM Connection established...";
            }

            private static final Object invokeSuspend$lambda$2() {
                return "GCM Connection could not be established!";
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object stop(@NotNull Continuation<? super Unit> $completion) throws Exception {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FcmServer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$withContext;
                        ResultKt.throwOnFailure((Object)$result);
                        FcmServerKt.access$getLogger$p().info(() -> stop.2.invokeSuspend$lambda$0((CoroutineScope)$this$withContext));
                        Connection connection = FcmServer.access$getPrimaryConnection$p(this.this$0);
                        Intrinsics.checkNotNull((Object)connection);
                        connection.disconnect();
                        if (FcmServer.access$getSecondaryConnection$p(this.this$0) != null) {
                            Connection connection2 = FcmServer.access$getSecondaryConnection$p(this.this$0);
                            Intrinsics.checkNotNull((Object)connection2);
                            if (connection2.isConnected()) {
                                Connection connection3 = FcmServer.access$getSecondaryConnection$p(this.this$0);
                                Intrinsics.checkNotNull((Object)connection3);
                                connection3.disconnect();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0(CoroutineScope $$this$withContext) {
                return "Shutting down GCM Server: " + $$this$withContext + "...";
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void checkForDeadConnections() {
        block14: {
            block13: {
                block12: {
                    if (this.primaryConnection != null) {
                        Connection connection = this.primaryConnection;
                        Intrinsics.checkNotNull((Object)connection);
                        if (!connection.isConnected() && this.secondaryConnection != null) {
                            Connection connection2 = this.secondaryConnection;
                            Intrinsics.checkNotNull((Object)connection2);
                            if (connection2.isConnected()) {
                                try {
                                    FcmServerKt.access$getLogger$p().info(FcmServer::checkForDeadConnections$lambda$1);
                                    this.primaryConnecting = true;
                                    this.primaryIsDraining = false;
                                    Connection connection3 = this.primaryConnection = this.connect();
                                    Intrinsics.checkNotNull((Object)connection3);
                                    this.addPacketListener(connection3);
                                    Connection connection4 = this.primaryConnection;
                                    Intrinsics.checkNotNull((Object)connection4);
                                    this.auth(connection4);
                                    FcmServerKt.access$getLogger$p().info(FcmServer::checkForDeadConnections$lambda$2);
                                    Connection connection5 = this.secondaryConnection;
                                    Intrinsics.checkNotNull((Object)connection5);
                                    connection5.disconnect();
                                }
                                catch (XMPPException e) {
                                    FcmServerKt.access$getLogger$p().error(FcmServer::checkForDeadConnections$lambda$3);
                                }
                                this.primaryConnecting = false;
                                return;
                            }
                        }
                    }
                    if (this.primaryConnection != null) {
                        Connection connection = this.primaryConnection;
                        Intrinsics.checkNotNull((Object)connection);
                        if (connection.isConnected()) {
                            FcmServerKt.access$getLogger$p().debug(() -> FcmServer.checkForDeadConnections$lambda$4(this));
                            return;
                        }
                    }
                    if (this.primaryConnection == null) break block12;
                    Connection connection = this.primaryConnection;
                    Intrinsics.checkNotNull((Object)connection);
                    if (connection.isConnected() || this.secondaryConnection == null) break block12;
                    Connection connection6 = this.secondaryConnection;
                    Intrinsics.checkNotNull((Object)connection6);
                    if (!connection6.isConnected()) break block13;
                }
                if (this.primaryConnection != null || this.secondaryConnection != null) break block14;
            }
            if (this.primaryConnecting || this.secondaryConnecting) {
                FcmServerKt.access$getLogger$p().info(() -> FcmServer.checkForDeadConnections$lambda$5(this));
                return;
            }
            FcmServerKt.access$getLogger$p().info(FcmServer::checkForDeadConnections$lambda$6);
            try {
                this.primaryConnecting = true;
                this.primaryIsDraining = false;
                Connection connection = this.primaryConnection = this.connect();
                Intrinsics.checkNotNull((Object)connection);
                this.addPacketListener(connection);
                Connection connection7 = this.primaryConnection;
                Intrinsics.checkNotNull((Object)connection7);
                this.auth(connection7);
            }
            catch (XMPPException e) {
                e.printStackTrace();
                FcmServerKt.access$getLogger$p().error(FcmServer::checkForDeadConnections$lambda$7);
            }
            this.primaryConnecting = false;
            return;
        }
        FcmServerKt.access$getLogger$p().error(() -> FcmServer.checkForDeadConnections$lambda$8(this));
    }

    public final boolean sendNotification(@NotNull String to, @NotNull FcmNotification notification) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        String packageNameExtension = notification.getPackageNameExtension();
        String appPackageName = Intrinsics.areEqual((Object)packageNameExtension, (Object)"devApp") ? this.packageNameBase : this.packageNameBase + "." + packageNameExtension;
        MessageSender messageSender = this.messageSender;
        Intrinsics.checkNotNull((Object)messageSender);
        messageSender.send$genghis_tools_fcm(MessageSender.Companion.createCustomNotification$default(MessageSender.Companion, appPackageName, to, notification, false, 8, null));
        FcmServerKt.access$getLogger$p().info(() -> FcmServer.sendNotification$lambda$9(to));
        return true;
    }

    private final void setConfiguration() {
        ConnectionConfiguration connectionConfiguration = this.connectionConfiguration;
        Intrinsics.checkNotNull((Object)connectionConfiguration);
        connectionConfiguration.setReconnectionAllowed(true);
        ConnectionConfiguration connectionConfiguration2 = this.connectionConfiguration;
        Intrinsics.checkNotNull((Object)connectionConfiguration2);
        connectionConfiguration2.setRosterLoadedAtLogin(false);
        ConnectionConfiguration connectionConfiguration3 = this.connectionConfiguration;
        Intrinsics.checkNotNull((Object)connectionConfiguration3);
        connectionConfiguration3.setSendPresence(false);
        ConnectionConfiguration connectionConfiguration4 = this.connectionConfiguration;
        Intrinsics.checkNotNull((Object)connectionConfiguration4);
        connectionConfiguration4.setSocketFactory(SSLSocketFactory.getDefault());
        ProviderManager.getInstance().addExtensionProvider("gcm", "google:mobile:data", FcmServer::setConfiguration$lambda$10);
    }

    private final Connection connect() throws XMPPException {
        FcmServerKt.access$getLogger$p().info(FcmServer::connect$lambda$11);
        XMPPConnection connection = new XMPPConnection(this.connectionConfiguration);
        connection.connect();
        FcmServerKt.access$getLogger$p().info(FcmServer::connect$lambda$12);
        connection.addConnectionListener(new ConnectionListener(this){
            final /* synthetic */ FcmServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void reconnectionSuccessful() {
                FcmServerKt.access$getLogger$p().info(connect.3::reconnectionSuccessful$lambda$0);
            }

            public void reconnectionFailed(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FcmServerKt.access$getLogger$p().info(() -> connect.3.reconnectionFailed$lambda$1(e));
            }

            public void reconnectingIn(int seconds) {
                FcmServerKt.access$getLogger$p().info(() -> connect.3.reconnectingIn$lambda$2(seconds));
            }

            public void connectionClosedOnError(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FcmServerKt.access$getLogger$p().info(() -> connect.3.connectionClosedOnError$lambda$3(e));
                Connection connection = FcmServer.access$getPrimaryConnection$p(this.this$0);
                Intrinsics.checkNotNull((Object)connection);
                if (!connection.isConnected()) {
                    FcmServer.access$setPrimaryIsDraining$p(this.this$0, false);
                }
            }

            public void connectionClosed() {
                FcmServerKt.access$getLogger$p().info(connect.3::connectionClosed$lambda$4);
            }

            private static final Object reconnectionSuccessful$lambda$0() {
                return "Reconnected!";
            }

            private static final Object reconnectionFailed$lambda$1(Exception $e) {
                return "Reconnection failed: " + $e;
            }

            private static final Object reconnectingIn$lambda$2(int $seconds) {
                String string = "Reconnecting in %d secs";
                Object[] objectArray = new Object[]{$seconds};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }

            private static final Object connectionClosedOnError$lambda$3(Exception $e) {
                return "Connection closed on error: " + $e;
            }

            private static final Object connectionClosed$lambda$4() {
                return "Connection closed";
            }
        });
        return (Connection)connection;
    }

    private final void auth(Connection connection) throws XMPPException {
        FcmServerKt.access$getLogger$p().info(FcmServer::auth$lambda$13);
        String string = this.gcmSenderId;
        Intrinsics.checkNotNull((Object)string);
        connection.login(string + "@gcm.googleapis.com", this.gcmApiKey);
    }

    private final void addPacketListener(Connection connection) {
        FcmServerKt.access$getLogger$p().info(FcmServer::addPacketListener$lambda$14);
        GenghisRedisClient genghisRedisClient = this.redisClient;
        Intrinsics.checkNotNull((Object)genghisRedisClient);
        connection.addPacketListener((PacketListener)new XMPPPacketListener(this, genghisRedisClient, this.dataMessageHandler, this.registrationService, this.gcmSenderId, this.gcmApiKey), (PacketFilter)new PacketTypeFilter(Message.class));
        connection.addPacketInterceptor(FcmServer::addPacketListener$lambda$16, (PacketFilter)new PacketTypeFilter(Message.class));
    }

    public final void setDraining() {
        try {
            block6: {
                block5: {
                    if (this.secondaryConnection == null) break block5;
                    Connection connection = this.secondaryConnection;
                    Intrinsics.checkNotNull((Object)connection);
                    if (connection.isConnected()) break block6;
                }
                this.secondaryConnecting = true;
                for (int i = 0; i < 10; ++i) {
                    Connection connection = this.secondaryConnection = this.connect();
                    Intrinsics.checkNotNull((Object)connection);
                    this.addPacketListener(connection);
                    Connection connection2 = this.secondaryConnection;
                    Intrinsics.checkNotNull((Object)connection2);
                    this.auth(connection2);
                    Connection connection3 = this.secondaryConnection;
                    Intrinsics.checkNotNull((Object)connection3);
                    if (connection3.isConnected()) break;
                    Connection connection4 = this.secondaryConnection;
                    Intrinsics.checkNotNull((Object)connection4);
                    connection4.disconnect();
                }
                this.secondaryConnecting = false;
            }
            this.primaryIsDraining = true;
        }
        catch (XMPPException e) {
            FcmServerKt.access$getLogger$p().error(FcmServer::setDraining$lambda$17);
        }
    }

    private static final Object _get_sendingConnection_$lambda$0(FcmServer this$0) {
        return "GCM " + (this$0.primaryIsDraining ? "is" : "is not") + " draining primary connection" + (this$0.primaryIsDraining ? "!" : "...");
    }

    private static final Object checkForDeadConnections$lambda$1() {
        return "Draining on primary resolved, reconnecting...";
    }

    private static final Object checkForDeadConnections$lambda$2() {
        return "Disconnecting secondary...";
    }

    private static final Object checkForDeadConnections$lambda$3() {
        return "GCM Connection could not be established!";
    }

    private static final Object checkForDeadConnections$lambda$4(FcmServer this$0) {
        Connection connection = this$0.primaryConnection;
        Intrinsics.checkNotNull((Object)connection);
        return "Primary: " + connection.isConnected() + ", Sec is null";
    }

    private static final Object checkForDeadConnections$lambda$5(FcmServer this$0) {
        return (!this$0.primaryConnecting ? "Secondary" : "Primary") + " already attempting connection...";
    }

    private static final Object checkForDeadConnections$lambda$6() {
        return "No connection, reconnecting...";
    }

    private static final Object checkForDeadConnections$lambda$7() {
        return "GCM Connection could not be established!";
    }

    private static final Object checkForDeadConnections$lambda$8(FcmServer this$0) {
        return "UNKNOWN STATE: " + this$0.primaryConnection + " : " + this$0.secondaryConnection;
    }

    private static final Object sendNotification$lambda$9(String $to) {
        return "Passing notification to: " + $to;
    }

    private static final PacketExtension setConfiguration$lambda$10(XmlPullParser it) {
        String json = it.nextText();
        Intrinsics.checkNotNull((Object)json);
        return (PacketExtension)new FcmPacketExtension(json);
    }

    private static final Object connect$lambda$11() {
        return "Connecting to GCM...";
    }

    private static final Object connect$lambda$12() {
        return "Adding connectionlistener...";
    }

    private static final Object auth$lambda$13() {
        return "Authenticating to GCM...";
    }

    private static final Object addPacketListener$lambda$14() {
        return "Adding packetlistener and packetinterceptor...";
    }

    private static final Object addPacketListener$lambda$16$lambda$15(Packet $it) {
        String string = $it.toXML();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("&quot;");
        String string2 = "'";
        return "Sent: " + regex.replace(charSequence, string2);
    }

    private static final void addPacketListener$lambda$16(Packet it) {
        FcmServerKt.access$getLogger$p().info(() -> FcmServer.addPacketListener$lambda$16$lambda$15(it));
    }

    private static final Object setDraining$lambda$17() {
        return "Could not connect secondary on draining!";
    }

    public /* synthetic */ FcmServer(boolean dev, DefaultConstructorMarker $constructor_marker) {
        this(dev);
    }

    public static final /* synthetic */ void access$setPackageNameBase$p(FcmServer $this, String string) {
        $this.packageNameBase = string;
    }

    public static final /* synthetic */ JsonObject access$getConfig(FcmServer $this) {
        return $this.getConfig();
    }

    public static final /* synthetic */ void access$setGcmSenderId$p(FcmServer $this, String string) {
        $this.gcmSenderId = string;
    }

    public static final /* synthetic */ void access$setGcmApiKey$p(FcmServer $this, String string) {
        $this.gcmApiKey = string;
    }

    public static final /* synthetic */ String access$getPackageNameBase$p(FcmServer $this) {
        return $this.packageNameBase;
    }

    public static final /* synthetic */ String access$getGcmSenderId$p(FcmServer $this) {
        return $this.gcmSenderId;
    }

    public static final /* synthetic */ String access$getGcmApiKey$p(FcmServer $this) {
        return $this.gcmApiKey;
    }

    public static final /* synthetic */ void access$setConnectionConfiguration$p(FcmServer $this, ConnectionConfiguration connectionConfiguration) {
        $this.connectionConfiguration = connectionConfiguration;
    }

    public static final /* synthetic */ int access$getGcmPort$p(FcmServer $this) {
        return $this.gcmPort;
    }

    public static final /* synthetic */ void access$setRedisClient$p(FcmServer $this, GenghisRedisClient genghisRedisClient) {
        $this.redisClient = genghisRedisClient;
    }

    public static final /* synthetic */ MessageSender access$getMessageSender$p(FcmServer $this) {
        return $this.messageSender;
    }

    public static final /* synthetic */ GenghisRedisClient access$getRedisClient$p(FcmServer $this) {
        return $this.redisClient;
    }

    public static final /* synthetic */ void access$setConfiguration(FcmServer $this) {
        $this.setConfiguration();
    }

    public static final /* synthetic */ Connection access$getPrimaryConnection$p(FcmServer $this) {
        return $this.primaryConnection;
    }

    public static final /* synthetic */ void access$setPrimaryConnection$p(FcmServer $this, Connection connection) {
        $this.primaryConnection = connection;
    }

    public static final /* synthetic */ Connection access$connect(FcmServer $this) {
        return $this.connect();
    }

    public static final /* synthetic */ void access$addPacketListener(FcmServer $this, Connection connection) {
        $this.addPacketListener(connection);
    }

    public static final /* synthetic */ void access$auth(FcmServer $this, Connection connection) {
        $this.auth(connection);
    }

    public static final /* synthetic */ Connection access$getSecondaryConnection$p(FcmServer $this) {
        return $this.secondaryConnection;
    }

    public static final /* synthetic */ void access$setPrimaryIsDraining$p(FcmServer $this, boolean bl) {
        $this.primaryIsDraining = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/genghis/tools/fcm/server/FcmServer$Companion;", "", "<init>", "()V", "GCM_ENDPOINT", "", "GCM_HTTP_ENDPOINT", "GCM_DEVICE_GROUP_BASE", "GCM_DEVICE_GROUP_HTTP_ENDPOINT", "GCM_DEVICE_GROUP_HTTP_ENDPOINT_COMPLETE", "genghis-tools-fcm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/genghis/tools/fcm/server/FcmServer$FcmServerBuilder;", "", "<init>", "()V", "dev", "", "dataMessageHandler", "Lcom/genghis/tools/fcm/server/data/DataMessageHandler;", "registrationService", "Lcom/genghis/tools/fcm/server/data/RegistrationService;", "withDev", "withDataMessageHandler", "withRegistrationService", "build", "Lcom/genghis/tools/fcm/server/FcmServer;", "genghis-tools-fcm"})
    public static final class FcmServerBuilder {
        private boolean dev;
        @Nullable
        private DataMessageHandler dataMessageHandler;
        @Nullable
        private RegistrationService registrationService;

        @Fluent
        @NotNull
        public final FcmServerBuilder withDev(boolean dev) {
            this.dev = dev;
            return this;
        }

        @Fluent
        @NotNull
        public final FcmServerBuilder withDataMessageHandler(@NotNull DataMessageHandler dataMessageHandler) {
            Intrinsics.checkNotNullParameter((Object)dataMessageHandler, (String)"dataMessageHandler");
            this.dataMessageHandler = dataMessageHandler;
            return this;
        }

        @Fluent
        @NotNull
        public final FcmServerBuilder withRegistrationService(@NotNull RegistrationService registrationService) {
            Intrinsics.checkNotNullParameter((Object)registrationService, (String)"registrationService");
            this.registrationService = registrationService;
            return this;
        }

        @NotNull
        public final FcmServer build() {
            FcmServer fcmServer = new FcmServer(this.dev, null);
            MessageSender messageSender = new MessageSender(fcmServer);
            if (this.dataMessageHandler == null) {
                this.dataMessageHandler = new DefaultDataMessageHandlerImpl(null, 1, null);
            }
            if (this.registrationService == null) {
                this.registrationService = new DefaultRegistrationServiceImpl();
            }
            DataMessageHandler dataMessageHandler = this.dataMessageHandler;
            Intrinsics.checkNotNull((Object)dataMessageHandler);
            dataMessageHandler.setServer(fcmServer);
            RegistrationService registrationService = this.registrationService;
            Intrinsics.checkNotNull((Object)registrationService);
            registrationService.setServer(fcmServer);
            DataMessageHandler dataMessageHandler2 = this.dataMessageHandler;
            Intrinsics.checkNotNull((Object)dataMessageHandler2);
            dataMessageHandler2.setSender(messageSender);
            RegistrationService registrationService2 = this.registrationService;
            Intrinsics.checkNotNull((Object)registrationService2);
            registrationService2.setSender(messageSender);
            fcmServer.setDataMessageHandler(this.dataMessageHandler);
            fcmServer.setRegistrationService(this.registrationService);
            fcmServer.setMessageSender(messageSender);
            return fcmServer;
        }
    }
}

