/*
 * MIT License
 *
 * Copyright (c) 2017 Anders Mikkelsen
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

package com.genghis.tools.repository.utils

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import org.apache.commons.lang3.StringUtils

/**
 * This class defines aggregation functions.
 *
 * @author Anders Mikkelsen
 * @version 17.11.2017
 */
enum class AggregateFunctions {
    MIN,
    MAX,
    AVG,
    SUM,
    COUNT,
    ;

    @JsonValue
    fun toValue(): String? {
        for ((key, value) in namesMap) {
            if (value == this) {
                return key
            }
        }

        return null
    }

    companion object {
        private val namesMap = HashMap<String, AggregateFunctions>(5)

        init {
            namesMap["MIN"] = MIN
            namesMap["MAX"] = MAX
            namesMap["AVG"] = AVG
            namesMap["SUM"] = SUM
            namesMap["COUNT"] = COUNT
        }

        @JsonCreator
        fun forValue(value: String): AggregateFunctions? = namesMap[StringUtils.upperCase(value)]
    }
}
