/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.repository.dynamodb;

import com.genghis.tools.repository.dynamodb.DynamoDBRepository;
import com.genghis.tools.repository.dynamodb.DynamoDBRepositoryKt;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBAggregates;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBCreator;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBDeleter;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBParameters;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBReader;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBUpdater;
import com.genghis.tools.repository.models.DynamoDBModel;
import com.genghis.tools.repository.models.ETagable;
import com.genghis.tools.repository.models.Model;
import com.genghis.tools.repository.repository.Repository;
import com.genghis.tools.repository.repository.cache.CacheManager;
import com.genghis.tools.repository.repository.etag.ETagManager;
import com.genghis.tools.repository.repository.redis.GenghisRedisClient;
import com.genghis.tools.repository.repository.results.CreateResult;
import com.genghis.tools.repository.repository.results.DeleteResult;
import com.genghis.tools.repository.repository.results.ItemListResult;
import com.genghis.tools.repository.repository.results.ItemResult;
import com.genghis.tools.repository.repository.results.UpdateResult;
import com.genghis.tools.repository.services.internal.InternalRepositoryService;
import com.genghis.tools.repository.utils.DynamoDBQuery;
import com.genghis.tools.repository.utils.FilterParameter;
import com.genghis.tools.repository.utils.HashAndRange;
import com.genghis.tools.version.manager.VersionManager;
import com.genghis.tools.version.manager.VersionManagerImpl;
import io.github.oshai.kotlinlogging.KLogger;
import io.netty.channel.ConnectTimeoutException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kotlin.core.http.HttpClientOptionsKt;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import no.solibo.oss.vertx.client.VertxSdkClient;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.extensions.annotations.DynamoDbVersionAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondaryPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondarySortKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSortKey;
import software.amazon.awssdk.enhanced.dynamodb.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedGlobalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedLocalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.GetItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PagePublisher;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.utils.Either;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00b0\u0001*\u0014\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u0003*\u00020\u0004*\u00020\u00052\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00070\t:\u0002\u00b0\u0001BK\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011\u0012\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010d\u001a\u00020e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010f\u001a\u00020&H\u0002J\u0016\u0010g\u001a\u00020e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u000e\u0010h\u001a\u00020^2\u0006\u0010i\u001a\u00020&J\u001c\u0010h\u001a\u00020^2\u0006\u0010i\u001a\u00020&2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0014\u0010k\u001a\u00020\u00172\n\u0010j\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J+\u0010l\u001a\u0002Hm\"\u0004\b\u0001\u0010m\"\b\b\u0002\u0010n*\u00020o2\u0006\u0010i\u001a\u00020&2\u0006\u0010p\u001a\u0002Hn\u00a2\u0006\u0002\u0010qJ9\u0010l\u001a\u0002Hm\"\u0004\b\u0001\u0010m\"\b\b\u0002\u0010n*\u00020o2\u0006\u0010i\u001a\u00020&2\u0006\u0010p\u001a\u0002Hn2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u00a2\u0006\u0002\u0010rJ'\u0010s\u001a\u0004\u0018\u00010&\"\b\b\u0001\u0010m*\u00020o2\u0006\u0010i\u001a\u00020&2\u0006\u0010p\u001a\u0002Hm\u00a2\u0006\u0002\u0010tJ1\u0010s\u001a\u0004\u0018\u00010&\"\u0004\b\u0001\u0010m2\u0006\u0010i\u001a\u00020&2\u0006\u0010p\u001a\u0002Hm2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u00a2\u0006\u0002\u0010uJ\u000e\u0010v\u001a\u00020^2\u0006\u0010i\u001a\u00020&J\u001c\u0010v\u001a\u00020^2\u0006\u0010i\u001a\u00020&2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0010\u0010w\u001a\u0004\u0018\u00010&2\u0006\u0010x\u001a\u00020&J\u0014\u0010y\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010x\u001a\u00020&J%\u0010z\u001a\u00020{\"\b\b\u0001\u0010m*\u00020o2\u0006\u0010|\u001a\u00020&2\u0006\u0010p\u001a\u0002Hm\u00a2\u0006\u0002\u0010}J/\u0010z\u001a\u00020{\"\u0004\b\u0001\u0010m2\u0006\u0010|\u001a\u00020&2\u0006\u0010p\u001a\u0002Hm2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u00a2\u0006\u0002\u0010~J)\u0010\u007f\u001a\u00020{2\b\u0010i\u001a\u0004\u0018\u00010&2\u0007\u0010\u0080\u0001\u001a\u00020&2\f\b\u0002\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001H\u0007J&\u0010\u0083\u0001\u001a\u0004\u0018\u00018\u00002\u0007\u0010\u0084\u0001\u001a\u00020&2\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0003\u0010\u0086\u0001JD\u0010\u0087\u0001\u001a&\b\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020e0\u0089\u0001\u0012\u0006\u0012\u0004\u0018\u00010o0\u0088\u0001\u00a2\u0006\u0003\b\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00028\u00002\u0006\u0010i\u001a\u00020&H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001JD\u0010\u008d\u0001\u001a&\b\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020e0\u0089\u0001\u0012\u0006\u0012\u0004\u0018\u00010o0\u0088\u0001\u00a2\u0006\u0003\b\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00028\u00002\u0006\u0010i\u001a\u00020&H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001J \u0010\u008e\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0003\u0010\u0091\u0001J3\u0010\u008e\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u008f\u00012\u001a\u0010\u0092\u0001\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020e0\u0093\u0001\u00a2\u0006\u0003\b\u008a\u0001H\u0096@\u00a2\u0006\u0003\u0010\u0094\u0001J \u0010\u0095\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u0096\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0003\u0010\u0091\u0001J3\u0010\u0095\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u0096\u00012\u001a\u0010\u0092\u0001\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020e0\u0093\u0001\u00a2\u0006\u0003\b\u008a\u0001H\u0096@\u00a2\u0006\u0003\u0010\u0094\u0001J\u0019\u0010\u0097\u0001\u001a\u00020&2\u0007\u0010\u0090\u0001\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0003\u0010\u0091\u0001J,\u0010\u0097\u0001\u001a\u00020&2\u001a\u0010\u0092\u0001\u001a\u0015\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020e0\u0093\u0001\u00a2\u0006\u0003\b\u008a\u0001H\u0096@\u00a2\u0006\u0003\u0010\u0094\u0001J`\u0010\u0098\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u0099\u00012\u0007\u0010\u009a\u0001\u001a\u00020\u00172>\u0010\u009b\u0001\u001a9\u0012\u0004\u0012\u00028\u0000\u0012.\u0012,\b\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020e0\u0089\u0001\u0012\u0006\u0012\u0004\u0018\u00010o0\u009d\u0001\u00a2\u0006\u0003\b\u008a\u00010\u009c\u0001H\u0096@\u00a2\u0006\u0003\u0010\u009e\u0001J4\u0010\u009f\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u0099\u00012\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010&2\u0010\u0010\u00a0\u0001\u001a\u000b\u0012\u0004\u0012\u00020&\u0018\u00010\u0099\u0001H\u0096@\u00a2\u0006\u0003\u0010\u00a1\u0001J\u001f\u0010\u00a2\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u00a3\u00012\u0007\u0010\u008b\u0001\u001a\u00028\u0000H\u0016\u00a2\u0006\u0003\u0010\u00a4\u0001J\u0019\u0010\u00a5\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u00a3\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0007H\u0016J\"\u0010\u00a6\u0001\u001a\u0010\u0012\u000b\u0012\t\u0012\u0004\u0012\u00028\u00000\u0099\u00010\u00a3\u00012\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0007H\u0016J\u001f\u0010\u00a7\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u00a3\u00012\u0007\u0010\u008b\u0001\u001a\u00028\u0000H\u0016\u00a2\u0006\u0003\u0010\u00a4\u0001J\u001a\u0010\u00a8\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u00a3\u00012\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0016J \u0010\u00ab\u0001\u001a\t\u0012\u0004\u0012\u00020&0\u00ac\u00012\n\u0010\u00ad\u0001\u001a\u0005\u0018\u00010\u00ae\u0001\u00a2\u0006\u0003\u0010\u00af\u0001J\u0006\u00106\u001a\u00020\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010'\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00101\u001a\u0004\u0018\u00010+2\b\u0010%\u001a\u0004\u0018\u00010+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010-R\"\u00103\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010)R\u0010\u00105\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00108\u001a\u0002072\u0006\u0010%\u001a\u000207@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R*\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000;2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000;@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\"\u0010@\u001a\u0004\u0018\u00010?2\b\u0010%\u001a\u0004\u0018\u00010?@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00000JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00028\u00000NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010O\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010R\u001a\u0004\bP\u0010)R4\u0010S\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR4\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R \u0010\\\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020^0]X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R \u0010a\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020b0]X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010`\u00a8\u0006\u00b1\u0001"}, d2={"Lcom/genghis/tools/repository/dynamodb/DynamoDBRepository;", "E", "Lcom/genghis/tools/repository/models/DynamoDBModel;", "Lcom/genghis/tools/repository/models/Model;", "Lcom/genghis/tools/repository/models/Cacheable;", "Lcom/genghis/tools/repository/models/ETagable;", "Lcom/genghis/tools/repository/repository/Repository;", "Lcom/genghis/tools/repository/utils/DynamoDBQuery;", "Lcom/genghis/tools/repository/utils/DynamoDBQuery$DynamoDBQuerybuilder;", "Lcom/genghis/tools/repository/services/internal/InternalRepositoryService;", "vertx", "Lio/vertx/core/Vertx;", "modelType", "Ljava/lang/Class;", "appConfig", "Lio/vertx/core/json/JsonObject;", "cacheManager", "Lcom/genghis/tools/repository/repository/cache/CacheManager;", "eTagManager", "Lcom/genghis/tools/repository/repository/etag/ETagManager;", "<init>", "(Lio/vertx/core/Vertx;Ljava/lang/Class;Lio/vertx/core/json/JsonObject;Lcom/genghis/tools/repository/repository/cache/CacheManager;Lcom/genghis/tools/repository/repository/etag/ETagManager;)V", "isCached", "", "()Z", "setCached", "(Z)V", "isEtagEnabled", "setEtagEnabled", "versionManager", "Lcom/genghis/tools/version/manager/VersionManager;", "getVersionManager", "()Lcom/genghis/tools/version/manager/VersionManager;", "type", "getType", "()Ljava/lang/Class;", "isVersioned", "value", "", "hashIdentifier", "getHashIdentifier", "()Ljava/lang/String;", "hashField", "Ljava/lang/reflect/Method;", "getHashField", "()Ljava/lang/reflect/Method;", "setHashField", "(Ljava/lang/reflect/Method;)V", "identifier", "identifierField", "getIdentifierField", "paginationIdentifier", "getPaginationIdentifier", "paginationField", "hasRangeKey", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbEnhancedAsyncClient;", "dynamoDbMapper", "getDynamoDbMapper", "()Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbEnhancedAsyncClient;", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbAsyncTable;", "dynamoDbTable", "getDynamoDbTable", "()Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbAsyncTable;", "Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;", "redisClient", "getRedisClient", "()Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;", "parameters", "Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBParameters;", "aggregates", "Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBAggregates;", "creator", "Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBCreator;", "reader", "Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBReader;", "updater", "Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBUpdater;", "deleter", "Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBDeleter;", "modelName", "getModelName", "modelName$delegate", "Lkotlin/Lazy;", "etagManager", "getEtagManager", "()Lcom/genghis/tools/repository/repository/etag/ETagManager;", "setEtagManager", "(Lcom/genghis/tools/repository/repository/etag/ETagManager;)V", "getCacheManager", "()Lcom/genghis/tools/repository/repository/cache/CacheManager;", "setCacheManager", "(Lcom/genghis/tools/repository/repository/cache/CacheManager;)V", "fieldMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/reflect/Field;", "getFieldMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "typeMap", "Ljava/lang/reflect/Type;", "getTypeMap", "setMapper", "", "tableName", "setHashAndRange", "getField", "fieldName", "klazz", "verifyKlazz", "getFieldAsObject", "T", "O", "", "object", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "getFieldAsString", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/String;", "checkAndGetField", "getAlternativeIndexIdentifier", "indexName", "getAlternativeIndexIdentifierReturnType", "getIndexValue", "Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "alternateIndex", "(Ljava/lang/String;Ljava/lang/Object;)Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)Lsoftware/amazon/awssdk/services/dynamodb/model/AttributeValue;", "createAttributeValue", "valueAsString", "modifier", "Lsoftware/amazon/awssdk/services/dynamodb/model/ComparisonOperator;", "fetchNewestRecord", "hash", "range", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "incrementField", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "record", "(Lcom/genghis/tools/repository/models/DynamoDBModel;Ljava/lang/String;)Lkotlin/jvm/functions/Function2;", "decrementField", "show", "Lcom/genghis/tools/repository/repository/results/ItemResult;", "query", "(Lcom/genghis/tools/repository/utils/DynamoDBQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "builder", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "index", "Lcom/genghis/tools/repository/repository/results/ItemListResult;", "aggregation", "doWrite", "", "create", "records", "", "Lkotlin/Function3;", "(ZLjava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doDelete", "ranges", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remoteCreate", "Lio/vertx/core/Future;", "(Lcom/genghis/tools/repository/models/DynamoDBModel;)Lio/vertx/core/Future;", "remoteRead", "remoteIndex", "remoteUpdate", "remoteDelete", "hashAndRange", "Lcom/genghis/tools/repository/utils/HashAndRange;", "buildEventbusProjections", "", "projectionArray", "Lio/vertx/core/json/JsonArray;", "(Lio/vertx/core/json/JsonArray;)[Ljava/lang/String;", "Companion", "genghis-tools-repository"})
@SourceDebugExtension(value={"SMAP\nDynamoDBRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoDBRepository.kt\ncom/genghis/tools/repository/dynamodb/DynamoDBRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1449:1\n12637#2,2:1450\n12637#2,2:1452\n12637#2,2:1454\n*S KotlinDebug\n*F\n+ 1 DynamoDBRepository.kt\ncom/genghis/tools/repository/dynamodb/DynamoDBRepository\n*L\n340#1:1450,2\n661#1:1452,2\n679#1:1454,2\n*E\n"})
public class DynamoDBRepository<E extends DynamoDBModel & Model & ETagable>
implements Repository<E, DynamoDBQuery, DynamoDBQuery.DynamoDBQuerybuilder>,
InternalRepositoryService<E, DynamoDBQuery> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final Class<E> modelType;
    @NotNull
    private final JsonObject appConfig;
    private boolean isCached;
    private boolean isEtagEnabled;
    @NotNull
    private final VersionManager versionManager;
    @NotNull
    private final Class<E> type;
    private boolean isVersioned;
    @Nullable
    private String hashIdentifier;
    @Nullable
    private Method hashField;
    @Nullable
    private String identifier;
    @Nullable
    private Method identifierField;
    @Nullable
    private String paginationIdentifier;
    @Nullable
    private Method paginationField;
    private boolean hasRangeKey;
    private DynamoDbEnhancedAsyncClient dynamoDbMapper;
    private DynamoDbAsyncTable<E> dynamoDbTable;
    @Nullable
    private GenghisRedisClient redisClient;
    @NotNull
    private final DynamoDBParameters<E> parameters;
    @NotNull
    private final DynamoDBAggregates<E> aggregates;
    @NotNull
    private final DynamoDBCreator<E> creator;
    @NotNull
    private final DynamoDBReader<E> reader;
    @NotNull
    private final DynamoDBUpdater<E> updater;
    @NotNull
    private final DynamoDBDeleter<E> deleter;
    @NotNull
    private final Lazy modelName$delegate;
    @Nullable
    private ETagManager<E> etagManager;
    @Nullable
    private CacheManager<E> cacheManager;
    @NotNull
    private final ConcurrentHashMap<String, Field> fieldMap;
    @NotNull
    private final ConcurrentHashMap<String, Type> typeMap;
    @NotNull
    public static final String PAGINATION_INDEX = "PAGINATION_INDEX";

    public DynamoDBRepository(@NotNull Vertx vertx, @NotNull Class<E> modelType, @NotNull JsonObject appConfig, @Nullable CacheManager<E> cacheManager, @Nullable ETagManager<E> eTagManager) {
        Object object;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
                Intrinsics.checkNotNullParameter(modelType, (String)"modelType");
                Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
                this.vertx = vertx;
                this.modelType = modelType;
                this.appConfig = appConfig;
                this.versionManager = (VersionManager)new VersionManagerImpl();
                this.type = this.modelType;
                this.modelName$delegate = LazyKt.lazy(() -> DynamoDBRepository.modelName_delegate$lambda$0(this));
                this.etagManager = eTagManager;
                this.cacheManager = cacheManager;
                this.fieldMap = new ConcurrentHashMap();
                this.typeMap = new ConcurrentHashMap();
                object = this.appConfig.getString("table-suffix");
                if (object == null) break block8;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block9;
            }
            object = "";
        }
        String tableSuffix = object;
        String tableName = this.appConfig.getString("table") + tableSuffix;
        this.setMapper(this.appConfig, tableName);
        if (this.etagManager != null) {
            this.etagManager = this.etagManager;
            this.isEtagEnabled = true;
        } else {
            this.isEtagEnabled = false;
        }
        if (cacheManager != null) {
            this.cacheManager = cacheManager;
            this.isCached = true;
        } else {
            this.isCached = false;
        }
        this.isVersioned = Arrays.stream(this.getType().getDeclaredMethods()).anyMatch(arg_0 -> DynamoDBRepository._init_$lambda$5(DynamoDBRepository::_init_$lambda$4, arg_0));
        this.setHashAndRange(this.getType());
        Map gsiKeyMap = DynamoDBRepository.Companion.setGsiKeys(this.getType());
        if (this.isCached) {
            this.isCached = (Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
                int label;
                final /* synthetic */ DynamoDBRepository<E> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CacheManager cacheManager = this.this$0.getCacheManager();
                            Intrinsics.checkNotNull(cacheManager);
                            this.label = 1;
                            Object object2 = cacheManager.initializeCache((Continuation<Boolean>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        String string = this.hashIdentifier;
        Intrinsics.checkNotNull((Object)string);
        this.parameters = new DynamoDBParameters(this, string, this.identifier, this.paginationIdentifier);
        Class<E> clazz = this.getType();
        String string2 = this.hashIdentifier;
        Intrinsics.checkNotNull((Object)string2);
        this.aggregates = new DynamoDBAggregates<E>(clazz, this, string2, this.identifier, this.cacheManager, this.etagManager);
        Class<E> clazz2 = this.getType();
        String string3 = this.hashIdentifier;
        Intrinsics.checkNotNull((Object)string3);
        this.creator = new DynamoDBCreator<E>(clazz2, this, string3, this.hashField, this.identifier, this.identifierField, this.cacheManager, this.etagManager);
        Class<E> clazz3 = this.getType();
        String string4 = this.hashIdentifier;
        Intrinsics.checkNotNull((Object)string4);
        this.reader = new DynamoDBReader<E>(clazz3, this, string4, this.hashField, this.identifier, this.identifierField, this.paginationIdentifier, gsiKeyMap, this.parameters, this.cacheManager, this.etagManager);
        this.updater = new DynamoDBUpdater(this);
        Class<E> clazz4 = this.getType();
        String string5 = this.hashIdentifier;
        Intrinsics.checkNotNull((Object)string5);
        this.deleter = new DynamoDBDeleter<E>(clazz4, this, string5, this.hashField, this.identifier, this.identifierField, this.cacheManager, this.etagManager);
    }

    public /* synthetic */ DynamoDBRepository(Vertx vertx, Class clazz, JsonObject jsonObject, CacheManager cacheManager, ETagManager eTagManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Vertx vertx2 = Vertx.currentContext().owner();
            Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"owner(...)");
            vertx = vertx2;
        }
        if ((n & 8) != 0) {
            cacheManager = null;
        }
        if ((n & 0x10) != 0) {
            eTagManager = null;
        }
        this(vertx, clazz, jsonObject, cacheManager, eTagManager);
    }

    @Override
    public final boolean isCached() {
        return this.isCached;
    }

    public final void setCached(boolean bl) {
        this.isCached = bl;
    }

    @Override
    public final boolean isEtagEnabled() {
        return this.isEtagEnabled;
    }

    public final void setEtagEnabled(boolean bl) {
        this.isEtagEnabled = bl;
    }

    @Override
    @NotNull
    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    @Override
    @NotNull
    public Class<E> getType() {
        return this.type;
    }

    @Nullable
    public final String getHashIdentifier() {
        return this.hashIdentifier;
    }

    @Nullable
    public final Method getHashField() {
        return this.hashField;
    }

    public final void setHashField(@Nullable Method method) {
        this.hashField = method;
    }

    @Nullable
    public final Method getIdentifierField() {
        return this.identifierField;
    }

    @Nullable
    public final String getPaginationIdentifier() {
        return this.paginationIdentifier;
    }

    @NotNull
    public final DynamoDbEnhancedAsyncClient getDynamoDbMapper() {
        DynamoDbEnhancedAsyncClient dynamoDbEnhancedAsyncClient = this.dynamoDbMapper;
        if (dynamoDbEnhancedAsyncClient != null) {
            return dynamoDbEnhancedAsyncClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dynamoDbMapper");
        return null;
    }

    @NotNull
    public final DynamoDbAsyncTable<E> getDynamoDbTable() {
        DynamoDbAsyncTable<E> dynamoDbAsyncTable = this.dynamoDbTable;
        if (dynamoDbAsyncTable != null) {
            return dynamoDbAsyncTable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dynamoDbTable");
        return null;
    }

    @Nullable
    public final GenghisRedisClient getRedisClient() {
        return this.redisClient;
    }

    @NotNull
    public final String getModelName() {
        Lazy lazy = this.modelName$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    @Override
    @Nullable
    public final ETagManager<E> getEtagManager() {
        return this.etagManager;
    }

    protected final void setEtagManager(@Nullable ETagManager<E> eTagManager) {
        this.etagManager = eTagManager;
    }

    @Nullable
    public final CacheManager<E> getCacheManager() {
        return this.cacheManager;
    }

    protected final void setCacheManager(@Nullable CacheManager<E> cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    @NotNull
    public ConcurrentHashMap<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    @Override
    @NotNull
    public ConcurrentHashMap<String, Type> getTypeMap() {
        return this.typeMap;
    }

    private final void setMapper(JsonObject appConfig, String tableName) {
        DynamoDbEnhancedAsyncClient dynamoDbEnhancedAsyncClient;
        String dynamoDBId = appConfig.getString("dynamo_db_iam_id");
        String dynamoDBKey = appConfig.getString("dynamo_db_iam_key");
        String endPoint = DynamoDBRepository.Companion.fetchEndPoint(appConfig);
        String region = DynamoDBRepository.Companion.fetchRegion(appConfig);
        AwsAsyncClientBuilder awsAsyncClientBuilder = (AwsAsyncClientBuilder)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)region))).endpointOverride(URI.create(endPoint))).overrideConfiguration(DynamoDBRepository::setMapper$lambda$6);
        HttpClientOptions httpClientOptions = HttpClientOptionsKt.httpClientOptionsOf$default(null, null, null, null, null, null, null, null, (Boolean)true, null, (Integer)30, (Integer)30, (Integer)30, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Integer)30, null, null, null, null, null, null, null, (Integer)30, null, null, (Integer)30, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (int)-536878337, (int)536870623, null);
        Context context = this.vertx.getOrCreateContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getOrCreateContext(...)");
        AwsAsyncClientBuilder awsAsyncClientBuilder2 = VertxSdkClient.Companion.withVertx(awsAsyncClientBuilder, httpClientOptions, context);
        Intrinsics.checkNotNull((Object)awsAsyncClientBuilder2);
        DynamoDbAsyncClientBuilder dynamo = (DynamoDbAsyncClientBuilder)awsAsyncClientBuilder2;
        if (dynamoDBId != null && dynamoDBKey != null) {
            AwsBasicCredentials creds = AwsBasicCredentials.create((String)dynamoDBId, (String)dynamoDBKey);
            StaticCredentialsProvider statCreds = StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)creds));
            dynamoDbEnhancedAsyncClient = DynamoDbEnhancedAsyncClient.builder().dynamoDbClient((DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)dynamo.credentialsProvider((AwsCredentialsProvider)statCreds)).build()).build();
        } else {
            dynamoDbEnhancedAsyncClient = DynamoDbEnhancedAsyncClient.builder().dynamoDbClient((DynamoDbAsyncClient)dynamo.build()).build();
        }
        DynamoDbEnhancedAsyncClient dynamoDbEnhancedAsyncClient2 = dynamoDbEnhancedAsyncClient;
        Intrinsics.checkNotNull((Object)dynamoDbEnhancedAsyncClient2);
        this.dynamoDbMapper = dynamoDbEnhancedAsyncClient2;
        DynamoDbAsyncTable dynamoDbAsyncTable = this.getDynamoDbMapper().table(tableName, (TableSchema)TableSchema.fromBean(this.getType()));
        Intrinsics.checkNotNullExpressionValue((Object)dynamoDbAsyncTable, (String)"table(...)");
        this.dynamoDbTable = dynamoDbAsyncTable;
    }

    private final void setHashAndRange(Class<E> type) {
        Method[] allMethods = DynamoDBRepository.Companion.getAllMethodsOnType(type);
        this.hashIdentifier = "";
        this.identifier = "";
        this.paginationIdentifier = "";
        Arrays.stream(allMethods).filter(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$10(DynamoDBRepository::setHashAndRange$lambda$9, arg_0)).findFirst().ifPresent(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$13(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$12(this, arg_0), arg_0));
        Arrays.stream(allMethods).filter(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$17(DynamoDBRepository::setHashAndRange$lambda$16, arg_0)).findFirst().ifPresent(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$20(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$19(this, arg_0), arg_0));
        Arrays.stream(allMethods).filter(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$25(DynamoDBRepository::setHashAndRange$lambda$24, arg_0)).findFirst().ifPresent(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$28(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$27(this, arg_0), arg_0));
        CharSequence charSequence = this.identifier;
        this.hasRangeKey = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @NotNull
    public final Field getField(@NotNull String fieldName) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            Field field;
            Field field2 = field = this.getFieldMap().get(fieldName);
            if (field2 != null) {
                return field2;
            }
            field = this.getType().getDeclaredField(fieldName);
            if (field != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            Field field3 = field;
            Intrinsics.checkNotNull((Object)field3);
            field3.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (this.getType().getSuperclass() != null && !Intrinsics.areEqual(this.getType().getSuperclass(), Object.class)) {
                Class<E> clazz = this.getType().getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getField(fieldName, clazz);
            }
            throw new UnknownError("Cannot get field " + fieldName + " from " + this.getType().getSimpleName() + "!");
        }
        catch (NullPointerException e) {
            if (this.getType().getSuperclass() != null && !Intrinsics.areEqual(this.getType().getSuperclass(), Object.class)) {
                Class<E> clazz = this.getType().getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getField(fieldName, clazz);
            }
            throw new UnknownError("Cannot get field " + fieldName + " from " + this.getType().getSimpleName() + "!");
        }
    }

    private final Field getField(String fieldName, Class<?> klazz) throws IllegalArgumentException {
        try {
            Field field;
            Field field2 = field = this.getFieldMap().get(fieldName);
            if (field2 != null) {
                return field2;
            }
            field = klazz.getDeclaredField(fieldName);
            if (field != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            Field field3 = field;
            Intrinsics.checkNotNull((Object)field3);
            field3.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (this.verifyKlazz(klazz)) {
                Class<?> clazz = klazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getField(fieldName, clazz);
            }
            DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, () -> DynamoDBRepository.getField$lambda$29(fieldName, klazz));
            throw new UnknownError("Cannot find field!");
        }
        catch (NullPointerException e) {
            if (this.verifyKlazz(klazz)) {
                Class<?> clazz = klazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getField(fieldName, clazz);
            }
            DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, () -> DynamoDBRepository.getField$lambda$30(fieldName, klazz));
            throw new UnknownError("Cannot find field!");
        }
    }

    private final boolean verifyKlazz(Class<?> klazz) {
        return klazz.getSuperclass() != null && !Intrinsics.areEqual(klazz.getSuperclass(), Object.class);
    }

    public final <T, O> T getFieldAsObject(@NotNull String fieldName, @NotNull O object) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(object, (String)"object");
        try {
            Field field;
            Field field2 = field = this.getFieldMap().get(fieldName);
            if (field2 != null) {
                return (T)field2.get(object);
            }
            field = object.getClass().getDeclaredField(fieldName);
            if (field != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            Field field3 = field;
            Intrinsics.checkNotNull((Object)field3);
            field3.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            if (object.getClass().getSuperclass() != null && !Intrinsics.areEqual(object.getClass().getSuperclass(), Object.class)) {
                Class<?> clazz = object.getClass().getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getFieldAsObject(fieldName, object, clazz);
            }
            DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, () -> DynamoDBRepository.getFieldAsObject$lambda$31(fieldName, object));
            throw new UnknownError("Cannot find field: " + fieldName + "!");
        }
    }

    private final <T, O> T getFieldAsObject(String fieldName, O object, Class<?> klazz) {
        try {
            Field field;
            Field field2 = field = this.getFieldMap().get(fieldName);
            if (field2 != null) {
                return (T)field2.get(object);
            }
            field = object.getClass().getDeclaredField(fieldName);
            if (field != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            Field field3 = field;
            Intrinsics.checkNotNull((Object)field3);
            field3.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            if (klazz.getSuperclass() != null && !Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) {
                Class<?> clazz = klazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getFieldAsObject(fieldName, object, clazz);
            }
            DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, () -> DynamoDBRepository.getFieldAsObject$lambda$32(fieldName, klazz));
            throw new UnknownError("Cannot find field: " + fieldName + "!");
        }
    }

    @Nullable
    public final <T> String getFieldAsString(@NotNull String fieldName, @NotNull T object) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(object, (String)"object");
        if (KLogger.DefaultImpls.isTraceEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
            DynamoDBRepositoryKt.access$getLogger$p().trace(() -> DynamoDBRepository.getFieldAsString$lambda$33(fieldName, object));
        }
        try {
            Field field = this.getFieldMap().get(fieldName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(object).toString();
            }
            field = this.getType().getDeclaredField(fieldName);
            if (field != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            Field field2 = field;
            Intrinsics.checkNotNull((Object)field2);
            field2.setAccessible(true);
            Object fieldObject = field.get(object);
            return fieldObject.toString();
        }
        catch (Exception e) {
            if (this.getType().getSuperclass() == null || Intrinsics.areEqual(this.getType().getSuperclass(), Object.class)) {
                DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, () -> DynamoDBRepository.getFieldAsString$lambda$34(fieldName, object));
                throw new UnknownError("Cannot find field: " + fieldName + "!");
            }
            Class<E> clazz = this.getType().getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            return this.getFieldAsString(fieldName, object, clazz);
        }
    }

    private final <T> String getFieldAsString(String fieldName, T object, Class<?> klazz) {
        if (KLogger.DefaultImpls.isTraceEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
            DynamoDBRepositoryKt.access$getLogger$p().trace(() -> DynamoDBRepository.getFieldAsString$lambda$35(fieldName, klazz));
        }
        try {
            Object fieldObject;
            Field field = this.getFieldMap().get(fieldName);
            if (field != null) {
                field.setAccessible(true);
                Object object2 = field.get(object);
                return object2 != null ? object2.toString() : null;
            }
            field = klazz.getDeclaredField(fieldName);
            if (field != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            Field field2 = field;
            Intrinsics.checkNotNull((Object)field2);
            field2.setAccessible(true);
            Object object3 = fieldObject = field.get(object);
            return object3 != null ? object3.toString() : null;
        }
        catch (Exception e) {
            if (klazz.getSuperclass() == null || Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) {
                DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, () -> DynamoDBRepository.getFieldAsString$lambda$36(fieldName, object));
                throw new UnknownError("Cannot find field: " + fieldName + "!");
            }
            Class<?> clazz = klazz.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            return this.getFieldAsString(fieldName, object, clazz);
        }
    }

    @NotNull
    public final Field checkAndGetField(@NotNull String fieldName) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            Type fieldType;
            Field field = this.getFieldMap().get(fieldName);
            if (field == null && (field = this.getType().getDeclaredField(fieldName)) != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            if ((fieldType = this.getTypeMap().get(fieldName)) == null) {
                Field field2 = field;
                Intrinsics.checkNotNull((Object)field2);
                fieldType = field2.getType();
                if (fieldType != null) {
                    ((Map)this.getTypeMap()).put(fieldName, fieldType);
                }
            }
            if (fieldType == Long.class || fieldType == Integer.class || fieldType == Double.class || fieldType == Float.class || fieldType == Short.class || fieldType == Long.TYPE || fieldType == Integer.TYPE || fieldType == Double.TYPE || fieldType == Float.TYPE || fieldType == Short.TYPE) {
                Field field3 = field;
                Intrinsics.checkNotNull((Object)field3);
                field3.setAccessible(true);
                return field;
            }
            throw new IllegalArgumentException("Not an incrementable field: " + fieldName + "!");
        }
        catch (NoSuchFieldException e) {
            if (this.getType().getSuperclass() == null || Intrinsics.areEqual(this.getType().getSuperclass(), Object.class)) {
                throw new IllegalArgumentException("Field does not exist: " + fieldName + "!");
            }
            Class<E> clazz = this.getType().getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            return this.checkAndGetField(fieldName, clazz);
        }
        catch (NullPointerException e) {
            if (this.getType().getSuperclass() == null || Intrinsics.areEqual(this.getType().getSuperclass(), Object.class)) {
                throw new IllegalArgumentException("Field does not exist: " + fieldName + "!");
            }
            Class<E> clazz = this.getType().getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            return this.checkAndGetField(fieldName, clazz);
        }
    }

    private final Field checkAndGetField(String fieldName, Class<?> klazz) throws IllegalArgumentException {
        try {
            Type fieldType;
            Field field = this.getFieldMap().get(fieldName);
            if (field == null && (field = klazz.getDeclaredField(fieldName)) != null) {
                ((Map)this.getFieldMap()).put(fieldName, field);
            }
            if ((fieldType = this.getTypeMap().get(fieldName)) == null) {
                Field field2 = field;
                Intrinsics.checkNotNull((Object)field2);
                fieldType = field2.getType();
                if (fieldType != null) {
                    ((Map)this.getTypeMap()).put(fieldName, fieldType);
                }
            }
            if (fieldType == Long.class || fieldType == Integer.class || fieldType == Double.class || fieldType == Float.class || fieldType == Short.class || fieldType == Long.TYPE || fieldType == Integer.TYPE || fieldType == Double.TYPE || fieldType == Float.TYPE || fieldType == Short.TYPE) {
                Field field3 = field;
                Intrinsics.checkNotNull((Object)field3);
                field3.setAccessible(true);
                return field;
            }
            throw new IllegalArgumentException("Not an incrementable field: " + fieldName + "!");
        }
        catch (NoSuchFieldException e) {
            if (klazz.getSuperclass() == null || Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) {
                throw new IllegalArgumentException("Field does not exist: " + fieldName + "!");
            }
            return this.checkAndGetField(fieldName, klazz);
        }
    }

    @Nullable
    public final String getAlternativeIndexIdentifier(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        String[] identifier = new String[1];
        Arrays.stream(this.getType().getMethods()).filter(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifier$lambda$41(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifier$lambda$40(indexName, arg_0), arg_0)).findFirst().ifPresent(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifier$lambda$43(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifier$lambda$42(identifier, arg_0), arg_0));
        return identifier[0];
    }

    @Nullable
    public final Class<?> getAlternativeIndexIdentifierReturnType(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Class[] identifier = new Class[1];
        Arrays.stream(this.getType().getMethods()).filter(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifierReturnType$lambda$48(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifierReturnType$lambda$47(indexName, arg_0), arg_0)).findFirst().ifPresent(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifierReturnType$lambda$50(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifierReturnType$lambda$49(identifier, arg_0), arg_0));
        return identifier[0];
    }

    @NotNull
    public final <T> AttributeValue getIndexValue(@NotNull String alternateIndex, @NotNull T object) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)alternateIndex, (String)"alternateIndex");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            try {
                AttributeValue attributeValue;
                Field field = this.getFieldMap().get(alternateIndex);
                if (field == null && (field = object.getClass().getDeclaredField(alternateIndex)) != null) {
                    ((Map)this.getFieldMap()).put(alternateIndex, field);
                }
                Field field2 = field;
                if (field2 != null) {
                    field2.setAccessible(true);
                }
                Type fieldType = this.getTypeMap().get(alternateIndex);
                if (fieldType == null) {
                    Field field3 = field;
                    fieldType = field3 != null ? field3.getType() : null;
                    if (fieldType != null) {
                        ((Map)this.getTypeMap()).put(alternateIndex, fieldType);
                    }
                }
                if (fieldType == Date.class) {
                    Field field4 = field;
                    Object object2 = field4 != null ? field4.get(object) : null;
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.Date");
                    Date dateObject = (Date)object2;
                    attributeValue = DynamoDBRepository.createAttributeValue$default(this, alternateIndex, String.valueOf(dateObject.getTime()), null, 4, null);
                } else {
                    Field field5 = field;
                    attributeValue = DynamoDBRepository.createAttributeValue$default(this, alternateIndex, String.valueOf(field5 != null ? field5.get(object) : null), null, 4, null);
                }
                return attributeValue;
            }
            catch (NoSuchFieldException e) {
                if (object.getClass().getSuperclass() != null && !Intrinsics.areEqual(object.getClass().getSuperclass(), Object.class)) {
                    Class<?> clazz = object.getClass().getSuperclass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                    return this.getIndexValue(alternateIndex, object, clazz);
                }
            }
            catch (NullPointerException e) {
                if (object.getClass().getSuperclass() != null && !Intrinsics.areEqual(object.getClass().getSuperclass(), Object.class)) {
                    Class<?> clazz = object.getClass().getSuperclass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                    return this.getIndexValue(alternateIndex, object, clazz);
                }
            }
            catch (IllegalAccessException e) {
                if (object.getClass().getSuperclass() == null || Intrinsics.areEqual(object.getClass().getSuperclass(), Object.class)) break block12;
                Class<?> clazz = object.getClass().getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getIndexValue(alternateIndex, object, clazz);
            }
        }
        throw new UnknownError("Cannot find field!");
    }

    private final <T> AttributeValue getIndexValue(String alternateIndex, T object, Class<?> klazz) {
        block10: {
            try {
                AttributeValue attributeValue;
                Field field = this.getFieldMap().get(alternateIndex);
                if (field == null && (field = klazz.getDeclaredField(alternateIndex)) != null) {
                    ((Map)this.getFieldMap()).put(alternateIndex, field);
                }
                Field field2 = field;
                Intrinsics.checkNotNull((Object)field2);
                field2.setAccessible(true);
                Type fieldType = this.getTypeMap().get(alternateIndex);
                if (fieldType == null && (fieldType = (Type)field.getType()) != null) {
                    ((Map)this.getTypeMap()).put(alternateIndex, fieldType);
                }
                if (fieldType == Date.class) {
                    Object object2 = field.get(object);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.Date");
                    Date dateObject = (Date)object2;
                    attributeValue = DynamoDBRepository.createAttributeValue$default(this, alternateIndex, String.valueOf(dateObject.getTime()), null, 4, null);
                } else {
                    attributeValue = DynamoDBRepository.createAttributeValue$default(this, alternateIndex, field.get(object).toString(), null, 4, null);
                }
                return attributeValue;
            }
            catch (NoSuchFieldException e) {
                if (klazz.getSuperclass() != null && !Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) {
                    Class<?> clazz = klazz.getSuperclass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                    return this.getIndexValue(alternateIndex, object, clazz);
                }
            }
            catch (NullPointerException e) {
                if (klazz.getSuperclass() != null && !Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) {
                    Class<?> clazz = klazz.getSuperclass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                    return this.getIndexValue(alternateIndex, object, clazz);
                }
            }
            catch (IllegalAccessException e) {
                if (klazz.getSuperclass() == null || Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) break block10;
                Class<?> clazz = klazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                return this.getIndexValue(alternateIndex, object, clazz);
            }
        }
        throw new UnknownError("Cannot find field!");
    }

    @JvmOverloads
    @NotNull
    public final AttributeValue createAttributeValue(@Nullable String fieldName, @NotNull String valueAsString, @Nullable ComparisonOperator modifier) {
        Intrinsics.checkNotNullParameter((Object)valueAsString, (String)"valueAsString");
        if (fieldName == null) {
            throw new IllegalArgumentException("Fieldname cannot be null!");
        }
        Field field = this.getField(fieldName);
        Type fieldType = this.getTypeMap().get(fieldName);
        if (fieldType == null && (fieldType = (Type)field.getType()) != null) {
            ((Map)this.getTypeMap()).put(fieldName, fieldType);
        }
        Type type = fieldType;
        String fieldTypeName = type != null ? type.getTypeName() : null;
        if (StringsKt.equals((String)fieldTypeName, (String)"String", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.String", (boolean)true)) {
            AttributeValue attributeValue = AttributeValue.fromS((String)valueAsString);
            Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromS(...)");
            return attributeValue;
        }
        if (StringsKt.equals((String)fieldTypeName, (String)"Int", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Int", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"Integer", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Integer", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"Double", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Double", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"Long", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Long", (boolean)true)) {
            try {
                if (StringsKt.equals((String)fieldTypeName, (String)"Int", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"Integer", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Integer", (boolean)true)) {
                    int value = Integer.parseInt(valueAsString);
                    if (modifier == ComparisonOperator.GE) {
                        --value;
                    }
                    if (modifier == ComparisonOperator.LE) {
                        ++value;
                    }
                    AttributeValue attributeValue = AttributeValue.fromN((String)String.valueOf(value));
                    Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                    return attributeValue;
                }
                if (StringsKt.equals((String)fieldTypeName, (String)"Double", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Double", (boolean)true)) {
                    double value = Double.parseDouble(valueAsString);
                    if (modifier == ComparisonOperator.GE) {
                        value -= 0.1;
                    }
                    if (modifier == ComparisonOperator.LE) {
                        value += 0.1;
                    }
                    AttributeValue attributeValue = AttributeValue.fromN((String)String.valueOf(value));
                    Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                    return attributeValue;
                }
                if (StringsKt.equals((String)fieldTypeName, (String)"Long", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Long", (boolean)true)) {
                    long value = Long.parseLong(valueAsString);
                    if (modifier == ComparisonOperator.GE) {
                        --value;
                    }
                    if (modifier == ComparisonOperator.LE) {
                        ++value;
                    }
                    AttributeValue attributeValue = AttributeValue.fromN((String)String.valueOf(value));
                    Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                    return attributeValue;
                }
                AttributeValue attributeValue = AttributeValue.fromN((String)valueAsString);
                Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                return attributeValue;
            }
            catch (NumberFormatException nfe) {
                DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)nfe, DynamoDBRepository::createAttributeValue$lambda$51);
                AttributeValue attributeValue = AttributeValue.fromN((String)valueAsString);
                Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                return attributeValue;
            }
        }
        if (StringsKt.equals((String)fieldTypeName, (String)"Boolean", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.lang.Boolean", (boolean)true)) {
            if (StringsKt.equals((String)valueAsString, (String)"true", (boolean)true)) {
                AttributeValue attributeValue = AttributeValue.fromN((String)"1");
                Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                return attributeValue;
            }
            if (StringsKt.equals((String)valueAsString, (String)"false", (boolean)true)) {
                AttributeValue attributeValue = AttributeValue.fromN((String)"0");
                Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                return attributeValue;
            }
            try {
                int boolValue = Integer.parseInt(valueAsString);
                switch (boolValue) {
                    case 0: 
                    case 1: {
                        AttributeValue attributeValue = AttributeValue.fromN((String)String.valueOf(boolValue));
                        Intrinsics.checkNotNullExpressionValue((Object)attributeValue, (String)"fromN(...)");
                        return attributeValue;
                    }
                }
                throw new UnknownError("Cannot create AttributeValue: " + fieldName + "!");
            }
            catch (NumberFormatException nfe) {
                DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)nfe, DynamoDBRepository::createAttributeValue$lambda$52);
            }
        } else {
            AttributeValue attributeValue;
            if (StringsKt.equals((String)fieldTypeName, (String)"Date", (boolean)true) || StringsKt.equals((String)fieldTypeName, (String)"java.util.Date", (boolean)true)) {
                AttributeValue attributeValue2;
                try {
                    Date date;
                    if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                        DynamoDBRepositoryKt.access$getLogger$p().debug(() -> DynamoDBRepository.createAttributeValue$lambda$53(valueAsString));
                    }
                    try {
                        date = new Date(Long.parseLong(valueAsString));
                    }
                    catch (NumberFormatException nfe) {
                        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                        Date date2 = df1.parse(valueAsString);
                        Intrinsics.checkNotNull((Object)date2);
                        date = date2;
                    }
                    Date date3 = date;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date3);
                    if (modifier == ComparisonOperator.LE) {
                        calendar.add(14, 1);
                    }
                    if (modifier == ComparisonOperator.GE) {
                        calendar.setTime(new Date(calendar.getTime().getTime() - 1L));
                    }
                    SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                    df2.setTimeZone(TimeZone.getTimeZone("Z"));
                    if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                        DynamoDBRepositoryKt.access$getLogger$p().debug(() -> DynamoDBRepository.createAttributeValue$lambda$54(df2, calendar));
                    }
                    attributeValue2 = AttributeValue.fromS((String)df2.format(calendar.getTime()));
                }
                catch (ParseException e) {
                    attributeValue2 = AttributeValue.fromS((String)valueAsString);
                }
                AttributeValue attributeValue3 = attributeValue2;
                Intrinsics.checkNotNull((Object)attributeValue3);
                attributeValue = attributeValue3;
            } else {
                AttributeValue attributeValue4 = AttributeValue.fromS((String)valueAsString);
                attributeValue = attributeValue4;
                Intrinsics.checkNotNullExpressionValue((Object)attributeValue4, (String)"fromS(...)");
            }
            return attributeValue;
        }
        throw new UnknownError("Cannot create attributevalue: " + fieldName + "!");
    }

    public static /* synthetic */ AttributeValue createAttributeValue$default(DynamoDBRepository dynamoDBRepository, String string, String string2, ComparisonOperator comparisonOperator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createAttributeValue");
        }
        if ((n & 4) != 0) {
            comparisonOperator = null;
        }
        return dynamoDBRepository.createAttributeValue(string, string2, comparisonOperator);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object fetchNewestRecord(@NotNull String hash, @Nullable String range, @NotNull Continuation<? super E> $completion) {
        if (!($completion instanceof fetchNewestRecord.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ DynamoDBRepository<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetchNewestRecord(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.hasRangeKey() && range == null) break;
                if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                    DynamoDBRepositoryKt.access$getLogger$p().debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchNewestRecord$lambda$55(com.genghis.tools.repository.dynamodb.DynamoDBRepository ), ()Ljava/lang/Object;)((DynamoDBRepository)this));
                }
                fetchFuture = Promise.promise();
                this.getDynamoDbTable().getItem(GetItemEnhancedRequest.builder().consistentRead(Boxing.boxBoolean((boolean)true)).key((Consumer<Key.Builder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, fetchNewestRecord$lambda$56(java.lang.String com.genghis.tools.repository.dynamodb.DynamoDBRepository java.lang.String software.amazon.awssdk.enhanced.dynamodb.Key$Builder ), (Lsoftware/amazon/awssdk/enhanced/dynamodb/Key$Builder;)V)((String)hash, (DynamoDBRepository)this, (String)range)).build()).whenComplete((BiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, fetchNewestRecord$lambda$58(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, fetchNewestRecord$lambda$57(io.vertx.core.Promise com.genghis.tools.repository.models.DynamoDBModel java.lang.Throwable ), (Lcom/genghis/tools/repository/models/DynamoDBModel;Ljava/lang/Throwable;)Lkotlin/Unit;)((Promise)fetchFuture)));
                v0 = fetchFuture.future();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"future(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)hash);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)range);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fetchFuture);
                $continuation.label = 1;
                v1 = VertxCoroutineKt.coAwait((Future)v0, (Continuation)$continuation);
                if (v1 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl35
            }
            case 1: {
                fetchFuture = (Promise)$continuation.L$2;
                range = (String)$continuation.L$1;
                hash = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                return v1;
            }
        }
        var4_9 = this;
        $this$fetchNewestRecord_u24lambda_u2465 = var4_9;
        $i$a$-runCatching-DynamoDBRepository$fetchNewestRecord$5 = 0;
        if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
            DynamoDBRepositoryKt.access$getLogger$p().debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchNewestRecord$lambda$65$lambda$59(), ()Ljava/lang/Object;)());
        }
        timeBefore = System.currentTimeMillis();
        items = $this$fetchNewestRecord_u24lambda_u2465.getDynamoDbTable().query(QueryEnhancedRequest.builder().consistentRead(Boxing.boxBoolean((boolean)true)).limit(Boxing.boxInt((int)1)).queryConditional(QueryConditional.keyEqualTo((Consumer<Key.Builder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, fetchNewestRecord$lambda$65$lambda$60(java.lang.String software.amazon.awssdk.enhanced.dynamodb.Key$Builder ), (Lsoftware/amazon/awssdk/enhanced/dynamodb/Key$Builder;)V)((String)hash))).build());
        if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
            DynamoDBRepositoryKt.access$getLogger$p().debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchNewestRecord$lambda$65$lambda$61(long ), ()Ljava/lang/Object;)((long)timeBefore));
        }
        result = new ArrayList<E>();
        fetchFuture = Promise.promise();
        items.items().subscribe((Consumer<DynamoDBModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, fetchNewestRecord$lambda$65$lambda$62(java.util.List com.genghis.tools.repository.models.DynamoDBModel ), (Lcom/genghis/tools/repository/models/DynamoDBModel;)V)((List)result)).whenComplete((BiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, fetchNewestRecord$lambda$65$lambda$64(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, fetchNewestRecord$lambda$65$lambda$63(io.vertx.core.Promise java.util.List java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)Lkotlin/Unit;)((Promise)fetchFuture, (List)result)));
        v2 = fetchFuture.future();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"future(...)");
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)hash);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)range);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$fetchNewestRecord_u24lambda_u2465);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)items);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)result);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fetchFuture);
        $continuation.I$0 = $i$a$-runCatching-DynamoDBRepository$fetchNewestRecord$5;
        $continuation.J$0 = timeBefore;
        $continuation.label = 2;
        v3 = VertxCoroutineKt.coAwait((Future)v2, (Continuation)$continuation);
        ** if (v3 != var14_6) goto lbl66
lbl65:
        // 1 sources

        return var14_6;
lbl66:
        // 1 sources

        ** GOTO lbl80
        {
            case 2: {
                timeBefore = $continuation.J$0;
                $i$a$-runCatching-DynamoDBRepository$fetchNewestRecord$5 = $continuation.I$0;
                fetchFuture = (Promise)$continuation.L$5;
                result = (List)$continuation.L$4;
                items = (PagePublisher)$continuation.L$3;
                $this$fetchNewestRecord_u24lambda_u2465 = (DynamoDBRepository)$continuation.L$2;
                range = (String)$continuation.L$1;
                hash = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl80:
                    // 2 sources

                    var5_10 = Result.constructor-impl((Object)((DynamoDBModel)v3));
                }
                catch (Throwable $i$a$-runCatching-DynamoDBRepository$fetchNewestRecord$5) {
                    var5_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DynamoDBRepository$fetchNewestRecord$5));
                }
                var4_9 = var5_10;
                v4 = Result.exceptionOrNull-impl((Object)var4_9);
                if (v4 != null) {
                    it = var5_10 = v4;
                    $i$a$-onFailure-DynamoDBRepository$fetchNewestRecord$6 = false;
                    DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)it, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetchNewestRecord$lambda$67$lambda$66(), ()Ljava/lang/Object;)());
                }
                ResultKt.throwOnFailure((Object)var4_9);
                return (DynamoDBModel)var4_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public Function2<E, Continuation<? super Unit>, Object> incrementField(@NotNull E record, @NotNull String fieldName) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return new Function2<E, Continuation<? super Unit>, Object>(this, fieldName, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ String $fieldName;
            {
                this.this$0 = $receiver;
                this.$fieldName = $fieldName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DynamoDBModel dynamoDBModel = (DynamoDBModel)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void <this>;
                        ResultKt.throwOnFailure((Object)$result);
                        DynamoDBRepository.access$getUpdater$p(this.this$0).incrementField((ETagable)<this>, this.$fieldName);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(E p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    @Override
    @NotNull
    public Function2<E, Continuation<? super Unit>, Object> decrementField(@NotNull E record, @NotNull String fieldName) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return new Function2<E, Continuation<? super Unit>, Object>(this, fieldName, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ String $fieldName;
            {
                this.this$0 = $receiver;
                this.$fieldName = $fieldName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DynamoDBModel dynamoDBModel = (DynamoDBModel)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void <this>;
                        ResultKt.throwOnFailure((Object)$result);
                        DynamoDBRepository.access$getUpdater$p(this.this$0).decrementField((ETagable)<this>, this.$fieldName);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(E p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    @Override
    @Nullable
    public Object show(@NotNull DynamoDBQuery query, @NotNull Continuation<? super ItemResult<? extends E>> $completion) {
        return this.reader.show(query, $completion);
    }

    @Override
    @Nullable
    public Object show(@NotNull Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit> builder, @NotNull Continuation<? super ItemResult<? extends E>> $completion) {
        return DynamoDBRepository.show$suspendImpl(this, builder, $completion);
    }

    static /* synthetic */ <E extends DynamoDBModel & Model & ETagable> Object show$suspendImpl(DynamoDBRepository<E> $this, Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit> builder, Continuation<? super ItemResult<? extends E>> $completion) {
        DynamoDBQuery.DynamoDBQuerybuilder queryBuilder = new DynamoDBQuery.DynamoDBQuerybuilder();
        builder.invoke((Object)queryBuilder);
        DynamoDBQuery queryResult = queryBuilder.build();
        return $this.show(queryResult, $completion);
    }

    @Override
    @Nullable
    public Object index(@NotNull DynamoDBQuery query, @NotNull Continuation<? super ItemListResult<E>> $completion) {
        return this.reader.index(query, $completion);
    }

    @Override
    @Nullable
    public Object index(@NotNull Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit> builder, @NotNull Continuation<? super ItemListResult<E>> $completion) {
        return DynamoDBRepository.index$suspendImpl(this, builder, $completion);
    }

    static /* synthetic */ <E extends DynamoDBModel & Model & ETagable> Object index$suspendImpl(DynamoDBRepository<E> $this, Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit> builder, Continuation<? super ItemListResult<E>> $completion) {
        DynamoDBQuery.DynamoDBQuerybuilder queryBuilder = new DynamoDBQuery.DynamoDBQuerybuilder();
        builder.invoke((Object)queryBuilder);
        DynamoDBQuery queryResult = queryBuilder.build();
        return $this.index(queryResult, $completion);
    }

    @Override
    @Nullable
    public Object aggregation(@NotNull DynamoDBQuery query, @NotNull Continuation<? super String> $completion) {
        return this.aggregates.aggregation(query, $completion);
    }

    @Override
    @Nullable
    public Object aggregation(@NotNull Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit> builder, @NotNull Continuation<? super String> $completion) {
        return DynamoDBRepository.aggregation$suspendImpl(this, builder, $completion);
    }

    static /* synthetic */ <E extends DynamoDBModel & Model & ETagable> Object aggregation$suspendImpl(DynamoDBRepository<E> $this, Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit> builder, Continuation<? super String> $completion) {
        DynamoDBQuery.DynamoDBQuerybuilder queryBuilder = new DynamoDBQuery.DynamoDBQuerybuilder();
        builder.invoke((Object)queryBuilder);
        DynamoDBQuery queryResult = queryBuilder.build();
        return $this.aggregation(queryResult, $completion);
    }

    @Override
    @Nullable
    public Object doWrite(boolean create2, @NotNull Map<E, ? extends Function3<? super E, ? super E, ? super Continuation<? super Unit>, ? extends Object>> records, @NotNull Continuation<? super List<? extends E>> $completion) {
        return DynamoDBRepository.doWrite$suspendImpl(this, create2, records, $completion);
    }

    static /* synthetic */ <E extends DynamoDBModel & Model & ETagable> Object doWrite$suspendImpl(DynamoDBRepository<E> $this, boolean create2, Map<E, ? extends Function3<? super E, ? super E, ? super Continuation<? super Unit>, ? extends Object>> records, Continuation<? super List<? extends E>> $completion) {
        return DynamoDBCreator.doWrite$default($this.creator, create2, records, null, $completion, 4, null);
    }

    @Override
    @Nullable
    public Object doDelete(@Nullable String hash, @Nullable List<String> ranges, @NotNull Continuation<? super List<? extends E>> $completion) {
        return DynamoDBRepository.doDelete$suspendImpl(this, hash, ranges, $completion);
    }

    static /* synthetic */ <E extends DynamoDBModel & Model & ETagable> Object doDelete$suspendImpl(DynamoDBRepository<E> $this, String hash, List<String> ranges, Continuation<? super List<? extends E>> $completion) {
        List<String> list = ranges;
        return DynamoDBDeleter.doDelete$default($this.deleter, hash, list != null ? CollectionsKt.toSet((Iterable)list) : null, null, $completion, 4, null);
    }

    @Override
    @NotNull
    public Future<E> remoteCreate(@NotNull E record) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Promise promise = Promise.promise();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this.vertx)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, record, promise, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ E $record;
            final /* synthetic */ Promise<E> $promise;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                this.$promise = $promise;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 /* !! */  = $this$launch;
                        var4_5 = this.this$0;
                        var5_6 /* !! */  = this.$record;
                        $this$invokeSuspend_u24lambda_u240 /* !! */  = var3_4 /* !! */ ;
                        $i$a$-runCatching-DynamoDBRepository$remoteCreate$1$1 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240 /* !! */ );
                        this.I$0 = $i$a$-runCatching-DynamoDBRepository$remoteCreate$1$1;
                        this.label = 1;
                        v0 = var4_5.create((Model)var5_6 /* !! */ , (Continuation)this);
                        ** if (v0 != var8_3) goto lbl21
lbl20:
                        // 1 sources

                        return var8_3;
lbl21:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        $i$a$-runCatching-DynamoDBRepository$remoteCreate$1$1 = this.I$0;
                        $this$invokeSuspend_u24lambda_u240 /* !! */  = (CoroutineScope)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl29:
                            // 2 sources

                            $this$invokeSuspend_u24lambda_u240 /* !! */  = Result.constructor-impl((Object)((CreateResult)v0));
                        }
                        catch (Throwable $i$a$-runCatching-DynamoDBRepository$remoteCreate$1$1) {
                            $this$invokeSuspend_u24lambda_u240 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DynamoDBRepository$remoteCreate$1$1));
                        }
                        var3_4 /* !! */  = $this$invokeSuspend_u24lambda_u240 /* !! */ ;
                        var4_5 = this.$promise;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v1 != null) {
                            it /* !! */  = var5_6 /* !! */  = v1;
                            $i$a$-onFailure-DynamoDBRepository$remoteCreate$1$2 = false;
                            var4_5.fail((Throwable)it /* !! */ );
                        }
                        var4_5 = this.$promise;
                        if (Result.isSuccess-impl((Object)var3_4 /* !! */ )) {
                            it = (CreateResult)var3_4 /* !! */ ;
                            $i$a$-onSuccess-DynamoDBRepository$remoteCreate$1$3 = false;
                            var4_5.complete(it.getItem());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future(...)");
        return future;
    }

    @Override
    @NotNull
    public Future<E> remoteRead(@NotNull DynamoDBQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Promise promise = Promise.promise();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this.vertx)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, query, promise, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ DynamoDBQuery $query;
            final /* synthetic */ Promise<E> $promise;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                this.$promise = $promise;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 /* !! */  = $this$launch;
                        var4_5 = this.this$0;
                        var5_6 = this.$query;
                        $this$invokeSuspend_u24lambda_u240 /* !! */  = var3_4 /* !! */ ;
                        $i$a$-runCatching-DynamoDBRepository$remoteRead$1$1 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240 /* !! */ );
                        this.I$0 = $i$a$-runCatching-DynamoDBRepository$remoteRead$1$1;
                        this.label = 1;
                        v0 = var4_5.show((DynamoDBQuery)var5_6, (Continuation<ItemResult<E>>)this);
                        ** if (v0 != var8_3) goto lbl21
lbl20:
                        // 1 sources

                        return var8_3;
lbl21:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        $i$a$-runCatching-DynamoDBRepository$remoteRead$1$1 = this.I$0;
                        $this$invokeSuspend_u24lambda_u240 /* !! */  = (CoroutineScope)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl29:
                            // 2 sources

                            $this$invokeSuspend_u24lambda_u240 /* !! */  = Result.constructor-impl((Object)((ItemResult)v0));
                        }
                        catch (Throwable $i$a$-runCatching-DynamoDBRepository$remoteRead$1$1) {
                            $this$invokeSuspend_u24lambda_u240 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DynamoDBRepository$remoteRead$1$1));
                        }
                        var3_4 /* !! */  = $this$invokeSuspend_u24lambda_u240 /* !! */ ;
                        var4_5 = this.$promise;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v1 != null) {
                            it = var5_6 = v1;
                            $i$a$-onFailure-DynamoDBRepository$remoteRead$1$2 = false;
                            var4_5.fail((Throwable)it);
                        }
                        var4_5 = this.$promise;
                        if (Result.isSuccess-impl((Object)var3_4 /* !! */ )) {
                            it = (ItemResult)var3_4 /* !! */ ;
                            $i$a$-onSuccess-DynamoDBRepository$remoteRead$1$3 = false;
                            var4_5.complete(it.getItem());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future(...)");
        return future;
    }

    @Override
    @NotNull
    public Future<List<E>> remoteIndex(@Nullable DynamoDBQuery query) {
        Promise promise = Promise.promise();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this.vertx)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, query, promise, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ DynamoDBQuery $query;
            final /* synthetic */ Promise<List<E>> $promise;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                this.$promise = $promise;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var11_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 /* !! */  = $this$launch;
                        var4_5 = this.this$0;
                        var5_6 = this.$query;
                        var6_7 = this.$promise;
                        $this$invokeSuspend_u24lambda_u242 /* !! */  = var3_4 /* !! */ ;
                        $i$a$-runCatching-DynamoDBRepository$remoteIndex$1$1 = 0;
                        v0 = var5_6;
                        if (v0 == null) {
                            v0 = DynamoDBQuery.Companion.builder((Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2$lambda$0(com.genghis.tools.repository.utils.DynamoDBQuery$DynamoDBQuerybuilder ), (Lcom/genghis/tools/repository/utils/DynamoDBQuery$DynamoDBQuerybuilder;)Lkotlin/Unit;)());
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = var4_5;
                        this.L$2 = var6_7;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u242 /* !! */ );
                        this.I$0 = $i$a$-runCatching-DynamoDBRepository$remoteIndex$1$1;
                        this.label = 1;
                        v1 = var4_5.index((DynamoDBQuery)v0, (Continuation<ItemListResult<List<E>>>)this);
                        ** if (v1 != var11_3) goto lbl27
lbl26:
                        // 1 sources

                        return var11_3;
lbl27:
                        // 1 sources

                        ** GOTO lbl37
                    }
                    case 1: {
                        $i$a$-runCatching-DynamoDBRepository$remoteIndex$1$1 = this.I$0;
                        $this$invokeSuspend_u24lambda_u242 /* !! */  = (CoroutineScope)this.L$3;
                        var6_7 = (Promise)this.L$2;
                        var4_5 = (Promise<List<E>>)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        result = (ItemListResult)v1;
                        v2 = DynamoDBRepository.access$getVertx$p((DynamoDBRepository)var4_5).executeBlocking((Callable<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2$lambda$1(com.genghis.tools.repository.repository.results.ItemListResult ), ()Ljava/util/List;)((ItemListResult)result));
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"executeBlocking(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = var6_7;
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u242 /* !! */ );
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)result);
                        this.I$0 = $i$a$-runCatching-DynamoDBRepository$remoteIndex$1$1;
                        this.label = 2;
                        v3 = VertxCoroutineKt.coAwait((Future)v2, (Continuation)this);
                        ** if (v3 != var11_3) goto lbl49
lbl48:
                        // 1 sources

                        return var11_3;
lbl49:
                        // 1 sources

                        ** GOTO lbl59
                    }
                    case 2: {
                        $i$a$-runCatching-DynamoDBRepository$remoteIndex$1$1 = this.I$0;
                        result = (ItemListResult)this.L$3;
                        $this$invokeSuspend_u24lambda_u242 /* !! */  = (CoroutineScope)this.L$2;
                        var6_7 = (Promise)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl59:
                            // 2 sources

                            items = (List)v3;
                            $this$invokeSuspend_u24lambda_u242 /* !! */  = Result.constructor-impl((Object)Boxing.boxBoolean((boolean)var6_7.tryComplete((Object)items)));
                        }
                        catch (Throwable var8_11) {
                            $this$invokeSuspend_u24lambda_u242 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_11));
                        }
                        var3_4 /* !! */  = $this$invokeSuspend_u24lambda_u242 /* !! */ ;
                        var4_5 = this.$promise;
                        v4 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v4 != null) {
                            it = var5_6 = v4;
                            $i$a$-onFailure-DynamoDBRepository$remoteIndex$1$2 = false;
                            var4_5.tryFail((Throwable)it);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$2$lambda$0(DynamoDBQuery.DynamoDBQuerybuilder $this$builder) {
                return Unit.INSTANCE;
            }

            private static final List invokeSuspend$lambda$2$lambda$1(ItemListResult $result) {
                return $result.getItemList().getItems();
            }
        }), (int)2, null);
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future(...)");
        return future;
    }

    @Override
    @NotNull
    public Future<E> remoteUpdate(@NotNull E record) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Promise promise = Promise.promise();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this.vertx)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, record, promise, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ E $record;
            final /* synthetic */ Promise<E> $promise;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                this.$promise = $promise;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 /* !! */  = $this$launch;
                        var4_6 = this.this$0;
                        var5_7 /* !! */  = this.$record;
                        $this$invokeSuspend_u24lambda_u242 /* !! */  = var3_4 /* !! */ ;
                        $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$1 = 0;
                        this.L$0 = $this$launch;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u242 /* !! */ );
                        this.I$0 = $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$1;
                        this.label = 1;
                        v0 = var4_6.show(DynamoDBQuery.Companion.builder((Function1<? super DynamoDBQuery.DynamoDBQuerybuilder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2$lambda$1(com.genghis.tools.repository.models.DynamoDBModel com.genghis.tools.repository.dynamodb.DynamoDBRepository com.genghis.tools.repository.utils.DynamoDBQuery$DynamoDBQuerybuilder ), (Lcom/genghis/tools/repository/utils/DynamoDBQuery$DynamoDBQuerybuilder;)Lkotlin/Unit;)(var5_7 /* !! */ , var4_6)), (Continuation<ItemResult<E>>)this);
                        ** if (v0 != var13_3) goto lbl21
lbl20:
                        // 1 sources

                        return var13_3;
lbl21:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$1 = this.I$0;
                        $this$invokeSuspend_u24lambda_u242 /* !! */  = (CoroutineScope)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl30:
                            // 2 sources

                            $this$invokeSuspend_u24lambda_u242 /* !! */  = Result.constructor-impl((Object)((ItemResult)v0));
                        }
                        catch (Throwable $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$1) {
                            $this$invokeSuspend_u24lambda_u242 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$1));
                        }
                        var3_4 /* !! */  = $this$invokeSuspend_u24lambda_u242 /* !! */ ;
                        var4_6 = this.$promise;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v1 != null) {
                            it /* !! */  = var5_7 /* !! */  = v1;
                            $i$a$-onFailure-DynamoDBRepository$remoteUpdate$1$2 = false;
                            var4_6.tryFail((Throwable)it /* !! */ );
                        }
                        var4_6 = this.this$0;
                        var5_7 /* !! */  = this.$record;
                        var6_8 = this.$promise;
                        if (!Result.isSuccess-impl((Object)var3_4 /* !! */ )) ** GOTO lbl100
                        it = (ItemResult)var3_4 /* !! */ ;
                        $i$a$-onSuccess-DynamoDBRepository$remoteUpdate$1$3 = 0;
                        var9_15 /* !! */  = $this$launch;
                        $this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */  = var9_15 /* !! */ ;
                        $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$3$1 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = var3_4 /* !! */ ;
                        this.L$2 = var6_8;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */ );
                        this.I$0 = $i$a$-onSuccess-DynamoDBRepository$remoteUpdate$1$3;
                        this.I$1 = $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$3$1;
                        this.label = 2;
                        v2 = Repository.update$default(var4_6, (Model)var5_7 /* !! */ , null, (Continuation)this, 2, null);
                        ** if (v2 != var13_3) goto lbl67
lbl66:
                        // 1 sources

                        return var13_3;
lbl67:
                        // 1 sources

                        ** GOTO lbl79
                    }
                    case 2: {
                        $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$3$1 = this.I$1;
                        $i$a$-onSuccess-DynamoDBRepository$remoteUpdate$1$3 = this.I$0;
                        $this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */  = (CoroutineScope)this.L$4;
                        it = (ItemResult)this.L$3;
                        var6_8 = (Promise<E>)this.L$2;
                        var3_5 = this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl79:
                            // 2 sources

                            $this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */  = Result.constructor-impl((Object)((UpdateResult)v2));
                        }
                        catch (Throwable $i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$3$1) {
                            $this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DynamoDBRepository$remoteUpdate$1$3$1));
                        }
                        var9_15 /* !! */  = $this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */ ;
                        v3 = Result.exceptionOrNull-impl((Object)var9_15 /* !! */ );
                        if (v3 != null) {
                            it /* !! */  = $this$invokeSuspend_u24lambda_u247_u24lambda_u244 /* !! */  = v3;
                            $i$a$-onFailure-DynamoDBRepository$remoteUpdate$1$3$2 = false;
                            var6_8.tryFail((Throwable)it /* !! */ );
                        }
                        if (Result.isSuccess-impl((Object)var9_15 /* !! */ )) {
                            it = (UpdateResult)var9_15 /* !! */ ;
                            $i$a$-onSuccess-DynamoDBRepository$remoteUpdate$1$3$3 = false;
                            var6_8.complete(it.getItem());
                        }
lbl100:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$2$lambda$1$lambda$0(DynamoDBModel $record, DynamoDBRepository this$0, HashAndRange.HashAndRangeBuilder $this$hashAndRange) {
                $this$hashAndRange.setHash(DynamoDBRepositoryKt.hash($record, this$0.getHashField()));
                $this$hashAndRange.setRange(DynamoDBRepositoryKt.range($record, this$0.getIdentifierField()));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$2$lambda$1(DynamoDBModel $record, DynamoDBRepository this$0, DynamoDBQuery.DynamoDBQuerybuilder $this$builder) {
                $this$builder.hashAndRange((Function1<? super HashAndRange.HashAndRangeBuilder, Unit>)((Function1)arg_0 -> remoteUpdate.1.invokeSuspend$lambda$2$lambda$1$lambda$0($record, this$0, arg_0)));
                return Unit.INSTANCE;
            }
        }), (int)2, null);
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future(...)");
        return future;
    }

    @Override
    @NotNull
    public Future<E> remoteDelete(@NotNull HashAndRange hashAndRange) {
        Intrinsics.checkNotNullParameter((Object)hashAndRange, (String)"hashAndRange");
        Promise promise = Promise.promise();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this.vertx)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hashAndRange, promise, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DynamoDBRepository<E> this$0;
            final /* synthetic */ HashAndRange $hashAndRange;
            final /* synthetic */ Promise<E> $promise;
            {
                this.this$0 = $receiver;
                this.$hashAndRange = $hashAndRange;
                this.$promise = $promise;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var8_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 /* !! */  = $this$launch;
                        var4_5 = this.this$0;
                        var5_6 = this.$hashAndRange;
                        $this$invokeSuspend_u24lambda_u240 /* !! */  = var3_4 /* !! */ ;
                        $i$a$-runCatching-DynamoDBRepository$remoteDelete$1$1 = 0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240 /* !! */ );
                        this.I$0 = $i$a$-runCatching-DynamoDBRepository$remoteDelete$1$1;
                        this.label = 1;
                        v0 = var4_5.delete((HashAndRange)var5_6, (Continuation<DeleteResult<E>>)this);
                        ** if (v0 != var8_3) goto lbl21
lbl20:
                        // 1 sources

                        return var8_3;
lbl21:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        $i$a$-runCatching-DynamoDBRepository$remoteDelete$1$1 = this.I$0;
                        $this$invokeSuspend_u24lambda_u240 /* !! */  = (CoroutineScope)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl29:
                            // 2 sources

                            $this$invokeSuspend_u24lambda_u240 /* !! */  = Result.constructor-impl((Object)((DeleteResult)v0));
                        }
                        catch (Throwable $i$a$-runCatching-DynamoDBRepository$remoteDelete$1$1) {
                            $this$invokeSuspend_u24lambda_u240 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DynamoDBRepository$remoteDelete$1$1));
                        }
                        var3_4 /* !! */  = $this$invokeSuspend_u24lambda_u240 /* !! */ ;
                        var4_5 = this.$promise;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v1 != null) {
                            it = var5_6 = v1;
                            $i$a$-onFailure-DynamoDBRepository$remoteDelete$1$2 = false;
                            var4_5.fail((Throwable)it);
                        }
                        var4_5 = this.$promise;
                        if (Result.isSuccess-impl((Object)var3_4 /* !! */ )) {
                            it = (DeleteResult)var3_4 /* !! */ ;
                            $i$a$-onSuccess-DynamoDBRepository$remoteDelete$1$3 = false;
                            var4_5.complete(it.getItem());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Future future = promise.future();
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"future(...)");
        return future;
    }

    @NotNull
    public final String[] buildEventbusProjections(@Nullable JsonArray projectionArray) {
        List projections;
        if (projectionArray == null) {
            return new String[0];
        }
        List list = projections = projectionArray.stream().map(DynamoDBRepository::buildEventbusProjections$lambda$68).collect(Collectors.toList());
        Object[] projectionArrayStrings = new String[list != null ? list.size() : 0];
        if (projections != null) {
            IntStream.range(0, projections.size()).forEach(arg_0 -> DynamoDBRepository.buildEventbusProjections$lambda$69((String[])projectionArrayStrings, projections, arg_0));
        }
        return (String[])ArraysKt.requireNoNulls((Object[])projectionArrayStrings);
    }

    public final boolean hasRangeKey() {
        return this.hasRangeKey;
    }

    @Override
    @Nullable
    public Object create(@NotNull E record, @NotNull Continuation<? super CreateResult<? extends E>> $completion) {
        return Repository.super.create((Model)record, $completion);
    }

    @Override
    @Nullable
    public Object batchCreate(@NotNull List<? extends E> records, @NotNull Continuation<? super List<? extends CreateResult<? extends E>>> $completion) {
        return Repository.super.batchCreate(records, $completion);
    }

    @Override
    @Nullable
    public Object update(@NotNull E record, @Nullable Function3<? super E, ? super E, ? super Continuation<? super Unit>, ? extends Object> updateLogic, @NotNull Continuation<? super UpdateResult<? extends E>> $completion) {
        return Repository.super.update((Model)record, updateLogic, $completion);
    }

    @Override
    @Nullable
    public Object batchUpdate(@NotNull Map<E, ? extends Function3<? super E, ? super E, ? super Continuation<? super Unit>, ? extends Object>> records, @NotNull Continuation<? super List<? extends UpdateResult<? extends E>>> $completion) {
        return Repository.super.batchUpdate(records, $completion);
    }

    @Override
    @Nullable
    public Object delete(@NotNull HashAndRange hashAndRange, @NotNull Continuation<? super DeleteResult<? extends E>> $completion) {
        return Repository.super.delete(hashAndRange, $completion);
    }

    @Override
    @Nullable
    public Object batchDelete(@Nullable String hash, @Nullable List<String> ranges, @NotNull Continuation<? super List<? extends DeleteResult<? extends E>>> $completion) {
        return Repository.super.batchDelete(hash, ranges, $completion);
    }

    @Override
    @Nullable
    public Object batchRead(@NotNull List<DynamoDBQuery> queries, @NotNull Continuation<? super List<? extends ItemResult<? extends E>>> $completion) {
        return Repository.super.batchRead(queries, $completion);
    }

    @Override
    @NotNull
    public Either<FilterParameter, JsonObject> parseParam(@NotNull String paramJsonString, @NotNull String key) {
        return Repository.super.parseParam(paramJsonString, key);
    }

    @Override
    public boolean hasField(@NotNull Field[] fields, @NotNull String key) {
        return Repository.super.hasField(fields, key);
    }

    @Override
    @NotNull
    public String buildCollectionEtag(@NotNull List<String> etags) {
        return Repository.super.buildCollectionEtag(etags);
    }

    @Override
    public double extractValueAsDouble(@NotNull Field field, @NotNull E r) {
        return Repository.super.extractValueAsDouble(field, (Model)r);
    }

    @JvmOverloads
    @NotNull
    public final AttributeValue createAttributeValue(@Nullable String fieldName, @NotNull String valueAsString) {
        Intrinsics.checkNotNullParameter((Object)valueAsString, (String)"valueAsString");
        return DynamoDBRepository.createAttributeValue$default(this, fieldName, valueAsString, null, 4, null);
    }

    private static final String modelName_delegate$lambda$0(DynamoDBRepository this$0) {
        return this$0.getType().getSimpleName();
    }

    private static final boolean lambda$4$lambda$2(Annotation a) {
        return a instanceof DynamoDbVersionAttribute;
    }

    private static final boolean lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$4(Method m) {
        return Arrays.stream(m.getDeclaredAnnotations()).anyMatch(arg_0 -> DynamoDBRepository.lambda$4$lambda$3(DynamoDBRepository::lambda$4$lambda$2, arg_0));
    }

    private static final boolean _init_$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void setMapper$lambda$6(ClientOverrideConfiguration.Builder it) {
        it.retryStrategy(AwsRetryStrategy.defaultRetryStrategy().toBuilder().retryOnExceptionOrCause(VertxException.class).retryOnExceptionOrCause(HttpClosedException.class).retryOnExceptionOrCause(ConnectTimeoutException.class).retryOnExceptionOrCauseInstanceOf(VertxException.class).retryOnExceptionOrCauseInstanceOf(HttpClosedException.class).retryOnExceptionOrCauseInstanceOf(ConnectTimeoutException.class).build());
    }

    private static final boolean setHashAndRange$lambda$9$lambda$7(Annotation annotation) {
        return annotation instanceof DynamoDbPartitionKey;
    }

    private static final boolean setHashAndRange$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean setHashAndRange$lambda$9(Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$9$lambda$8(DynamoDBRepository::setHashAndRange$lambda$9$lambda$7, arg_0));
    }

    private static final boolean setHashAndRange$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit setHashAndRange$lambda$12(DynamoDBRepository this$0, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        DynamoDBRepository $this$setHashAndRange_u24lambda_u2412_u24lambda_u2411 = this$0;
        boolean bl = false;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$setHashAndRange_u24lambda_u2412_u24lambda_u2411.hashIdentifier = Companion.stripGet(string);
        $this$setHashAndRange_u24lambda_u2412_u24lambda_u2411.hashField = method;
        return Unit.INSTANCE;
    }

    private static final void setHashAndRange$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean setHashAndRange$lambda$16$lambda$14(Annotation annotation) {
        return annotation instanceof DynamoDbSortKey;
    }

    private static final boolean setHashAndRange$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean setHashAndRange$lambda$16(Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$16$lambda$15(DynamoDBRepository::setHashAndRange$lambda$16$lambda$14, arg_0));
    }

    private static final boolean setHashAndRange$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit setHashAndRange$lambda$19(DynamoDBRepository this$0, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        DynamoDBRepository $this$setHashAndRange_u24lambda_u2419_u24lambda_u2418 = this$0;
        boolean bl = false;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$setHashAndRange_u24lambda_u2419_u24lambda_u2418.identifier = Companion.stripGet(string);
        $this$setHashAndRange_u24lambda_u2419_u24lambda_u2418.identifierField = method;
        return Unit.INSTANCE;
    }

    private static final void setHashAndRange$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean setHashAndRange$lambda$24$lambda$22(Annotation annotation) {
        if (!(annotation instanceof DynamoDbSecondarySortKey)) return false;
        String[] $this$any$iv = ((DynamoDbSecondarySortKey)annotation).indexNames();
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (StringsKt.equals((String)it, (String)PAGINATION_INDEX, (boolean)true)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean setHashAndRange$lambda$24$lambda$23(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean setHashAndRange$lambda$24(Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(arg_0 -> DynamoDBRepository.setHashAndRange$lambda$24$lambda$23(DynamoDBRepository::setHashAndRange$lambda$24$lambda$22, arg_0));
    }

    private static final boolean setHashAndRange$lambda$25(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit setHashAndRange$lambda$27(DynamoDBRepository this$0, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        DynamoDBRepository $this$setHashAndRange_u24lambda_u2427_u24lambda_u2426 = this$0;
        boolean bl = false;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$setHashAndRange_u24lambda_u2427_u24lambda_u2426.paginationIdentifier = Companion.stripGet(string);
        $this$setHashAndRange_u24lambda_u2427_u24lambda_u2426.paginationField = method;
        return Unit.INSTANCE;
    }

    private static final void setHashAndRange$lambda$28(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object getField$lambda$29(String $fieldName, Class $klazz) {
        return "Cannot get field " + $fieldName + " from " + $klazz.getSimpleName() + "!";
    }

    private static final Object getField$lambda$30(String $fieldName, Class $klazz) {
        return "Cannot get field " + $fieldName + " from " + $klazz.getSimpleName() + "!";
    }

    private static final Object getFieldAsObject$lambda$31(String $fieldName, Object $object) {
        return "Cannot get field " + $fieldName + " from " + $object.getClass().getSimpleName() + "!";
    }

    private static final Object getFieldAsObject$lambda$32(String $fieldName, Class $klazz) {
        return "Cannot get field " + $fieldName + " from " + $klazz.getSimpleName() + "!";
    }

    private static final Object getFieldAsString$lambda$33(String $fieldName, Object $object) {
        return "Getting " + $fieldName + " from " + $object.getClass().getSimpleName();
    }

    private static final Object getFieldAsString$lambda$34(String $fieldName, Object $object) {
        return "Cannot get " + $fieldName + " as string from: " + Json.encodePrettily((Object)$object);
    }

    private static final Object getFieldAsString$lambda$35(String $fieldName, Class $klazz) {
        return "Getting " + $fieldName + " from " + $klazz.getSimpleName();
    }

    private static final Object getFieldAsString$lambda$36(String $fieldName, Object $object) {
        return "Cannot get " + $fieldName + " as string from: " + Json.encodePrettily((Object)$object) + ", klazzwise!";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getAlternativeIndexIdentifier$lambda$40$lambda$38(String $indexName, Annotation annotation) {
        if (!(annotation instanceof DynamoDbSecondarySortKey)) return false;
        String[] $this$any$iv = ((DynamoDbSecondarySortKey)annotation).indexNames();
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (StringsKt.equals((String)it, (String)$indexName, (boolean)true)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean getAlternativeIndexIdentifier$lambda$40$lambda$39(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getAlternativeIndexIdentifier$lambda$40(String $indexName, Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifier$lambda$40$lambda$39(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifier$lambda$40$lambda$38($indexName, arg_0), arg_0));
    }

    private static final boolean getAlternativeIndexIdentifier$lambda$41(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit getAlternativeIndexIdentifier$lambda$42(String[] $identifier, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $identifier[0] = Companion.stripGet(string);
        return Unit.INSTANCE;
    }

    private static final void getAlternativeIndexIdentifier$lambda$43(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getAlternativeIndexIdentifierReturnType$lambda$47$lambda$45(String $indexName, Annotation annotation) {
        if (!(annotation instanceof DynamoDbSecondarySortKey)) return false;
        String[] $this$any$iv = ((DynamoDbSecondarySortKey)annotation).indexNames();
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (StringsKt.equals((String)it, (String)$indexName, (boolean)true)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean getAlternativeIndexIdentifierReturnType$lambda$47$lambda$46(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getAlternativeIndexIdentifierReturnType$lambda$47(String $indexName, Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifierReturnType$lambda$47$lambda$46(arg_0 -> DynamoDBRepository.getAlternativeIndexIdentifierReturnType$lambda$47$lambda$45($indexName, arg_0), arg_0));
    }

    private static final boolean getAlternativeIndexIdentifierReturnType$lambda$48(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit getAlternativeIndexIdentifierReturnType$lambda$49(Class[] $identifier, Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        $identifier[0] = method.getReturnType();
        return Unit.INSTANCE;
    }

    private static final void getAlternativeIndexIdentifierReturnType$lambda$50(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object createAttributeValue$lambda$51() {
        return "Cannot recreate attribute!";
    }

    private static final Object createAttributeValue$lambda$52() {
        return "Cannot receate attribute!";
    }

    private static final Object createAttributeValue$lambda$53(String $valueAsString) {
        return "Date received: " + $valueAsString;
    }

    private static final Object createAttributeValue$lambda$54(SimpleDateFormat $df2, Calendar $calendar) {
        return "DATE IS: " + $df2.format($calendar.getTime());
    }

    private static final Object fetchNewestRecord$lambda$55(DynamoDBRepository this$0) {
        return "Loading newest with " + (this$0.hasRangeKey() ? "range" : "hash") + "!";
    }

    private static final void fetchNewestRecord$lambda$56(String $hash, DynamoDBRepository this$0, String $range, Key.Builder it) {
        it.partitionValue($hash);
        if (this$0.hasRangeKey()) {
            it.sortValue($range);
        }
    }

    private static final Unit fetchNewestRecord$lambda$57(Promise $fetchFuture, DynamoDBModel t, Throwable u) {
        if (u == null) {
            $fetchFuture.complete((Object)t);
        } else {
            $fetchFuture.fail(u);
        }
        return Unit.INSTANCE;
    }

    private static final void fetchNewestRecord$lambda$58(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Object fetchNewestRecord$lambda$65$lambda$59() {
        return "Loading newest by hash query!";
    }

    private static final void fetchNewestRecord$lambda$65$lambda$60(String $hash, Key.Builder it) {
        it.partitionValue($hash);
    }

    private static final Object fetchNewestRecord$lambda$65$lambda$61(long $timeBefore) {
        return "Results received in: " + (System.currentTimeMillis() - $timeBefore) + " ms";
    }

    private static final void fetchNewestRecord$lambda$65$lambda$62(List $result, DynamoDBModel it) {
        Intrinsics.checkNotNull((Object)it);
        $result.add(it);
    }

    private static final Unit fetchNewestRecord$lambda$65$lambda$63(Promise $fetchFuture, List $result, Void void_, Throwable u) {
        if (u == null) {
            $fetchFuture.complete(!((Collection)$result).isEmpty() ? (DynamoDBModel)CollectionsKt.first((List)$result) : null);
        } else {
            $fetchFuture.fail(u);
        }
        return Unit.INSTANCE;
    }

    private static final void fetchNewestRecord$lambda$65$lambda$64(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Object fetchNewestRecord$lambda$67$lambda$66() {
        return "Error fetching newest!";
    }

    private static final String buildEventbusProjections$lambda$68(Object it) {
        return it.toString();
    }

    private static final void buildEventbusProjections$lambda$69(String[] $projectionArrayStrings, List $projections, int i) {
        $projectionArrayStrings[i] = $projections.get(i);
    }

    public static final /* synthetic */ DynamoDBUpdater access$getUpdater$p(DynamoDBRepository $this) {
        return $this.updater;
    }

    public static final /* synthetic */ Vertx access$getVertx$p(DynamoDBRepository $this) {
        return $this.vertx;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0016\b\u0001\u0010\b\u0018\u0001*\u00020\t*\u00020\n*\u00020\u000b*\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u00122\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0014H\u0086\bJ\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0016\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J(\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u0018\"\u0004\b\u0001\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002J\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005JD\u0010#\u001a\u00020$2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u00182\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'J\b\u0010*\u001a\u00020$H\u0002J*\u0010+\u001a\b\u0012\u0004\u0012\u00020)0,2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J \u0010-\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050.2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JL\u0010+\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0010\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b022\u0006\u00103\u001a\u00020\u00052\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u0001052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020)0,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/genghis/tools/repository/dynamodb/DynamoDBRepository$Companion;", "", "<init>", "()V", "PAGINATION_INDEX", "", "create", "Lcom/genghis/tools/repository/dynamodb/DynamoDBRepository;", "T", "Lcom/genghis/tools/repository/models/DynamoDBModel;", "Lcom/genghis/tools/repository/models/Model;", "Lcom/genghis/tools/repository/models/Cacheable;", "Lcom/genghis/tools/repository/models/ETagable;", "vertx", "Lio/vertx/core/Vertx;", "appConfig", "Lio/vertx/core/json/JsonObject;", "cacheManager", "Lcom/genghis/tools/repository/repository/cache/CacheManager;", "eTagManager", "Lcom/genghis/tools/repository/repository/etag/ETagManager;", "fetchEndPoint", "fetchRegion", "setGsiKeys", "", "E", "type", "Ljava/lang/Class;", "getAllMethodsOnType", "", "Ljava/lang/reflect/Method;", "klazz", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", "stripGet", "string", "initializeDynamoDb", "", "collectionMap", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Ljava/lang/Void;", "silenceDynamoDBLoggers", "initialize", "Lio/vertx/core/Promise;", "iam", "Lkotlin/Pair;", "client", "Lsoftware/amazon/awssdk/services/dynamodb/DynamoDbAsyncClient;", "mapper", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbAsyncTable;", "tableName", "gsi", "Lio/vertx/core/json/JsonArray;", "lsi", "genghis-tools-repository"})
    @SourceDebugExtension(value={"SMAP\nDynamoDBRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoDBRepository.kt\ncom/genghis/tools/repository/dynamodb/DynamoDBRepository$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1449:1\n216#2,2:1450\n1563#3:1452\n1634#3,3:1453\n1563#3:1458\n1634#3,3:1459\n1563#3:1462\n1634#3,3:1463\n1310#4,2:1456\n*S KotlinDebug\n*F\n+ 1 DynamoDBRepository.kt\ncom/genghis/tools/repository/dynamodb/DynamoDBRepository$Companion\n*L\n1303#1:1450,2\n1305#1:1452\n1305#1:1453,3\n1397#1:1458\n1397#1:1459,3\n1408#1:1462\n1408#1:1463,3\n1247#1:1456,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T extends DynamoDBModel & Model & ETagable> DynamoDBRepository<T> create(Vertx vertx, JsonObject appConfig, CacheManager<T> cacheManager, ETagManager<T> eTagManager) {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
            boolean $i$f$create = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return new DynamoDBRepository<DynamoDBModel>(vertx, DynamoDBModel.class, appConfig, cacheManager, eTagManager);
        }

        public static /* synthetic */ DynamoDBRepository create$default(Companion $this, Vertx vertx, JsonObject appConfig, CacheManager cacheManager, ETagManager eTagManager, int n, Object object) {
            if ((n & 1) != 0) {
                Vertx vertx2 = Vertx.currentContext().owner();
                Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"owner(...)");
                vertx = vertx2;
            }
            if ((n & 4) != 0) {
                cacheManager = null;
            }
            if ((n & 8) != 0) {
                eTagManager = null;
            }
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
            boolean $i$f$create = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return new DynamoDBRepository<DynamoDBModel>(vertx, DynamoDBModel.class, appConfig, cacheManager, eTagManager);
        }

        private final String fetchEndPoint(JsonObject appConfig) {
            String string;
            Object object = appConfig;
            if (object == null) {
                object = Vertx.currentContext() == null ? null : Vertx.currentContext().config();
            }
            JsonObject config = object;
            if (config == null) {
                string = "http://localhost:8001";
            } else {
                String string2 = config.getString("dynamo_endpoint");
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            }
            String endPoint = string;
            return endPoint;
        }

        private final String fetchRegion(JsonObject appConfig) {
            Object object = appConfig;
            if (object == null) {
                object = Vertx.currentContext() == null ? null : Vertx.currentContext().config();
            }
            JsonObject config = object;
            String region = null;
            if (config == null) {
                region = "eu-west-1";
            } else {
                region = config.getString("dynamo_signing_region");
                if (region == null) {
                    region = "eu-west-1";
                }
            }
            return region;
        }

        private final <E> Map<String, JsonObject> setGsiKeys(Class<E> type) {
            Method[] allMethods = this.getAllMethodsOnType(type);
            ConcurrentHashMap gsiMap = new ConcurrentHashMap();
            Arrays.stream(allMethods).forEach(arg_0 -> Companion.setGsiKeys$lambda$10(arg_0 -> Companion.setGsiKeys$lambda$9(allMethods, gsiMap, arg_0), arg_0));
            return gsiMap;
        }

        private final Method[] getAllMethodsOnType(Class<?> klazz) {
            Object[] objectArray;
            Object[] methods = klazz.getDeclaredMethods();
            if (klazz.getSuperclass() != null && !Intrinsics.areEqual(klazz.getSuperclass(), Object.class)) {
                Class<?> clazz = klazz.getSuperclass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
                Method[] methodArray = this.getAllMethodsOnType(clazz);
                Object[] objectArray2 = ArrayUtils.addAll((Object[])methods, (Object[])Arrays.copyOf(methodArray, methodArray.length));
                Intrinsics.checkNotNull((Object)objectArray2);
                objectArray = (Method[])objectArray2;
            } else {
                Object[] objectArray3 = methods;
                Intrinsics.checkNotNull((Object)objectArray3);
                objectArray = objectArray3;
            }
            return objectArray;
        }

        @NotNull
        public final String stripGet(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String newString = StringsKt.replace$default((String)string, (String)"get", (String)"", (boolean)false, (int)4, null);
            char[] cArray = newString.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] c = cArray;
            c[0] = (char)(c[0] + 32);
            return new String(c);
        }

        /*
         * WARNING - void declaration
         */
        public final void initializeDynamoDb(@NotNull Vertx vertx, @NotNull JsonObject appConfig, @NotNull Map<String, ? extends Class<?>> collectionMap, @NotNull Handler<AsyncResult<Void>> resultHandler) {
            Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
            Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
            Intrinsics.checkNotNullParameter(collectionMap, (String)"collectionMap");
            Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
            if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                DynamoDBRepositoryKt.access$getLogger$p().debug(Companion::initializeDynamoDb$lambda$11);
            }
            try {
                void $this$mapTo$iv$iv;
                this.silenceDynamoDBLoggers();
                ArrayList<Promise<Void>> futures = new ArrayList<Promise<Void>>();
                Map<String, Class<?>> $this$forEach$iv = collectionMap;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<String, Class<?>> element$iv;
                    Map.Entry<String, Class<?>> entry = element$iv = object.next();
                    boolean bl = false;
                    Class<?> v = entry.getValue();
                    futures.add(Companion.initialize(vertx, appConfig, v));
                }
                Iterable $this$map$iv = futures;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Promise promise = (Promise)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.future());
                }
                Future.all((List)((List)destination$iv$iv)).andThen(arg_0 -> Companion.initializeDynamoDb$lambda$15(resultHandler, arg_0));
            }
            catch (Exception e) {
                DynamoDBRepositoryKt.access$getLogger$p().error((Throwable)e, Companion::initializeDynamoDb$lambda$16);
            }
        }

        public static /* synthetic */ void initializeDynamoDb$default(Companion companion, Vertx vertx, JsonObject jsonObject, Map map, Handler handler, int n, Object object) {
            if ((n & 1) != 0) {
                Vertx vertx2 = Vertx.currentContext().owner();
                Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"owner(...)");
                vertx = vertx2;
            }
            companion.initializeDynamoDb(vertx, jsonObject, map, (Handler<AsyncResult<Void>>)handler);
        }

        private final void silenceDynamoDBLoggers() {
            Logger.getLogger("com.amazonaws").setLevel(Level.WARNING);
        }

        private final Promise<Void> initialize(Vertx vertx, JsonObject appConfig, Class<?> type) {
            DynamoDbAsyncClient dynamoDbAsyncClient;
            Object object;
            Promise future;
            block6: {
                block5: {
                    future = Promise.promise();
                    object = appConfig.getString("table-suffix");
                    if (object == null) break block5;
                    String it = object;
                    boolean bl = false;
                    String string = "-" + it;
                    object = string;
                    if (string != null) break block6;
                }
                object = "";
            }
            String tableSuffix = object;
            String tableName = appConfig.getString("table") + tableSuffix;
            Pair<String, String> pair = this.iam(appConfig);
            String dynamoDBId = (String)pair.component1();
            String dynamoDBKey = (String)pair.component2();
            String endPoint = this.fetchEndPoint(appConfig);
            String region = this.fetchRegion(appConfig);
            AwsAsyncClientBuilder awsAsyncClientBuilder = (AwsAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)region))).endpointOverride(URI.create(endPoint));
            Context context = vertx.getOrCreateContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getOrCreateContext(...)");
            AwsAsyncClientBuilder awsAsyncClientBuilder2 = VertxSdkClient.Companion.withVertx(awsAsyncClientBuilder, context);
            Intrinsics.checkNotNull((Object)awsAsyncClientBuilder2);
            DynamoDbAsyncClientBuilder dynamo = (DynamoDbAsyncClientBuilder)awsAsyncClientBuilder2;
            if (dynamoDBId != null && dynamoDBKey != null) {
                AwsBasicCredentials creds = AwsBasicCredentials.create((String)dynamoDBId, (String)dynamoDBKey);
                StaticCredentialsProvider statCreds = StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)creds));
                dynamoDbAsyncClient = (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)dynamo.credentialsProvider((AwsCredentialsProvider)statCreds)).build();
            } else {
                dynamoDbAsyncClient = (DynamoDbAsyncClient)dynamo.build();
            }
            DynamoDbAsyncClient client = dynamoDbAsyncClient;
            DynamoDbEnhancedAsyncClient dynamoDbMapper = DynamoDbEnhancedAsyncClient.builder().dynamoDbClient(client).build();
            Intrinsics.checkNotNull((Object)client);
            DynamoDbAsyncTable dynamoDbAsyncTable = dynamoDbMapper.table(tableName, (TableSchema)TableSchema.fromBean(type));
            Intrinsics.checkNotNull((Object)dynamoDbAsyncTable, (String)"null cannot be cast to non-null type software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable<java.lang.Class<*>>");
            JsonArray jsonArray = appConfig.getJsonArray("GSI");
            JsonArray jsonArray2 = appConfig.getJsonArray("LSI");
            Intrinsics.checkNotNull((Object)future);
            this.initialize(client, dynamoDbAsyncTable, tableName, jsonArray, jsonArray2, (Promise<Void>)future);
            return future;
        }

        private final Pair<String, String> iam(JsonObject appConfig) {
            String dynamoDBId = appConfig.getString("dynamo_db_iam_id");
            String dynamoDBKey = appConfig.getString("dynamo_db_iam_key");
            return new Pair((Object)dynamoDBId, (Object)dynamoDBKey);
        }

        private final void initialize(DynamoDbAsyncClient client, DynamoDbAsyncTable<Class<?>> mapper, String tableName, JsonArray gsi, JsonArray lsi, Promise<Void> resultHandler) {
            mapper.createTable(arg_0 -> Companion.initialize$lambda$26(gsi, lsi, arg_0)).whenComplete((arg_0, arg_1) -> Companion.initialize$lambda$33((arg_0, arg_1) -> Companion.initialize$lambda$32(client, resultHandler, tableName, arg_0, arg_1), arg_0, arg_1));
        }

        private static final boolean setGsiKeys$lambda$9$lambda$0(Annotation annotation) {
            return annotation instanceof DynamoDbSecondaryPartitionKey;
        }

        private static final boolean setGsiKeys$lambda$9$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean setGsiKeys$lambda$9$lambda$6$lambda$2(Annotation annotation) {
            return annotation instanceof DynamoDbSecondarySortKey;
        }

        private static final boolean setGsiKeys$lambda$9$lambda$6$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit setGsiKeys$lambda$9$lambda$6(String $hashName, String[] $range, Method rangeMethod) {
            block3: {
                Object var3_11;
                block2: {
                    Object v0;
                    void $this$firstOrNull$iv;
                    if (!Arrays.stream(rangeMethod.getDeclaredAnnotations()).anyMatch(arg_0 -> Companion.setGsiKeys$lambda$9$lambda$6$lambda$3(Companion::setGsiKeys$lambda$9$lambda$6$lambda$2, arg_0))) break block3;
                    String[] stringArray = rangeMethod.getDeclaredAnnotation(DynamoDbSecondarySortKey.class).indexNames();
                    boolean $i$f$firstOrNull = false;
                    int n = ((void)$this$firstOrNull$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)$hashName)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = var3_11 = null;
                }
                if (var3_11 != null) {
                    Object it = var3_11;
                    boolean bl = false;
                    String string = rangeMethod.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    $range[0] = Companion.stripGet(string);
                }
            }
            return Unit.INSTANCE;
        }

        private static final void setGsiKeys$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object setGsiKeys$lambda$9$lambda$8(String $hashName, JsonObject $hashKeyObject) {
            return "Detected GSI: " + $hashName + " : " + $hashKeyObject.encodePrettily();
        }

        private static final Unit setGsiKeys$lambda$9(Method[] $allMethods, ConcurrentHashMap $gsiMap, Method method) {
            if (Arrays.stream(method.getDeclaredAnnotations()).anyMatch(arg_0 -> Companion.setGsiKeys$lambda$9$lambda$1(Companion::setGsiKeys$lambda$9$lambda$0, arg_0))) {
                String hashName = (String)ArraysKt.first((Object[])method.getDeclaredAnnotation(DynamoDbSecondaryPartitionKey.class).indexNames());
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String hash = Companion.stripGet(string);
                String[] range = new String[1];
                if (!Intrinsics.areEqual((Object)hashName, (Object)"")) {
                    Arrays.stream($allMethods).forEach(arg_0 -> Companion.setGsiKeys$lambda$9$lambda$7(arg_0 -> Companion.setGsiKeys$lambda$9$lambda$6(hashName, range, arg_0), arg_0));
                    JsonObject hashKeyObject = new JsonObject().put("hash", (Object)hash);
                    if (range[0] != null) {
                        hashKeyObject.put("range", (Object)range[0]);
                    }
                    ((Map)$gsiMap).put(hashName, hashKeyObject);
                    DynamoDBRepositoryKt.access$getLogger$p().debug(() -> Companion.setGsiKeys$lambda$9$lambda$8(hashName, hashKeyObject));
                }
            }
            return Unit.INSTANCE;
        }

        private static final void setGsiKeys$lambda$10(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object initializeDynamoDb$lambda$11() {
            return "Initializing DynamoDB";
        }

        private static final Object initializeDynamoDb$lambda$15$lambda$14() {
            return "DynamoDB Ready";
        }

        private static final void initializeDynamoDb$lambda$15(Handler $resultHandler, AsyncResult res) {
            if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                DynamoDBRepositoryKt.access$getLogger$p().debug(Companion::initializeDynamoDb$lambda$15$lambda$14);
            }
            if (res.failed()) {
                $resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                $resultHandler.handle((Object)Future.succeededFuture());
            }
        }

        private static final Object initializeDynamoDb$lambda$16() {
            return "Unable to initialize!";
        }

        private static final void initialize$lambda$26$lambda$21$lambda$20$lambda$19(Projection.Builder p) {
            p.projectionType(ProjectionType.ALL);
        }

        private static final void initialize$lambda$26$lambda$25$lambda$24$lambda$23(Projection.Builder p) {
            p.projectionType(ProjectionType.ALL);
        }

        private static final void initialize$lambda$26(JsonArray $gsi, JsonArray $lsi, CreateTableEnhancedRequest.Builder builder) {
            block5: {
                Object it;
                Collection collection;
                Object item$iv$iv2;
                Iterator iterator;
                Iterable $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                boolean $i$f$map;
                CreateTableEnhancedRequest.Builder builder2;
                JsonArray jsonArray = $gsi;
                if (jsonArray != null) {
                    JsonArray gsi = jsonArray;
                    boolean bl = false;
                    Iterable iterable = (Iterable)gsi;
                    builder2 = builder;
                    $i$f$map = false;
                    void var8_8 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object t = item$iv$iv2 = iterator.next();
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.toString());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        it = (String)item$iv$iv2;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(EnhancedGlobalSecondaryIndex.builder().indexName(it).projection(Companion::initialize$lambda$26$lambda$21$lambda$20$lambda$19).build());
                    }
                    builder2.globalSecondaryIndices((Collection)((List)destination$iv$iv));
                }
                JsonArray jsonArray2 = $lsi;
                if (jsonArray2 == null) break block5;
                JsonArray lsi = jsonArray2;
                boolean bl = false;
                $this$map$iv = (Iterable)lsi;
                builder2 = builder;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    it = item$iv$iv2 = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.toString());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(EnhancedLocalSecondaryIndex.builder().indexName(it).projection(Companion::initialize$lambda$26$lambda$25$lambda$24$lambda$23).build());
                }
                builder2.localSecondaryIndices((Collection)((List)destination$iv$iv));
            }
        }

        private static final Object initialize$lambda$32$lambda$27(String $tableName) {
            return "Table creation for: " + $tableName + " is success!";
        }

        private static final void initialize$lambda$32$lambda$28(String $tableName, DescribeTableRequest.Builder b) {
            b.tableName($tableName);
        }

        private static final Object initialize$lambda$32$lambda$30$lambda$29(String $tableName) {
            return "Table wait for: " + $tableName + " is success!";
        }

        private static final Unit initialize$lambda$32$lambda$30(Promise $resultHandler, String $tableName, WaiterResponse waiterResponse, Throwable u2) {
            if (u2 == null) {
                if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                    DynamoDBRepositoryKt.access$getLogger$p().debug(() -> Companion.initialize$lambda$32$lambda$30$lambda$29($tableName));
                }
                $resultHandler.handle((AsyncResult)Future.succeededFuture());
            } else {
                $resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)u2));
            }
            return Unit.INSTANCE;
        }

        private static final void initialize$lambda$32$lambda$31(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        private static final Unit initialize$lambda$32(DynamoDbAsyncClient $client, Promise $resultHandler, String $tableName, Void void_, Throwable u) {
            if (u == null) {
                if (KLogger.DefaultImpls.isDebugEnabled$default((KLogger)DynamoDBRepositoryKt.access$getLogger$p(), null, (int)1, null)) {
                    DynamoDBRepositoryKt.access$getLogger$p().debug(() -> Companion.initialize$lambda$32$lambda$27($tableName));
                }
                $client.waiter().waitUntilTableExists(arg_0 -> Companion.initialize$lambda$32$lambda$28($tableName, arg_0)).whenComplete((arg_0, arg_1) -> Companion.initialize$lambda$32$lambda$31((arg_0, arg_1) -> Companion.initialize$lambda$32$lambda$30($resultHandler, $tableName, arg_0, arg_1), arg_0, arg_1));
            } else {
                $resultHandler.handle((AsyncResult)Future.succeededFuture());
            }
            return Unit.INSTANCE;
        }

        private static final void initialize$lambda$33(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

