/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.repository.dynamodb.operators;

import com.genghis.tools.repository.dynamodb.DynamoDBRepository;
import com.genghis.tools.repository.dynamodb.operators.DynamoDBUpdaterKt;
import com.genghis.tools.repository.models.Cacheable;
import com.genghis.tools.repository.models.ETagable;
import com.genghis.tools.repository.models.Model;
import com.genghis.tools.repository.repository.Repository;
import java.lang.reflect.Field;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u0003*\u00020\u0004*\u00020\u00052\u00020\u0006B\u0015\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J%\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/genghis/tools/repository/dynamodb/operators/DynamoDBUpdater;", "E", "Lcom/genghis/tools/repository/models/ETagable;", "Lcom/genghis/tools/repository/models/Cacheable;", "Lcom/genghis/tools/repository/models/DynamoDBModel;", "Lcom/genghis/tools/repository/models/Model;", "", "db", "Lcom/genghis/tools/repository/dynamodb/DynamoDBRepository;", "<init>", "(Lcom/genghis/tools/repository/dynamodb/DynamoDBRepository;)V", "incrementField", "", "record", "fieldName", "", "(Lcom/genghis/tools/repository/models/ETagable;Ljava/lang/String;)Z", "decrementField", "doCrementation", "field", "Ljava/lang/reflect/Field;", "direction", "Lcom/genghis/tools/repository/repository/Repository$INCREMENTATION;", "(Lcom/genghis/tools/repository/models/ETagable;Ljava/lang/reflect/Field;Lcom/genghis/tools/repository/repository/Repository$INCREMENTATION;)Z", "genghis-tools-repository"})
public final class DynamoDBUpdater<E extends ETagable & Cacheable & Model> {
    @NotNull
    private final DynamoDBRepository<E> db;

    public DynamoDBUpdater(@NotNull DynamoDBRepository<E> db) {
        Intrinsics.checkNotNullParameter(db, (String)"db");
        this.db = db;
    }

    public final boolean incrementField(@NotNull E record, @NotNull String fieldName) throws IllegalArgumentException {
        boolean bl;
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Field field = this.db.checkAndGetField(fieldName);
        try {
            bl = this.doCrementation(record, field, Repository.INCREMENTATION.ADDITION);
        }
        catch (IllegalAccessException e) {
            DynamoDBUpdaterKt.access$getLogger$p().error(() -> DynamoDBUpdater.incrementField$lambda$0(e));
            bl = false;
        }
        return bl;
    }

    public final boolean decrementField(@NotNull E record, @NotNull String fieldName) throws IllegalArgumentException {
        boolean bl;
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Field field = this.db.checkAndGetField(fieldName);
        try {
            bl = this.doCrementation(record, field, Repository.INCREMENTATION.SUBTRACTION);
        }
        catch (IllegalAccessException e) {
            DynamoDBUpdaterKt.access$getLogger$p().error(() -> DynamoDBUpdater.decrementField$lambda$1(e));
            bl = false;
        }
        return bl;
    }

    private final boolean doCrementation(E record, Field field, Repository.INCREMENTATION direction) throws IllegalAccessException {
        Class<?> clazz = field.getType();
        if (Intrinsics.areEqual(clazz, Long.class)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    field.set(record, (Long)object + 1L);
                    break;
                }
                case 2: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    if ((Long)object == 0L) break;
                    Object object2 = field.get(record);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long");
                    field.set(record, (Long)object2 - 1L);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Integer.class)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    field.set(record, (long)((Integer)object).intValue() + 1L);
                    break;
                }
                case 2: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    if ((Integer)object == 0) break;
                    Object object3 = field.get(record);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                    field.set(record, (long)((Integer)object3).intValue() - 1L);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Short.class)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
                    field.set(record, (long)((Short)object).shortValue() + 1L);
                    break;
                }
                case 2: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
                    if ((Short)object == 0) break;
                    Object object4 = field.get(record);
                    Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Short");
                    field.set(record, (long)((Short)object4).shortValue() - 1L);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Double.class)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                    field.set(record, (Double)object + (double)1L);
                    break;
                }
                case 2: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                    if ((Double)object == 0.0) break;
                    Object object5 = field.get(record);
                    Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Double");
                    field.set(record, (Double)object5 - (double)1L);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Float.class)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                    field.set(record, Float.valueOf(((Float)object).floatValue() + (float)1L));
                    break;
                }
                case 2: {
                    Object object = field.get(record);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                    if ((double)((Float)object).floatValue() == 0.0) break;
                    Object object6 = field.get(record);
                    Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.Float");
                    field.set(record, Float.valueOf(((Float)object6).floatValue() - (float)1L));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    field.setLong(record, field.getLong(record) + 1L);
                    break;
                }
                case 2: {
                    if (field.getLong(record) == 0L) break;
                    field.setLong(record, field.getLong(record) - 1L);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    field.setInt(record, field.getInt(record) + 1);
                    break;
                }
                case 2: {
                    if (field.getInt(record) == 0) break;
                    field.setInt(record, field.getInt(record) - 1);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Short.TYPE)) {
            short value = field.getShort(record);
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    value = (short)(value + 1);
                    field.setShort(record, value);
                    break;
                }
                case 2: {
                    if (value == 0) break;
                    value = (short)(value + -1);
                    field.setShort(record, value);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Double.TYPE)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    field.setDouble(record, field.getDouble(record) + 1.0);
                    break;
                }
                case 2: {
                    if (field.getDouble(record) == 0.0) break;
                    field.setDouble(record, field.getDouble(record) - 1.0);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (Intrinsics.areEqual(clazz, Float.TYPE)) {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    field.setFloat(record, field.getFloat(record) + 1.0f);
                    break;
                }
                case 2: {
                    if (field.getFloat(record) == 0.0f) break;
                    field.setFloat(record, field.getFloat(record) - 1.0f);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        return false;
    }

    private static final Object incrementField$lambda$0(IllegalAccessException $e) {
        return $e + " : " + $e.getMessage() + " : " + Arrays.toString($e.getStackTrace());
    }

    private static final Object decrementField$lambda$1(IllegalAccessException $e) {
        return $e + " : " + $e.getMessage() + " : " + Arrays.toString($e.getStackTrace());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Repository.INCREMENTATION.values().length];
            try {
                nArray[Repository.INCREMENTATION.ADDITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.INCREMENTATION.SUBTRACTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

