/*
 * Decompiled with CFR 0.152.
 */
package com.genghis.tools.repository.repository.redis;

import com.genghis.tools.repository.repository.redis.GenghisRedisClient;
import com.genghis.tools.repository.repository.redis.GenghisRedisConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kotlin.redis.client.RedisOptionsKt;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/genghis/tools/repository/repository/redis/RedisUtils;", "", "<init>", "()V", "getRedisClient", "Lcom/genghis/tools/repository/repository/redis/GenghisRedisClient;", "config", "Lio/vertx/core/json/JsonObject;", "vertx", "Lio/vertx/core/Vertx;", "genghis-tools-repository"})
@SourceDebugExtension(value={"SMAP\nRedisUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisUtils.kt\ncom/genghis/tools/repository/repository/redis/RedisUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1563#2:83\n1634#2,3:84\n1869#2,2:87\n*S KotlinDebug\n*F\n+ 1 RedisUtils.kt\ncom/genghis/tools/repository/repository/redis/RedisUtils\n*L\n57#1:83\n57#1:84,3\n64#1:87,2\n*E\n"})
public final class RedisUtils {
    @NotNull
    public static final RedisUtils INSTANCE = new RedisUtils();

    private RedisUtils() {
    }

    @NotNull
    public final GenghisRedisClient getRedisClient(@NotNull JsonObject config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Vertx vertx = Vertx.currentContext().owner();
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"owner(...)");
        return this.getRedisClient(vertx, config);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GenghisRedisClient getRedisClient(@NotNull Vertx vertx, @NotNull JsonObject config) {
        List list;
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = config.getString("redis_host");
        if (string == null) {
            string = "localhost";
        }
        String redisServer = string;
        Integer n = config.getInteger("redis_port");
        int redisPort = n != null ? n : 6380;
        Boolean bl = config.getBoolean("redis_tls");
        boolean tls = bl != null ? bl : false;
        Boolean bl2 = config.getBoolean("redis_clustered");
        boolean clustered = bl2 != null ? bl2 : false;
        Boolean bl3 = config.getBoolean("redis_replication");
        boolean replication = bl3 != null ? bl3 : false;
        JsonArray jsonArray = config.getJsonArray("redis_connections");
        if (jsonArray != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List additionalConnections = list;
        RedisOptions redisOptions = RedisOptionsKt.redisOptionsOf$default((RedisClientType)(clustered ? RedisClientType.CLUSTER : RedisClientType.STANDALONE), null, null, null, null, null, null, null, null, null, null, null, (Integer)48, (Integer)96, null, null, null, null, null, null, null, null, null, (int)8376318, null);
        Iterable $this$forEach$iv = additionalConnections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl5 = false;
            redisOptions.addConnectionString(it);
        }
        redisOptions.setConnectionString("redis" + (tls ? "s" : "") + "://" + redisServer + ":" + redisPort);
        return new GenghisRedisClient(vertx, new GenghisRedisConfiguration(redisServer, redisPort, tls, clustered, replication, redisOptions));
    }
}

