package com.genghis.tools.repository.utils

import io.vertx.codegen.annotations.DataObject
import io.vertx.codegen.json.annotations.JsonGen
import io.vertx.core.json.JsonObject

@DataObject
data class ItemListMeta(
    val etag: String,
    val count: Int,
    val totalCount: Int,
) {
    constructor(jsonObject: JsonObject) : this(
        etag = jsonObject.getString("etag"),
        count = jsonObject.getInteger("count"),
        totalCount = jsonObject.getInteger("totalCount"),
    )
}
