/*
 * MIT License
 *
 * Copyright (c) 2017 Anders Mikkelsen
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

package com.genghis.tools.repository.repository.results

import com.genghis.tools.repository.models.Model
import com.genghis.tools.repository.utils.ItemList
import com.genghis.tools.repository.utils.PageTokens

/**
 * This class defines a container for the result of an index operation.
 *
 * @author Anders Mikkelsen
 * @version 17.11.2017
 */
data class ItemListResult<K : Model>(
    private val etagBase: String? = "/START",
    private val count: Int = 0,
    private val totalCount: Int = 0,
    private val items: List<K> = emptyList(),
    private val paging: PageTokens = PageTokens(),
    private val projections: Set<String> = emptySet(),
    val isCacheHit: Boolean = false,
    val preOperationProcessingTime: Long = 0,
    val operationProcessingTime: Long = 0,
    val postOperationProcessingTime: Long = 0,
) {
    val itemList: ItemList<K> =
        ItemList.create(
            etagBase = etagBase ?: "/START",
            pageTokens = paging,
            count = count,
            totalCount = totalCount,
            items = items,
            projections = projections,
        )
}
