/*
 * Decompiled with CFR 0.152.
 */
package no.solibo.digipost;

import java.io.InputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EmailNotification;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.ListedTime;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageRecipient;
import no.digipost.api.client.representations.NorwegianAddress;
import no.digipost.api.client.representations.OrganisationNumber;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.PrintDetails;
import no.digipost.api.client.representations.PrintRecipient;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;
import no.digipost.api.client.representations.inbox.Inbox;
import no.digipost.api.client.security.Signer;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.types.invoice.Invoice;
import no.solibo.digipost.DigiPostAddress;
import no.solibo.digipost.DigiPostConfig;
import no.solibo.digipost.DigiPostEmailInfo;
import no.solibo.digipost.DigiPostInvoiceInfo;
import no.solibo.digipost.DigiPostLetter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012JE\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010!JM\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00122\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010$JM\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00122\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010$JM\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00122\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010$JU\u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010+JM\u0010,\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00122\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010$JU\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 \"\u00020\u001c\u00a2\u0006\u0002\u0010+J\u0006\u0010.\u001a\u00020/JJ\u00100\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020402\u00a2\u0006\u0002\b5H\u0002\u00a2\u0006\u0002\u00106JR\u00107\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0 2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020402\u00a2\u0006\u0002\b5H\u0002\u00a2\u0006\u0002\u00108JM\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020402\u00a2\u0006\u0002\b52\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020@0?2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lno/solibo/digipost/DigiPost;", "", "config", "Lno/solibo/digipost/DigiPostConfig;", "<init>", "(Lno/solibo/digipost/DigiPostConfig;)V", "senderId", "Lno/digipost/api/client/SenderId;", "kotlin.jvm.PlatformType", "signer", "Lno/digipost/api/client/security/Signer;", "client", "Lno/digipost/api/client/DigipostClient;", "defaultSoliboReturnAddress", "Lno/digipost/api/client/representations/PrintRecipient;", "search", "Lno/digipost/api/client/representations/IdentificationResult;", "pnr", "", "searchOrg", "orgNr", "sendAdHocLetter", "Lno/digipost/api/client/representations/MessageDelivery;", "address", "Lno/solibo/digipost/DigiPostAddress;", "emailInfo", "Lno/solibo/digipost/DigiPostEmailInfo;", "primary", "Lno/solibo/digipost/DigiPostLetter;", "fallbackPrint", "", "attachments", "", "(Lno/solibo/digipost/DigiPostAddress;Lno/solibo/digipost/DigiPostEmailInfo;Lno/solibo/digipost/DigiPostLetter;Z[Lno/solibo/digipost/DigiPostLetter;)Lno/digipost/api/client/representations/MessageDelivery;", "sendAdHocLetterToPersonnummer", "personnummer", "(Lno/solibo/digipost/DigiPostAddress;Ljava/lang/String;Lno/solibo/digipost/DigiPostEmailInfo;Lno/solibo/digipost/DigiPostLetter;Z[Lno/solibo/digipost/DigiPostLetter;)Lno/digipost/api/client/representations/MessageDelivery;", "sendAdHocLetterToOrgnr", "orgnr", "sendGjenpartToPersonnummer", "sendInvoiceToPersonnummer", "invoiceInfo", "Lno/solibo/digipost/DigiPostInvoiceInfo;", "(Lno/solibo/digipost/DigiPostAddress;Ljava/lang/String;Lno/solibo/digipost/DigiPostInvoiceInfo;Lno/solibo/digipost/DigiPostEmailInfo;Lno/solibo/digipost/DigiPostLetter;Z[Lno/solibo/digipost/DigiPostLetter;)Lno/digipost/api/client/representations/MessageDelivery;", "sendGjenpartToOrgnr", "sendInvoiceToOrgnr", "readInbox", "Lno/digipost/api/client/representations/inbox/Inbox;", "sendLetter", "recipientSetter", "Lkotlin/Function1;", "Lno/digipost/api/client/representations/Message$MessageBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Lno/solibo/digipost/DigiPostLetter;[Lno/solibo/digipost/DigiPostLetter;Lno/solibo/digipost/DigiPostEmailInfo;Lkotlin/jvm/functions/Function1;)Lno/digipost/api/client/representations/MessageDelivery;", "sendInvoice", "(Lno/solibo/digipost/DigiPostLetter;[Lno/solibo/digipost/DigiPostLetter;Lno/solibo/digipost/DigiPostInvoiceInfo;Lno/solibo/digipost/DigiPostEmailInfo;Lkotlin/jvm/functions/Function1;)Lno/digipost/api/client/representations/MessageDelivery;", "send", "uuid", "Ljava/util/UUID;", "primaryDocument", "Lno/digipost/api/client/representations/Document;", "attachmentDocuments", "", "Ljava/io/InputStream;", "buildPrintJob", "Lno/digipost/api/client/representations/PrintDetails;", "solibo-digipost"})
@SourceDebugExtension(value={"SMAP\nDigiPost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigiPost.kt\nno/solibo/digipost/DigiPost\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,368:1\n8569#2,2:369\n9251#2,4:371\n8569#2,2:375\n9251#2,4:377\n8569#2,2:381\n9251#2,4:383\n8569#2,2:387\n9251#2,4:389\n216#3,2:393\n*S KotlinDebug\n*F\n+ 1 DigiPost.kt\nno/solibo/digipost/DigiPost\n*L\n257#1:369,2\n257#1:371,4\n279#1:375,2\n279#1:377,4\n294#1:381,2\n294#1:383,4\n324#1:387,2\n324#1:389,4\n347#1:393,2\n*E\n"})
public final class DigiPost {
    private final SenderId senderId;
    private final Signer signer;
    @NotNull
    private final DigipostClient client;
    @NotNull
    private final PrintRecipient defaultSoliboReturnAddress;

    public DigiPost(@NotNull DigiPostConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.senderId = SenderId.of((long)config.getSender());
        this.signer = Signer.using((PrivateKey)config.getKey());
        this.client = new DigipostClient(DigipostClientConfig.newConfiguration().digipostApiUri(URI.create(config.getHost())).build(), this.senderId.asBrokerId(), this.signer);
        this.defaultSoliboReturnAddress = new PrintRecipient("Solibo AS", new NorwegianAddress("Dronning Eufemias gate 16", "0191", "Oslo"));
    }

    @NotNull
    public final IdentificationResult search(@NotNull String pnr) {
        Intrinsics.checkNotNullParameter((Object)pnr, (String)"pnr");
        IdentificationResult identificationResult = this.client.identifyRecipient(new Identification(new PersonalIdentificationNumber(pnr)));
        Intrinsics.checkNotNullExpressionValue((Object)identificationResult, (String)"identifyRecipient(...)");
        return identificationResult;
    }

    @NotNull
    public final IdentificationResult searchOrg(@NotNull String orgNr) {
        Intrinsics.checkNotNullParameter((Object)orgNr, (String)"orgNr");
        IdentificationResult identificationResult = this.client.identifyRecipient(new Identification(new OrganisationNumber(orgNr)));
        Intrinsics.checkNotNullExpressionValue((Object)identificationResult, (String)"identifyRecipient(...)");
        return identificationResult;
    }

    @NotNull
    public final MessageDelivery sendAdHocLetter(@NotNull DigiPostAddress address, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        PrintDetails print = this.buildPrintJob(address);
        return this.sendLetter(primary, attachments, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendAdHocLetter$lambda$0(fallbackPrint, address, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendAdHocLetter$default(DigiPost digiPost, DigiPostAddress digiPostAddress, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 2) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return digiPost.sendAdHocLetter(digiPostAddress, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final MessageDelivery sendAdHocLetterToPersonnummer(@NotNull DigiPostAddress address, @NotNull String personnummer, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)personnummer, (String)"personnummer");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        PersonalIdentificationNumber pin = new PersonalIdentificationNumber(personnummer);
        PrintDetails print = this.buildPrintJob(address);
        return this.sendLetter(primary, attachments, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendAdHocLetterToPersonnummer$lambda$1(fallbackPrint, pin, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendAdHocLetterToPersonnummer$default(DigiPost digiPost, DigiPostAddress digiPostAddress, String string, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 4) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return digiPost.sendAdHocLetterToPersonnummer(digiPostAddress, string, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final MessageDelivery sendAdHocLetterToOrgnr(@NotNull DigiPostAddress address, @NotNull String orgnr, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)orgnr, (String)"orgnr");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        OrganisationNumber pin = new OrganisationNumber(orgnr);
        PrintDetails print = this.buildPrintJob(address);
        return this.sendLetter(primary, attachments, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendAdHocLetterToOrgnr$lambda$2(fallbackPrint, pin, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendAdHocLetterToOrgnr$default(DigiPost digiPost, DigiPostAddress digiPostAddress, String string, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 4) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return digiPost.sendAdHocLetterToOrgnr(digiPostAddress, string, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final MessageDelivery sendGjenpartToPersonnummer(@NotNull DigiPostAddress address, @NotNull String personnummer, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)personnummer, (String)"personnummer");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        PersonalIdentificationNumber pin = new PersonalIdentificationNumber(personnummer);
        PrintDetails print = this.buildPrintJob(address);
        return this.sendLetter(primary, attachments, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendGjenpartToPersonnummer$lambda$3(fallbackPrint, pin, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendGjenpartToPersonnummer$default(DigiPost digiPost, DigiPostAddress digiPostAddress, String string, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 4) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return digiPost.sendGjenpartToPersonnummer(digiPostAddress, string, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final MessageDelivery sendInvoiceToPersonnummer(@NotNull DigiPostAddress address, @NotNull String personnummer, @NotNull DigiPostInvoiceInfo invoiceInfo, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)personnummer, (String)"personnummer");
        Intrinsics.checkNotNullParameter((Object)invoiceInfo, (String)"invoiceInfo");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        PersonalIdentificationNumber pin = new PersonalIdentificationNumber(personnummer);
        PrintDetails print = this.buildPrintJob(address);
        return this.sendInvoice(primary, attachments, invoiceInfo, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendInvoiceToPersonnummer$lambda$4(fallbackPrint, pin, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendInvoiceToPersonnummer$default(DigiPost digiPost, DigiPostAddress digiPostAddress, String string, DigiPostInvoiceInfo digiPostInvoiceInfo, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 8) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return digiPost.sendInvoiceToPersonnummer(digiPostAddress, string, digiPostInvoiceInfo, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final MessageDelivery sendGjenpartToOrgnr(@NotNull DigiPostAddress address, @NotNull String orgnr, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)orgnr, (String)"orgnr");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        OrganisationNumber pin = new OrganisationNumber(orgnr);
        PrintDetails print = this.buildPrintJob(address);
        return this.sendLetter(primary, attachments, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendGjenpartToOrgnr$lambda$5(fallbackPrint, pin, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendGjenpartToOrgnr$default(DigiPost digiPost, DigiPostAddress digiPostAddress, String string, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 4) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return digiPost.sendGjenpartToOrgnr(digiPostAddress, string, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final MessageDelivery sendInvoiceToOrgnr(@NotNull DigiPostAddress address, @NotNull String orgnr, @NotNull DigiPostInvoiceInfo invoiceInfo, @Nullable DigiPostEmailInfo emailInfo, @NotNull DigiPostLetter primary, boolean fallbackPrint, DigiPostLetter ... attachments) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)orgnr, (String)"orgnr");
        Intrinsics.checkNotNullParameter((Object)invoiceInfo, (String)"invoiceInfo");
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        OrganisationNumber pin = new OrganisationNumber(orgnr);
        PrintDetails print = this.buildPrintJob(address);
        return this.sendInvoice(primary, attachments, invoiceInfo, emailInfo, (Function1<? super Message.MessageBuilder, Unit>)((Function1)arg_0 -> DigiPost.sendInvoiceToOrgnr$lambda$6(fallbackPrint, pin, print, arg_0)));
    }

    public static /* synthetic */ MessageDelivery sendInvoiceToOrgnr$default(DigiPost digiPost, DigiPostAddress digiPostAddress, String string, DigiPostInvoiceInfo digiPostInvoiceInfo, DigiPostEmailInfo digiPostEmailInfo, DigiPostLetter digiPostLetter, boolean bl, DigiPostLetter[] digiPostLetterArray, int n, Object object) {
        if ((n & 8) != 0) {
            digiPostEmailInfo = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return digiPost.sendInvoiceToOrgnr(digiPostAddress, string, digiPostInvoiceInfo, digiPostEmailInfo, digiPostLetter, bl, digiPostLetterArray);
    }

    @NotNull
    public final Inbox readInbox() {
        Inbox inbox = this.client.getInbox(this.senderId);
        Intrinsics.checkNotNullExpressionValue((Object)inbox, (String)"getInbox(...)");
        return inbox;
    }

    /*
     * WARNING - void declaration
     */
    private final MessageDelivery sendLetter(DigiPostLetter primary, DigiPostLetter[] attachments, DigiPostEmailInfo emailInfo, Function1<? super Message.MessageBuilder, Unit> recipientSetter) {
        void $this$associateTo$iv$iv;
        EmailNotification emailNotification;
        void $this$associateTo$iv$iv2;
        UUID uuid = UUID.randomUUID();
        DigiPostLetter[] $this$associate$iv = attachments;
        boolean $i$f$associate = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        DigiPostLetter[] digiPostLetterArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo22 = false;
        for (void element$iv$iv : $this$associateTo$iv$iv2) {
            Map map = destination$iv$iv;
            Pair it = element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getSubject(), (Object)UUID.randomUUID());
            map.put(it.getFirst(), it.getSecond());
        }
        Map attachmentsUUIDs = destination$iv$iv;
        UUID uUID = uuid;
        String string = primary.getSubject();
        FileType fileType = primary.getFileType();
        String string2 = null;
        SmsNotification smsNotification = null;
        DigiPostEmailInfo digiPostEmailInfo = emailInfo;
        if (digiPostEmailInfo != null) {
            DigiPostEmailInfo capacity$iv2 = digiPostEmailInfo;
            SmsNotification smsNotification2 = smsNotification;
            String string3 = string2;
            FileType fileType2 = fileType;
            String string4 = string;
            UUID uUID2 = uUID;
            boolean bl = false;
            EmailNotification emailNotification2 = new EmailNotification(emailInfo.getEmail(), emailInfo.getSubject(), emailInfo.getText(), CollectionsKt.listOf((Object)new ListedTime(emailInfo.getAt())));
            uUID = uUID2;
            string = string4;
            fileType = fileType2;
            string2 = string3;
            smsNotification = smsNotification2;
            emailNotification = emailNotification2;
        } else {
            emailNotification = null;
        }
        String[] stringArray = new String[]{};
        DataType dataType = null;
        Boolean bl = null;
        SensitivityLevel sensitivityLevel = null;
        AuthenticationLevel authenticationLevel = null;
        EmailNotification emailNotification3 = emailNotification;
        SmsNotification smsNotification3 = smsNotification;
        String string5 = string2;
        FileType fileType3 = fileType;
        String string6 = string;
        UUID uUID3 = uUID;
        Document primaryDocument = new Document(uUID3, string6, fileType3, string5, smsNotification3, emailNotification3, authenticationLevel, sensitivityLevel, bl, dataType, stringArray);
        DigiPostLetter[] $this$associate$iv2 = attachments;
        boolean $i$f$associate2 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv2.length), (int)16);
        DigiPostLetter[] $i$f$associateTo22 = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            void it = element$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)new Document((UUID)attachmentsUUIDs.get(it.getSubject()), it.getSubject(), it.getFileType()), (Object)it.getContent());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map attachmentDocuments = destination$iv$iv2;
        Intrinsics.checkNotNull((Object)uuid);
        return this.send(uuid, primaryDocument, recipientSetter, attachmentDocuments, primary);
    }

    static /* synthetic */ MessageDelivery sendLetter$default(DigiPost digiPost, DigiPostLetter digiPostLetter, DigiPostLetter[] digiPostLetterArray, DigiPostEmailInfo digiPostEmailInfo, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            digiPostEmailInfo = null;
        }
        return digiPost.sendLetter(digiPostLetter, digiPostLetterArray, digiPostEmailInfo, (Function1<? super Message.MessageBuilder, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final MessageDelivery sendInvoice(DigiPostLetter primary, DigiPostLetter[] attachments, DigiPostInvoiceInfo invoiceInfo, DigiPostEmailInfo emailInfo, Function1<? super Message.MessageBuilder, Unit> recipientSetter) {
        void $this$associateTo$iv$iv;
        EmailNotification emailNotification;
        DigiPostEmailInfo $this$associateTo$iv$iv2;
        UUID uuid = UUID.randomUUID();
        DigiPostLetter[] $this$associate$iv = attachments;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        DigiPostLetter[] digiPostLetterArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv2) {
            Map map = destination$iv$iv;
            void it = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getSubject(), (Object)UUID.randomUUID());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map attachmentsUUIDs = destination$iv$iv;
        Invoice invoiceDataType = new Invoice(null, invoiceInfo.getDueDate(), invoiceInfo.getSum(), invoiceInfo.getAccount(), invoiceInfo.getKid());
        UUID uUID = uuid;
        String string = primary.getSubject();
        FileType fileType = primary.getFileType();
        String string2 = null;
        SmsNotification smsNotification = null;
        DigiPostEmailInfo digiPostEmailInfo = emailInfo;
        if (digiPostEmailInfo != null) {
            $this$associateTo$iv$iv2 = digiPostEmailInfo;
            SmsNotification smsNotification2 = smsNotification;
            String string3 = string2;
            FileType fileType2 = fileType;
            String string4 = string;
            UUID uUID2 = uUID;
            boolean bl = false;
            EmailNotification emailNotification2 = new EmailNotification(emailInfo.getEmail(), emailInfo.getSubject(), emailInfo.getText(), CollectionsKt.listOf((Object)new ListedTime(emailInfo.getAt())));
            uUID = uUID2;
            string = string4;
            fileType = fileType2;
            string2 = string3;
            smsNotification = smsNotification2;
            emailNotification = emailNotification2;
        } else {
            emailNotification = null;
        }
        String[] stringArray = new String[]{};
        DataType dataType = (DataType)invoiceDataType;
        Boolean bl = null;
        SensitivityLevel sensitivityLevel = null;
        AuthenticationLevel authenticationLevel = null;
        EmailNotification emailNotification3 = emailNotification;
        SmsNotification smsNotification3 = smsNotification;
        String string5 = string2;
        FileType fileType3 = fileType;
        String string6 = string;
        UUID uUID3 = uUID;
        Document primaryDocument = new Document(uUID3, string6, fileType3, string5, smsNotification3, emailNotification3, authenticationLevel, sensitivityLevel, bl, dataType, stringArray);
        DigiPostLetter[] $this$associate$iv2 = attachments;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv2.length), (int)16);
        DigiPostLetter[] digiPostLetterArray2 = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            void it = element$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)new Document((UUID)attachmentsUUIDs.get(it.getSubject()), it.getSubject(), it.getFileType()), (Object)it.getContent());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map attachmentDocuments = destination$iv$iv2;
        Intrinsics.checkNotNull((Object)uuid);
        return this.send(uuid, primaryDocument, recipientSetter, attachmentDocuments, primary);
    }

    static /* synthetic */ MessageDelivery sendInvoice$default(DigiPost digiPost, DigiPostLetter digiPostLetter, DigiPostLetter[] digiPostLetterArray, DigiPostInvoiceInfo digiPostInvoiceInfo, DigiPostEmailInfo digiPostEmailInfo, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            digiPostEmailInfo = null;
        }
        return digiPost.sendInvoice(digiPostLetter, digiPostLetterArray, digiPostInvoiceInfo, digiPostEmailInfo, (Function1<? super Message.MessageBuilder, Unit>)function1);
    }

    private final MessageDelivery send(UUID uuid, Document primaryDocument, Function1<? super Message.MessageBuilder, Unit> recipientSetter, Map<Document, ? extends InputStream> attachmentDocuments, DigiPostLetter primary) {
        Message.MessageBuilder messageBuilder = Message.newMessage((UUID)uuid, (Document)primaryDocument);
        Intrinsics.checkNotNull((Object)messageBuilder);
        recipientSetter.invoke((Object)messageBuilder);
        if (!attachmentDocuments.isEmpty()) {
            messageBuilder.attachments((Iterable)attachmentDocuments.keySet());
        }
        Message message = messageBuilder.build();
        OngoingDelivery.SendableWithPrintFallback clientRequest = (OngoingDelivery.SendableWithPrintFallback)this.client.createMessage(message).addContent(primaryDocument, primary.getContent());
        Map<Document, ? extends InputStream> $this$forEach$iv = attachmentDocuments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Document, ? extends InputStream>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Document, ? extends InputStream> element$iv;
            Map.Entry<Document, ? extends InputStream> entry = element$iv = iterator.next();
            boolean bl = false;
            Document k = entry.getKey();
            InputStream v = entry.getValue();
            clientRequest.addContent(k, v);
        }
        MessageDelivery messageDelivery = clientRequest.send();
        Intrinsics.checkNotNullExpressionValue((Object)messageDelivery, (String)"send(...)");
        return messageDelivery;
    }

    private final PrintDetails buildPrintJob(DigiPostAddress address) {
        return new PrintDetails(new PrintRecipient(address.getFullName(), new NorwegianAddress(address.getAdresseLineOne(), address.getAdresseLineTwo(), address.getPostalArea(), address.getCity())), this.defaultSoliboReturnAddress, PrintDetails.PrintColors.COLORS, PrintDetails.NondeliverableHandling.RETURN_TO_SENDER);
    }

    private static final Unit sendAdHocLetter$lambda$0(boolean $fallbackPrint, DigiPostAddress $address, PrintDetails $print, Message.MessageBuilder $this$sendLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sendLetter, (String)"$this$sendLetter");
        if ($fallbackPrint) {
            $this$sendLetter.recipient($address.toDigipost());
            v0 = $this$sendLetter.printDetails($print);
        } else {
            v0 = $this$sendLetter.recipient($address.toDigipost());
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendAdHocLetterToPersonnummer$lambda$1(boolean $fallbackPrint, PersonalIdentificationNumber $pin, PrintDetails $print, Message.MessageBuilder $this$sendLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sendLetter, (String)"$this$sendLetter");
        Message.MessageBuilder messageBuilder = $fallbackPrint ? $this$sendLetter.recipient(new MessageRecipient($pin, $print)) : $this$sendLetter.recipient($pin);
        return Unit.INSTANCE;
    }

    private static final Unit sendAdHocLetterToOrgnr$lambda$2(boolean $fallbackPrint, OrganisationNumber $pin, PrintDetails $print, Message.MessageBuilder $this$sendLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sendLetter, (String)"$this$sendLetter");
        Message.MessageBuilder messageBuilder = $fallbackPrint ? $this$sendLetter.recipient(new MessageRecipient($pin, $print)) : $this$sendLetter.recipient($pin);
        return Unit.INSTANCE;
    }

    private static final Unit sendGjenpartToPersonnummer$lambda$3(boolean $fallbackPrint, PersonalIdentificationNumber $pin, PrintDetails $print, Message.MessageBuilder $this$sendLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sendLetter, (String)"$this$sendLetter");
        Message.MessageBuilder messageBuilder = $fallbackPrint ? $this$sendLetter.recipient(new MessageRecipient($pin, $print)) : $this$sendLetter.recipient($pin);
        return Unit.INSTANCE;
    }

    private static final Unit sendInvoiceToPersonnummer$lambda$4(boolean $fallbackPrint, PersonalIdentificationNumber $pin, PrintDetails $print, Message.MessageBuilder $this$sendInvoice) {
        Intrinsics.checkNotNullParameter((Object)$this$sendInvoice, (String)"$this$sendInvoice");
        Message.MessageBuilder messageBuilder = $fallbackPrint ? $this$sendInvoice.recipient(new MessageRecipient($pin, $print)) : $this$sendInvoice.recipient($pin);
        return Unit.INSTANCE;
    }

    private static final Unit sendGjenpartToOrgnr$lambda$5(boolean $fallbackPrint, OrganisationNumber $pin, PrintDetails $print, Message.MessageBuilder $this$sendLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sendLetter, (String)"$this$sendLetter");
        Message.MessageBuilder messageBuilder = $fallbackPrint ? $this$sendLetter.recipient(new MessageRecipient($pin, $print)) : $this$sendLetter.recipient($pin);
        return Unit.INSTANCE;
    }

    private static final Unit sendInvoiceToOrgnr$lambda$6(boolean $fallbackPrint, OrganisationNumber $pin, PrintDetails $print, Message.MessageBuilder $this$sendInvoice) {
        Intrinsics.checkNotNullParameter((Object)$this$sendInvoice, (String)"$this$sendInvoice");
        Message.MessageBuilder messageBuilder = $fallbackPrint ? $this$sendInvoice.recipient(new MessageRecipient($pin, $print)) : $this$sendInvoice.recipient($pin);
        return Unit.INSTANCE;
    }
}

