/*
 * Decompiled with CFR 0.152.
 */
package io.bkbn.kompendium.json.schema;

import io.bkbn.kompendium.enrichment.CollectionEnrichment;
import io.bkbn.kompendium.enrichment.Enrichment;
import io.bkbn.kompendium.enrichment.MapEnrichment;
import io.bkbn.kompendium.enrichment.ObjectEnrichment;
import io.bkbn.kompendium.enrichment.TypeEnrichment;
import io.bkbn.kompendium.json.schema.SchemaConfigurator;
import io.bkbn.kompendium.json.schema.definition.JsonSchema;
import io.bkbn.kompendium.json.schema.definition.NullableDefinition;
import io.bkbn.kompendium.json.schema.definition.OneOfDefinition;
import io.bkbn.kompendium.json.schema.definition.TypeDefinition;
import io.bkbn.kompendium.json.schema.handler.CollectionHandler;
import io.bkbn.kompendium.json.schema.handler.EnumHandler;
import io.bkbn.kompendium.json.schema.handler.MapHandler;
import io.bkbn.kompendium.json.schema.handler.SealedObjectHandler;
import io.bkbn.kompendium.json.schema.handler.SimpleObjectHandler;
import io.bkbn.kompendium.json.schema.util.Helpers;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ>\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005H\u0002JD\u0010\u0013\u001a\u00020\u00052\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J6\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J6\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002JB\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lio/bkbn/kompendium/json/schema/SchemaGenerator;", "", "<init>", "()V", "fromTypeToSchema", "Lio/bkbn/kompendium/json/schema/definition/JsonSchema;", "type", "Lkotlin/reflect/KType;", "cache", "", "", "schemaConfigurator", "Lio/bkbn/kompendium/json/schema/SchemaConfigurator;", "enrichment", "Lio/bkbn/kompendium/enrichment/Enrichment;", "fromTypeOrUnit", "Lio/bkbn/kompendium/enrichment/TypeEnrichment;", "checkForNull", "schema", "complexTypeToSchema", "clazz", "Lkotlin/reflect/KClass;", "handleCollection", "handleMap", "handleObject", "solibo-kompendium-json-schema"})
public final class SchemaGenerator {
    @NotNull
    public static final SchemaGenerator INSTANCE = new SchemaGenerator();

    private SchemaGenerator() {
    }

    @NotNull
    public final JsonSchema fromTypeToSchema(@NotNull KType type, @NotNull Map<String, JsonSchema> cache, @NotNull SchemaConfigurator schemaConfigurator, @Nullable Enrichment enrichment) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)schemaConfigurator, (String)"schemaConfigurator");
        String slug = Helpers.INSTANCE.getSlug(type, enrichment);
        JsonSchema jsonSchema = cache.get(slug);
        if (jsonSchema != null) {
            JsonSchema it = jsonSchema;
            boolean bl = false;
            return it;
        }
        KClassifier kClassifier = type.getClassifier();
        Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        KClass clazz = (KClass)kClassifier;
        if (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Unit.class))) {
            throw new IllegalStateException("Unit cannot be converted to JsonSchema.\nIf you are looking for a method will return null when called with Unit,\nplease call SchemaGenerator.fromTypeOrUnit()".toString());
        }
        return Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? this.checkForNull(type, TypeDefinition.Companion.getINT()) : (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) ? this.checkForNull(type, TypeDefinition.Companion.getLONG()) : (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) ? this.checkForNull(type, TypeDefinition.Companion.getDOUBLE()) : (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) ? this.checkForNull(type, TypeDefinition.Companion.getFLOAT()) : (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(String.class)) ? this.checkForNull(type, TypeDefinition.Companion.getSTRING()) : (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? this.checkForNull(type, TypeDefinition.Companion.getBOOLEAN()) : (Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(UUID.class)) ? this.checkForNull(type, TypeDefinition.Companion.getUUID()) : this.complexTypeToSchema(clazz, type, cache, schemaConfigurator, (Enrichment)(enrichment instanceof TypeEnrichment ? (TypeEnrichment)enrichment : null))))))));
    }

    public static /* synthetic */ JsonSchema fromTypeToSchema$default(SchemaGenerator schemaGenerator, KType kType, Map map, SchemaConfigurator schemaConfigurator, Enrichment enrichment, int n, Object object) {
        if ((n & 8) != 0) {
            enrichment = null;
        }
        return schemaGenerator.fromTypeToSchema(kType, map, schemaConfigurator, enrichment);
    }

    @Nullable
    public final JsonSchema fromTypeOrUnit(@NotNull KType type, @NotNull Map<String, JsonSchema> cache, @NotNull SchemaConfigurator schemaConfigurator, @Nullable TypeEnrichment<?> enrichment) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)schemaConfigurator, (String)"schemaConfigurator");
        KClassifier kClassifier = type.getClassifier();
        Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        return Intrinsics.areEqual((Object)((KClass)kClassifier), (Object)Reflection.getOrCreateKotlinClass(Unit.class)) ? null : this.fromTypeToSchema(type, cache, schemaConfigurator, (Enrichment)enrichment);
    }

    public static /* synthetic */ JsonSchema fromTypeOrUnit$default(SchemaGenerator schemaGenerator, KType kType, Map map, SchemaConfigurator schemaConfigurator, TypeEnrichment typeEnrichment, int n, Object object) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            typeEnrichment = null;
        }
        return schemaGenerator.fromTypeOrUnit(kType, map, schemaConfigurator, typeEnrichment);
    }

    private final JsonSchema checkForNull(KType type, JsonSchema schema) {
        JsonSchema jsonSchema;
        boolean bl = type.isMarkedNullable();
        if (bl) {
            JsonSchema[] jsonSchemaArray = new JsonSchema[]{schema, new NullableDefinition(null, null, null, 7, null)};
            jsonSchema = new OneOfDefinition(jsonSchemaArray);
        } else if (!bl) {
            jsonSchema = schema;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonSchema;
    }

    private final JsonSchema complexTypeToSchema(KClass<?> clazz, KType type, Map<String, JsonSchema> cache, SchemaConfigurator schemaConfigurator, Enrichment enrichment) {
        return KClasses.isSubclassOf(clazz, (KClass)Reflection.getOrCreateKotlinClass(Enum.class)) ? EnumHandler.INSTANCE.handle(type, clazz, cache) : (KClasses.isSubclassOf(clazz, (KClass)Reflection.getOrCreateKotlinClass(Collection.class)) ? this.handleCollection(type, cache, schemaConfigurator, enrichment) : (KClasses.isSubclassOf(clazz, (KClass)Reflection.getOrCreateKotlinClass(Map.class)) ? this.handleMap(type, cache, schemaConfigurator, enrichment) : this.handleObject(type, clazz, cache, schemaConfigurator, enrichment)));
    }

    static /* synthetic */ JsonSchema complexTypeToSchema$default(SchemaGenerator schemaGenerator, KClass kClass, KType kType, Map map, SchemaConfigurator schemaConfigurator, Enrichment enrichment, int n, Object object) {
        if ((n & 0x10) != 0) {
            enrichment = null;
        }
        return schemaGenerator.complexTypeToSchema(kClass, kType, map, schemaConfigurator, enrichment);
    }

    private final JsonSchema handleCollection(KType type, Map<String, JsonSchema> cache, SchemaConfigurator schemaConfigurator, Enrichment enrichment) {
        JsonSchema jsonSchema;
        Enrichment enrichment2 = enrichment;
        if (enrichment2 instanceof CollectionEnrichment) {
            jsonSchema = CollectionHandler.INSTANCE.handle(type, cache, schemaConfigurator, (CollectionEnrichment)enrichment);
        } else if (enrichment2 == null) {
            jsonSchema = CollectionHandler.INSTANCE.handle(type, cache, schemaConfigurator, null);
        } else {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + enrichment.getId()).toString());
        }
        return jsonSchema;
    }

    private final JsonSchema handleMap(KType type, Map<String, JsonSchema> cache, SchemaConfigurator schemaConfigurator, Enrichment enrichment) {
        JsonSchema jsonSchema;
        Enrichment enrichment2 = enrichment;
        if (enrichment2 instanceof MapEnrichment) {
            jsonSchema = MapHandler.INSTANCE.handle(type, cache, schemaConfigurator, (MapEnrichment)enrichment);
        } else if (enrichment2 == null) {
            jsonSchema = MapHandler.INSTANCE.handle(type, cache, schemaConfigurator, null);
        } else {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + enrichment.getId()).toString());
        }
        return jsonSchema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JsonSchema handleObject(KType type, KClass<?> clazz, Map<String, JsonSchema> cache, SchemaConfigurator schemaConfigurator, Enrichment enrichment) {
        JsonSchema jsonSchema;
        boolean bl = clazz.isSealed();
        if (bl) {
            Enrichment enrichment2 = enrichment;
            if (enrichment2 instanceof ObjectEnrichment) {
                jsonSchema = SealedObjectHandler.INSTANCE.handle(type, clazz, cache, schemaConfigurator, (ObjectEnrichment)enrichment);
                return jsonSchema;
            } else {
                if (enrichment2 != null) throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + enrichment.getId()).toString());
                jsonSchema = SealedObjectHandler.INSTANCE.handle(type, clazz, cache, schemaConfigurator, null);
            }
            return jsonSchema;
        } else {
            if (bl) throw new NoWhenBranchMatchedException();
            Enrichment enrichment3 = enrichment;
            if (enrichment3 instanceof ObjectEnrichment) {
                jsonSchema = SimpleObjectHandler.INSTANCE.handle(type, clazz, cache, schemaConfigurator, (ObjectEnrichment)enrichment);
                return jsonSchema;
            } else {
                if (enrichment3 != null) throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + enrichment.getId()).toString());
                jsonSchema = SimpleObjectHandler.INSTANCE.handle(type, clazz, cache, schemaConfigurator, null);
            }
        }
        return jsonSchema;
    }
}

