/*
 * Decompiled with CFR 0.152.
 */
package io.bkbn.kompendium.json.schema.handler;

import io.bkbn.kompendium.enrichment.CollectionEnrichment;
import io.bkbn.kompendium.enrichment.Enrichment;
import io.bkbn.kompendium.json.schema.SchemaConfigurator;
import io.bkbn.kompendium.json.schema.SchemaGenerator;
import io.bkbn.kompendium.json.schema.definition.ArrayDefinition;
import io.bkbn.kompendium.json.schema.definition.EnumDefinition;
import io.bkbn.kompendium.json.schema.definition.JsonSchema;
import io.bkbn.kompendium.json.schema.definition.NullableDefinition;
import io.bkbn.kompendium.json.schema.definition.OneOfDefinition;
import io.bkbn.kompendium.json.schema.definition.ReferenceDefinition;
import io.bkbn.kompendium.json.schema.definition.TypeDefinition;
import io.bkbn.kompendium.json.schema.util.Helpers;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lio/bkbn/kompendium/json/schema/handler/CollectionHandler;", "", "<init>", "()V", "handle", "Lio/bkbn/kompendium/json/schema/definition/JsonSchema;", "type", "Lkotlin/reflect/KType;", "cache", "", "", "schemaConfigurator", "Lio/bkbn/kompendium/json/schema/SchemaConfigurator;", "enrichment", "Lio/bkbn/kompendium/enrichment/CollectionEnrichment;", "solibo-kompendium-json-schema"})
public final class CollectionHandler {
    @NotNull
    public static final CollectionHandler INSTANCE = new CollectionHandler();

    private CollectionHandler() {
    }

    @NotNull
    public final JsonSchema handle(@NotNull KType type, @NotNull Map<String, JsonSchema> cache, @NotNull SchemaConfigurator schemaConfigurator, @Nullable CollectionEnrichment<?> enrichment) {
        JsonSchema jsonSchema;
        JsonSchema jsonSchema2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)schemaConfigurator, (String)"schemaConfigurator");
        if (enrichment == null) {
            // empty if block
        }
        KType kType = ((KTypeProjection)CollectionsKt.first((List)type.getArguments())).getType();
        if (kType == null) {
            throw new IllegalStateException("This indicates a bug in Kompendium, please open a GitHub issue!".toString());
        }
        KType collectionType = kType;
        CollectionEnrichment<?> collectionEnrichment = enrichment;
        JsonSchema it = SchemaGenerator.INSTANCE.fromTypeToSchema(collectionType, cache, schemaConfigurator, (Enrichment)(collectionEnrichment != null ? collectionEnrichment.getItemEnrichment() : null));
        boolean bl = false;
        if (it instanceof TypeDefinition && Intrinsics.areEqual((Object)((TypeDefinition)it).getType(), (Object)"object") || it instanceof EnumDefinition) {
            cache.put(Helpers.INSTANCE.getSlug(collectionType, (Enrichment)enrichment), it);
            jsonSchema2 = new ReferenceDefinition(Helpers.INSTANCE.getReferenceSlug(collectionType, (Enrichment)enrichment), null, null, 6, null);
        } else {
            jsonSchema2 = it;
        }
        JsonSchema typeSchema = jsonSchema2;
        ArrayDefinition definition = new ArrayDefinition(typeSchema, null, null, null, null, null, 62, null);
        boolean bl2 = type.isMarkedNullable();
        if (bl2) {
            JsonSchema[] jsonSchemaArray = new JsonSchema[]{definition, new NullableDefinition(null, null, null, 7, null)};
            jsonSchema = new OneOfDefinition(jsonSchemaArray);
        } else if (!bl2) {
            jsonSchema = definition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonSchema;
    }

    public static /* synthetic */ JsonSchema handle$default(CollectionHandler collectionHandler, KType kType, Map map, SchemaConfigurator schemaConfigurator, CollectionEnrichment collectionEnrichment, int n, Object object) {
        if ((n & 8) != 0) {
            collectionEnrichment = null;
        }
        return collectionHandler.handle(kType, map, schemaConfigurator, collectionEnrichment);
    }
}

