/*
 * Decompiled with CFR 0.152.
 */
package io.bkbn.kompendium.json.schema.handler;

import io.bkbn.kompendium.enrichment.BooleanEnrichment;
import io.bkbn.kompendium.enrichment.CollectionEnrichment;
import io.bkbn.kompendium.enrichment.Enrichment;
import io.bkbn.kompendium.enrichment.MapEnrichment;
import io.bkbn.kompendium.enrichment.NumberEnrichment;
import io.bkbn.kompendium.enrichment.ObjectEnrichment;
import io.bkbn.kompendium.enrichment.StringEnrichment;
import io.bkbn.kompendium.json.schema.definition.ArrayDefinition;
import io.bkbn.kompendium.json.schema.definition.JsonSchema;
import io.bkbn.kompendium.json.schema.definition.MapDefinition;
import io.bkbn.kompendium.json.schema.definition.ReferenceDefinition;
import io.bkbn.kompendium.json.schema.definition.TypeDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0005J\u0018\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0018\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0018\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0014\u0010\u0011\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0014\u0010\u0012\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a8\u0006\u0017"}, d2={"Lio/bkbn/kompendium/json/schema/handler/EnrichmentHandler;", "", "<init>", "()V", "applyToSchema", "Lio/bkbn/kompendium/json/schema/definition/JsonSchema;", "Lio/bkbn/kompendium/enrichment/Enrichment;", "schema", "Lio/bkbn/kompendium/enrichment/ObjectEnrichment;", "Lio/bkbn/kompendium/enrichment/MapEnrichment;", "Lio/bkbn/kompendium/enrichment/CollectionEnrichment;", "Lio/bkbn/kompendium/enrichment/BooleanEnrichment;", "Lio/bkbn/kompendium/enrichment/NumberEnrichment;", "Lio/bkbn/kompendium/enrichment/StringEnrichment;", "copyBooleanEnrichment", "Lio/bkbn/kompendium/json/schema/definition/TypeDefinition;", "enrichment", "copyNumberEnrichment", "copyStringEnrichment", "copyArrayEnrichment", "Lio/bkbn/kompendium/json/schema/definition/ArrayDefinition;", "copyMapEnrichment", "Lio/bkbn/kompendium/json/schema/definition/MapDefinition;", "solibo-kompendium-json-schema"})
public final class EnrichmentHandler {
    @NotNull
    public static final EnrichmentHandler INSTANCE = new EnrichmentHandler();

    private EnrichmentHandler() {
    }

    @NotNull
    public final JsonSchema applyToSchema(@NotNull Enrichment $this$applyToSchema, @NotNull JsonSchema schema) {
        JsonSchema jsonSchema;
        Intrinsics.checkNotNullParameter((Object)$this$applyToSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Enrichment enrichment = $this$applyToSchema;
        if (enrichment instanceof BooleanEnrichment) {
            jsonSchema = this.applyToSchema((BooleanEnrichment)$this$applyToSchema, schema);
        } else if (enrichment instanceof NumberEnrichment) {
            jsonSchema = this.applyToSchema((NumberEnrichment)$this$applyToSchema, schema);
        } else if (enrichment instanceof StringEnrichment) {
            jsonSchema = this.applyToSchema((StringEnrichment)$this$applyToSchema, schema);
        } else if (enrichment instanceof CollectionEnrichment) {
            jsonSchema = this.applyToSchema((CollectionEnrichment)$this$applyToSchema, schema);
        } else if (enrichment instanceof MapEnrichment) {
            jsonSchema = this.applyToSchema((MapEnrichment)$this$applyToSchema, schema);
        } else if (enrichment instanceof ObjectEnrichment) {
            jsonSchema = this.applyToSchema((ObjectEnrichment)$this$applyToSchema, schema);
        } else {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return jsonSchema;
    }

    private final JsonSchema applyToSchema(ObjectEnrichment<?> $this$applyToSchema, JsonSchema schema) {
        JsonSchema jsonSchema;
        JsonSchema jsonSchema2 = schema;
        if (jsonSchema2 instanceof TypeDefinition) {
            jsonSchema = TypeDefinition.copy$default((TypeDefinition)schema, null, null, null, null, null, $this$applyToSchema.getDeprecated(), $this$applyToSchema.getDescription(), null, null, null, null, null, null, null, null, null, null, null, null, 524191, null);
        } else if (jsonSchema2 instanceof ReferenceDefinition) {
            jsonSchema = ReferenceDefinition.copy$default((ReferenceDefinition)schema, null, $this$applyToSchema.getDeprecated(), $this$applyToSchema.getDescription(), 1, null);
        } else {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return jsonSchema;
    }

    private final JsonSchema applyToSchema(MapEnrichment<?> $this$applyToSchema, JsonSchema schema) {
        if (!(schema instanceof MapDefinition)) {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return this.copyMapEnrichment((MapDefinition)schema, $this$applyToSchema);
    }

    private final JsonSchema applyToSchema(CollectionEnrichment<?> $this$applyToSchema, JsonSchema schema) {
        if (!(schema instanceof ArrayDefinition)) {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return this.copyArrayEnrichment((ArrayDefinition)schema, $this$applyToSchema);
    }

    private final JsonSchema applyToSchema(BooleanEnrichment $this$applyToSchema, JsonSchema schema) {
        if (!(schema instanceof TypeDefinition)) {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return this.copyBooleanEnrichment((TypeDefinition)schema, $this$applyToSchema);
    }

    private final JsonSchema applyToSchema(NumberEnrichment $this$applyToSchema, JsonSchema schema) {
        if (!(schema instanceof TypeDefinition)) {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return this.copyNumberEnrichment((TypeDefinition)schema, $this$applyToSchema);
    }

    private final JsonSchema applyToSchema(StringEnrichment $this$applyToSchema, JsonSchema schema) {
        if (!(schema instanceof TypeDefinition)) {
            throw new IllegalStateException(("Incorrect enrichment type for enrichment id: " + $this$applyToSchema.getId()).toString());
        }
        return this.copyStringEnrichment((TypeDefinition)schema, $this$applyToSchema);
    }

    private final TypeDefinition copyBooleanEnrichment(TypeDefinition $this$copyBooleanEnrichment, BooleanEnrichment enrichment) {
        return TypeDefinition.copy$default($this$copyBooleanEnrichment, null, null, null, null, null, enrichment.getDeprecated(), enrichment.getDescription(), null, null, null, null, null, null, null, null, null, null, null, null, 524191, null);
    }

    private final TypeDefinition copyNumberEnrichment(TypeDefinition $this$copyNumberEnrichment, NumberEnrichment enrichment) {
        return TypeDefinition.copy$default($this$copyNumberEnrichment, null, null, null, null, null, enrichment.getDeprecated(), enrichment.getDescription(), enrichment.getMultipleOf(), enrichment.getMaximum(), enrichment.getExclusiveMaximum(), enrichment.getMinimum(), enrichment.getExclusiveMinimum(), null, null, null, null, null, null, null, 520223, null);
    }

    private final TypeDefinition copyStringEnrichment(TypeDefinition $this$copyStringEnrichment, StringEnrichment enrichment) {
        return TypeDefinition.copy$default($this$copyStringEnrichment, null, null, null, null, null, enrichment.getDeprecated(), enrichment.getDescription(), null, null, null, null, null, enrichment.getMaxLength(), enrichment.getMinLength(), enrichment.getPattern(), enrichment.getContentEncoding(), enrichment.getContentMediaType(), null, null, 397215, null);
    }

    private final ArrayDefinition copyArrayEnrichment(ArrayDefinition $this$copyArrayEnrichment, CollectionEnrichment<?> enrichment) {
        Boolean bl = enrichment.getDeprecated();
        String string = enrichment.getDescription();
        Integer n = enrichment.getMinItems();
        Integer n2 = enrichment.getMaxItems();
        Boolean bl2 = enrichment.getUniqueItems();
        return ArrayDefinition.copy$default($this$copyArrayEnrichment, null, bl, string, n2, n, bl2, 1, null);
    }

    private final MapDefinition copyMapEnrichment(MapDefinition $this$copyMapEnrichment, MapEnrichment<?> enrichment) {
        Boolean bl = enrichment.getDeprecated();
        String string = enrichment.getDescription();
        Integer n = enrichment.getMinProperties();
        Integer n2 = enrichment.getMaxProperties();
        return MapDefinition.copy$default($this$copyMapEnrichment, null, n2, n, bl, string, 1, null);
    }
}

