/*
 * Decompiled with CFR 0.152.
 */
package no.solibo.oss.vertx.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.ReadStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import no.solibo.oss.vertx.client.converters.MethodConverter;
import no.solibo.oss.vertx.client.reactivestreams.HttpClientRequestSubscriber;
import no.solibo.oss.vertx.client.reactivestreams.ReadStreamPublisher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.StringUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lno/solibo/oss/vertx/client/VertxNioAsyncHttpClient;", "Lsoftware/amazon/awssdk/http/async/SdkAsyncHttpClient;", "context", "Lio/vertx/core/Context;", "<init>", "(Lio/vertx/core/Context;)V", "clientOptions", "Lio/vertx/core/http/HttpClientOptions;", "(Lio/vertx/core/Context;Lio/vertx/core/http/HttpClientOptions;)V", "client", "Lio/vertx/core/http/HttpClient;", "createVertxHttpClient", "vertx", "Lio/vertx/core/Vertx;", "execute", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "asyncExecuteRequest", "Lsoftware/amazon/awssdk/http/async/AsyncExecuteRequest;", "executeOnContext", "", "fut", "close", "Companion", "solibo-vertx-aws-sdk"})
public class VertxNioAsyncHttpClient
implements SdkAsyncHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final HttpClient client;
    @Nullable
    private final HttpClientOptions clientOptions;
    @Nullable
    private static final HttpClientOptions DEFAULT_CLIENT_OPTIONS = new HttpClientOptions().setSsl(true).setKeepAlive(true);

    public VertxNioAsyncHttpClient(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.clientOptions = DEFAULT_CLIENT_OPTIONS;
        Vertx vertx = context.owner();
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"owner(...)");
        this.client = this.createVertxHttpClient(vertx);
    }

    public VertxNioAsyncHttpClient(@NotNull Context context, @Nullable HttpClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Objects.requireNonNull(clientOptions);
        this.context = context;
        this.clientOptions = clientOptions;
        Vertx vertx = context.owner();
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"owner(...)");
        this.client = this.createVertxHttpClient(vertx);
    }

    private final HttpClient createVertxHttpClient(Vertx vertx) {
        HttpClientAgent httpClientAgent = vertx.createHttpClient(this.clientOptions);
        Intrinsics.checkNotNullExpressionValue((Object)httpClientAgent, (String)"createHttpClient(...)");
        return (HttpClient)httpClientAgent;
    }

    @NotNull
    public CompletableFuture<Void> execute(@NotNull AsyncExecuteRequest asyncExecuteRequest) {
        Intrinsics.checkNotNullParameter((Object)asyncExecuteRequest, (String)"asyncExecuteRequest");
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        if (Context.isOnEventLoopThread()) {
            this.executeOnContext(asyncExecuteRequest, fut);
        } else {
            this.context.runOnContext(arg_0 -> VertxNioAsyncHttpClient.execute$lambda$0(this, asyncExecuteRequest, fut, arg_0));
        }
        return fut;
    }

    public void executeOnContext(@NotNull AsyncExecuteRequest asyncExecuteRequest, @NotNull CompletableFuture<Void> fut) {
        Intrinsics.checkNotNullParameter((Object)asyncExecuteRequest, (String)"asyncExecuteRequest");
        Intrinsics.checkNotNullParameter(fut, (String)"fut");
        SdkHttpRequest request = asyncExecuteRequest.request();
        SdkAsyncHttpResponseHandler responseHandler = asyncExecuteRequest.responseHandler();
        Intrinsics.checkNotNull((Object)request);
        RequestOptions options = VertxNioAsyncHttpClient.Companion.getRequestOptions(request);
        this.client.request(options).onComplete(arg_0 -> VertxNioAsyncHttpClient.executeOnContext$lambda$3(responseHandler, asyncExecuteRequest, fut, arg_0));
    }

    public void close() {
        this.client.close();
    }

    private static final void execute$lambda$0(VertxNioAsyncHttpClient this$0, AsyncExecuteRequest $asyncExecuteRequest, CompletableFuture $fut, Void v) {
        this$0.executeOnContext($asyncExecuteRequest, $fut);
    }

    private static final void executeOnContext$lambda$3$lambda$2$lambda$1(SdkHttpFullResponse.Builder $builder, Map.Entry e) {
        Map.Entry entry = e;
        Intrinsics.checkNotNull((Object)entry);
        $builder.appendHeader((String)entry.getKey(), (String)e.getValue());
    }

    private static final void executeOnContext$lambda$3$lambda$2(SdkAsyncHttpResponseHandler $responseHandler, CompletableFuture $fut, AsyncResult res) {
        if (res.failed()) {
            $responseHandler.onError(res.cause());
            $fut.completeExceptionally(res.cause());
        }
        Object object = res.result();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result(...)");
        HttpClientResponse vResponse = (HttpClientResponse)object;
        SdkHttpFullResponse.Builder builder = SdkHttpResponse.builder().statusCode(vResponse.statusCode()).statusText(vResponse.statusMessage());
        vResponse.headers().forEach(arg_0 -> VertxNioAsyncHttpClient.executeOnContext$lambda$3$lambda$2$lambda$1(builder, arg_0));
        $responseHandler.onHeaders((SdkHttpResponse)builder.build());
        $responseHandler.onStream((Publisher)new ReadStreamPublisher((ReadStream)vResponse, $fut));
    }

    private static final void executeOnContext$lambda$3(SdkAsyncHttpResponseHandler $responseHandler, AsyncExecuteRequest $asyncExecuteRequest, CompletableFuture $fut, AsyncResult ar) {
        if (ar.failed()) {
            $responseHandler.onError(ar.cause());
        } else {
            Object object = ar.result();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result(...)");
            HttpClientRequest vRequest = (HttpClientRequest)object;
            vRequest.response().onComplete(arg_0 -> VertxNioAsyncHttpClient.executeOnContext$lambda$3$lambda$2($responseHandler, $fut, arg_0));
            SdkHttpContentPublisher publisher = $asyncExecuteRequest.requestContentPublisher();
            if (publisher != null) {
                publisher.subscribe((Subscriber)new HttpClientRequestSubscriber(vRequest));
            } else {
                vRequest.end();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lno/solibo/oss/vertx/client/VertxNioAsyncHttpClient$Companion;", "", "<init>", "()V", "DEFAULT_CLIENT_OPTIONS", "Lio/vertx/core/http/HttpClientOptions;", "getRequestOptions", "Lio/vertx/core/http/RequestOptions;", "request", "Lsoftware/amazon/awssdk/http/SdkHttpRequest;", "createRelativeUri", "", "uri", "Ljava/net/URI;", "solibo-vertx-aws-sdk"})
    @SourceDebugExtension(value={"SMAP\nVertxNioAsyncHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertxNioAsyncHttpClient.kt\nno/solibo/oss/vertx/client/VertxNioAsyncHttpClient$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n216#2,2:152\n739#3,9:154\n37#4:163\n36#4,3:164\n*S KotlinDebug\n*F\n+ 1 VertxNioAsyncHttpClient.kt\nno/solibo/oss/vertx/client/VertxNioAsyncHttpClient$Companion\n*L\n120#1:152,2\n145#1:154,9\n146#1:163\n146#1:164,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final RequestOptions getRequestOptions(SdkHttpRequest request) {
            RequestOptions requestOptions = new RequestOptions().setMethod(MethodConverter.INSTANCE.awsToVertx(request.method())).setHost(request.host()).setPort(Integer.valueOf(request.port()));
            URI uRI = request.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"getUri(...)");
            RequestOptions options = requestOptions.setURI(this.createRelativeUri(uRI)).setFollowRedirects(Boolean.valueOf(true)).setSsl(Boolean.valueOf(Intrinsics.areEqual((Object)"https", (Object)request.protocol())));
            Map map = request.headers();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"headers(...)");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                CharSequence charSequence = name;
                List list = values;
                Intrinsics.checkNotNull((Object)list);
                options.addHeader(charSequence, (Iterable)list.stream().map(arg_0 -> Companion.getRequestOptions$lambda$2$lambda$1(Companion::getRequestOptions$lambda$2$lambda$0, arg_0)).collect(Collectors.toList()));
            }
            options.addHeader(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
            Intrinsics.checkNotNull((Object)options);
            return options;
        }

        /*
         * WARNING - void declaration
         */
        private final String createRelativeUri(URI uri) {
            Object object;
            String string = StringUtils.isEmpty((CharSequence)uri.getPath()) ? "/" : uri.getPath();
            if (StringUtils.isEmpty((CharSequence)uri.getQuery())) {
                object = "";
            } else {
                List list;
                void $this$dropLastWhile$iv;
                String string2 = uri.toASCIIString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toASCIIString(...)");
                Object object2 = string2;
                Regex regex = new Regex("\\?");
                int n = 0;
                object2 = regex.split((CharSequence)object2, n);
                String string3 = string;
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                string = string3;
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                object = "?" + thisCollection$iv.toArray(new String[0])[1];
            }
            return string + (String)object;
        }

        private static final CharSequence getRequestOptions$lambda$2$lambda$0(String s) {
            return s;
        }

        private static final CharSequence getRequestOptions$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            return (CharSequence)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

