/*
 * Decompiled with CFR 0.152.
 */
package no.solibo.oss.vertx.client.reactivestreams;

import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b*\u0012\b\u0000\u0010\u0001*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004:\u0001\u001bB\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0007\u0010\bB+\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\bR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lno/solibo/oss/vertx/client/reactivestreams/WriteStreamSubscriber;", "T", "Lio/vertx/core/streams/WriteStream;", "Lio/vertx/core/buffer/Buffer;", "Lorg/reactivestreams/Subscriber;", "Ljava/nio/ByteBuffer;", "stream", "<init>", "(Lio/vertx/core/streams/WriteStream;)V", "cf", "Ljava/util/concurrent/CompletableFuture;", "(Lio/vertx/core/streams/WriteStream;Ljava/util/concurrent/CompletableFuture;)V", "getStream", "()Lio/vertx/core/streams/WriteStream;", "setStream", "Lio/vertx/core/streams/WriteStream;", "subscription", "Lorg/reactivestreams/Subscription;", "Ljava/util/Optional;", "onSubscribe", "", "onNext", "byteBuffer", "onError", "t", "", "onComplete", "Companion", "solibo-vertx-aws-sdk"})
public class WriteStreamSubscriber<T extends WriteStream<Buffer>>
implements Subscriber<ByteBuffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private T stream;
    @Nullable
    private Subscription subscription;
    @NotNull
    private final Optional<CompletableFuture<WriteStream<Buffer>>> cf;
    protected static final long BUFF_SIZE = 1024L;

    @Nullable
    protected final T getStream() {
        return this.stream;
    }

    protected final void setStream(@Nullable T t) {
        this.stream = t;
    }

    public WriteStreamSubscriber(@Nullable T stream) {
        this.stream = stream;
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.cf = optional;
    }

    public WriteStreamSubscriber(@Nullable T stream, @NotNull CompletableFuture<WriteStream<Buffer>> cf) {
        Intrinsics.checkNotNullParameter(cf, (String)"cf");
        this.stream = stream;
        Optional<CompletableFuture<WriteStream<Buffer>>> optional = Optional.of(cf);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        this.cf = optional;
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        this.subscription = subscription;
        subscription.request(1024L);
    }

    public void onNext(@Nullable ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        boolean bl = byteBuffer2 != null ? byteBuffer2.hasRemaining() : false;
        if (bl) {
            Buffer buffer = Buffer.buffer((byte[])Unpooled.wrappedBuffer((ByteBuffer)byteBuffer).array());
            T t = this.stream;
            Intrinsics.checkNotNull(t);
            t.write((Object)buffer);
        }
        Subscription subscription = this.subscription;
        Intrinsics.checkNotNull((Object)subscription);
        subscription.request(1024L);
    }

    public void onError(@Nullable Throwable t) {
        Subscription subscription = this.subscription;
        Intrinsics.checkNotNull((Object)subscription);
        subscription.cancel();
    }

    public void onComplete() {
        T t = this.stream;
        Intrinsics.checkNotNull(t);
        t.end();
        this.cf.map(arg_0 -> WriteStreamSubscriber.onComplete$lambda$0(this, arg_0));
    }

    private static final Boolean onComplete$lambda$0(WriteStreamSubscriber this$0, CompletableFuture fut) {
        CompletableFuture completableFuture = fut;
        Intrinsics.checkNotNull((Object)completableFuture);
        return completableFuture.complete(this$0.stream);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lno/solibo/oss/vertx/client/reactivestreams/WriteStreamSubscriber$Companion;", "", "<init>", "()V", "BUFF_SIZE", "", "solibo-vertx-aws-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

