/*
 * Decompiled with CFR 0.152.
 */
package no.sysco.middleware.alpakka.zeromq.javadsl.internal;

import akka.stream.Shape;
import akka.stream.stage.GraphStageLogic;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public abstract class ZmqStageLogic
extends GraphStageLogic {
    private final ZContext zContext;
    private final ZMQ.Socket socket;
    private final String addresses;

    ZmqStageLogic(Shape shape, String addresses, int socketType) {
        super(shape);
        this.addresses = addresses;
        this.zContext = new ZContext();
        this.socket = this.zContext.createSocket(socketType);
    }

    public void preStart() throws Exception {
        super.preStart();
    }

    public void postStop() throws Exception {
        this.zContext.destroy();
        super.postStop();
    }

    ZMQ.Socket socket() {
        return this.socket;
    }

    String getAddresses() {
        return this.addresses;
    }

    public static class ServerStageLogic
    extends ZmqStageLogic {
        ServerStageLogic(Shape shape, String addresses, int socketType) {
            super(shape, addresses, socketType);
        }

        @Override
        public void preStart() throws Exception {
            super.preStart();
            this.socket().bind(this.getAddresses());
        }

        @Override
        public void postStop() throws Exception {
            this.socket().close();
            super.postStop();
        }
    }

    public static class ClientStageLogic
    extends ZmqStageLogic {
        ClientStageLogic(Shape shape, String addresses, int socketType) {
            super(shape, addresses, socketType);
        }

        @Override
        public void preStart() throws Exception {
            super.preStart();
            this.socket().connect(this.getAddresses());
        }

        @Override
        public void postStop() throws Exception {
            this.socket().close();
            super.postStop();
        }
    }
}

