package no.tornado.databinding.support.jodatime;

import no.tornado.databinding.converter.ConversionException;
import no.tornado.databinding.converter.Converter;
import org.joda.time.DateTime;

import java.util.Date;

public class DateTimeToDateConverter implements Converter<DateTime, Date> {
    public static final DateTimeToDateConverter INSTANCE = new DateTimeToDateConverter();

    public Date convertForward(DateTime value) throws ConversionException {
        return value.toDate();
    }

    public DateTime convertReverse(Date value) throws ConversionException {
        return new DateTime(value);
    }
}
