package no.tornado.databinding.support.jodatime;

import no.tornado.databinding.converter.Converter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/**
 * To change the format, override formatter created via DatetimeFormatter.withLocale(locale) or similar
 */
public class DateTimeToStringConverter implements Converter<DateTime, String> {
    public static final DateTimeZone defaultTimeZone = DateTimeZone.getDefault();
    public static final DateTimeToStringConverter INSTANCE = new DateTimeToStringConverter();
    public static DateTimeFormatter formatter = DateTimeFormat.fullDateTime();

    public String convertForward(DateTime value) {
        if (value == null)
            return null;

        if (!value.getZone().equals(defaultTimeZone))
            value = value.toDateTime(defaultTimeZone);

        return value.toString(formatter);
    }

    public DateTime convertReverse(String value) {
        if (value == null || "".equals(value)) return null;
        return formatter.parseDateTime(value);
    }
}
