/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.sun.javafx.application.ParametersImpl;
import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.JAXB;

public class CreateManifest {
    public static void main(String[] args) throws IOException {
        URI baseURI = URI.create(args[0]);
        String launchClass = args[1];
        Path appPath = Paths.get(args[2], new String[0]);
        FXManifest manifest = CreateManifest.create(baseURI, launchClass, appPath);
        if (args.length > 3) {
            ArrayList<String> rawParams = new ArrayList<String>();
            rawParams.addAll(Arrays.asList(args).subList(3, args.length));
            ParametersImpl params = new ParametersImpl(rawParams);
            Map named = params.getNamed();
            if (named != null && named.containsKey("cache-dir")) {
                manifest.cacheDir = (String)named.get("cache-dir");
            }
            StringBuilder rest = new StringBuilder();
            for (String raw : params.getRaw()) {
                if (raw.startsWith("--cache-dir=")) continue;
                if (rest.length() > 0) {
                    rest.append(" ");
                }
                rest.append(raw);
            }
            if (rest.length() > 0) {
                manifest.parameters = rest.toString();
            }
        }
        JAXB.marshal((Object)manifest, (File)appPath.resolve("app.xml").toFile());
    }

    public static FXManifest create(URI baseURI, String launchClass, final Path appPath) throws IOException {
        final FXManifest manifest = new FXManifest();
        manifest.uri = baseURI;
        manifest.launchClass = launchClass;
        Files.walkFileTree(appPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0]) && file.toString().endsWith(".jar") && !file.getFileName().toString().startsWith("fxlauncher")) {
                    manifest.files.add(new LibraryFile(appPath, file));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return manifest;
    }
}

