/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.LibraryFile;
import fxlauncher.OS;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Application")
public class FXManifest {
    @XmlAttribute
    URI uri;
    @XmlAttribute(name="launch")
    String launchClass;
    @XmlElement(name="lib")
    List<LibraryFile> files = new ArrayList<LibraryFile>();
    @XmlElement
    String updateText = "Updating...";
    @XmlElement
    String updateLabelStyle = "-fx-font-weight: bold;";
    @XmlElement
    String progressBarStyle = "-fx-pref-width: 200;";
    @XmlElement
    String wrapperStyle = "-fx-spacing: 10; -fx-padding: 25;";
    @XmlElement
    String parameters;
    @XmlElement
    String cacheDir;

    public String getFilename() {
        return String.format("%s.xml", this.launchClass);
    }

    public URI getFXAppURI() {
        if (this.uri.getPath().endsWith("/")) {
            return this.uri.resolve("app.xml");
        }
        return URI.create(this.uri.toString() + "/app.xml");
    }

    public Path getPath(Path cacheDir) {
        return cacheDir.resolve(this.getFilename());
    }

    public Path resolveCacheDir(Map<String, String> namedParams) {
        Path path;
        String cacheDir;
        if (namedParams == null) {
            namedParams = Collections.emptyMap();
        }
        String string = cacheDir = namedParams.containsKey("cache-dir") ? namedParams.get("cache-dir") : this.cacheDir;
        if (cacheDir == null || cacheDir.isEmpty()) {
            return Paths.get(".", new String[0]);
        }
        if (cacheDir.contains("USERLIB")) {
            String replacement;
            switch (OS.current) {
                case mac: {
                    replacement = Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library").resolve("Application Support").resolve(cacheDir.substring(8)).toString();
                    break;
                }
                case win: {
                    replacement = Paths.get(System.getProperty("user.home"), new String[0]).resolve("AppData").resolve(cacheDir.substring(8)).toString();
                    break;
                }
                default: {
                    replacement = Paths.get(System.getProperty("user.home"), new String[0]).resolve("." + cacheDir.substring(8)).toString();
                }
            }
            path = Paths.get(replacement, new String[0]);
        } else {
            path = Paths.get(cacheDir, new String[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FXManifest that = (FXManifest)o;
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.launchClass != null ? !this.launchClass.equals(that.launchClass) : that.launchClass != null) {
            return false;
        }
        if (this.files != null ? !this.files.equals(that.files) : that.files != null) {
            return false;
        }
        if (this.updateText != null ? !this.updateText.equals(that.updateText) : that.updateText != null) {
            return false;
        }
        if (this.updateLabelStyle != null ? !this.updateLabelStyle.equals(that.updateLabelStyle) : that.updateLabelStyle != null) {
            return false;
        }
        if (this.progressBarStyle != null ? !this.progressBarStyle.equals(that.progressBarStyle) : that.progressBarStyle != null) {
            return false;
        }
        return this.wrapperStyle != null ? this.wrapperStyle.equals(that.wrapperStyle) : that.wrapperStyle == null;
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.launchClass != null ? this.launchClass.hashCode() : 0);
        result = 31 * result + (this.files != null ? this.files.hashCode() : 0);
        result = 31 * result + (this.updateText != null ? this.updateText.hashCode() : 0);
        result = 31 * result + (this.updateLabelStyle != null ? this.updateLabelStyle.hashCode() : 0);
        result = 31 * result + (this.progressBarStyle != null ? this.progressBarStyle.hashCode() : 0);
        result = 31 * result + (this.wrapperStyle != null ? this.wrapperStyle.hashCode() : 0);
        return result;
    }
}

