/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.sun.javafx.application.ParametersImpl;
import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;

public class CreateManifest {
    private static ArrayList<String> includeExtensions = new ArrayList();

    public static void main(String[] args) throws IOException {
        URI baseURI = URI.create(args[0]);
        String launchClass = args[1];
        Path appPath = Paths.get(args[2], new String[0]);
        String cacheDir = null;
        Boolean acceptDowngrade = null;
        String parameters = null;
        if (args.length > 3) {
            ArrayList<String> rawParams = new ArrayList<String>();
            rawParams.addAll(Arrays.asList(args).subList(3, args.length));
            ParametersImpl params = new ParametersImpl(rawParams);
            Map named = params.getNamed();
            if (named != null) {
                if (named.containsKey("cache-dir")) {
                    cacheDir = (String)named.get("cache-dir");
                }
                if (named.containsKey("accept-downgrade")) {
                    acceptDowngrade = Boolean.valueOf((String)named.get("accept-downgrade"));
                }
                if (named.containsKey("include-extensions")) {
                    includeExtensions.addAll(Arrays.stream(((String)named.get("include-extensions")).split(",")).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList()));
                }
            }
            StringBuilder rest = new StringBuilder();
            for (String raw : params.getRaw()) {
                if (raw.startsWith("--cache-dir=") || raw.startsWith("--accept-downgrade=") || raw.startsWith("--include-extensions=")) continue;
                if (rest.length() > 0) {
                    rest.append(" ");
                }
                rest.append(raw);
            }
            if (rest.length() > 0) {
                parameters = rest.toString();
            }
        }
        FXManifest manifest = CreateManifest.create(baseURI, launchClass, appPath);
        if (cacheDir != null) {
            manifest.cacheDir = cacheDir;
        }
        if (acceptDowngrade != null) {
            manifest.acceptDowngrade = acceptDowngrade;
        }
        if (parameters != null) {
            manifest.parameters = parameters;
        }
        JAXB.marshal((Object)manifest, (File)appPath.resolve("app.xml").toFile());
    }

    public static FXManifest create(URI baseURI, String launchClass, final Path appPath) throws IOException {
        final FXManifest manifest = new FXManifest();
        manifest.ts = System.currentTimeMillis();
        manifest.uri = baseURI;
        manifest.launchClass = launchClass;
        Files.walkFileTree(appPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0]) && CreateManifest.shouldIncludeInManifest(file) && !file.getFileName().toString().startsWith("fxlauncher")) {
                    manifest.files.add(new LibraryFile(appPath, file));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return manifest;
    }

    private static boolean shouldIncludeInManifest(Path file) {
        String filename = file.getFileName().toString();
        for (String ext : includeExtensions) {
            if (!filename.toLowerCase().endsWith(String.format(".%s", ext.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    static {
        includeExtensions.addAll(Arrays.asList("jar", "war"));
    }
}

