/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import fxlauncher.DefaultUIProvider;
import fxlauncher.FXManifest;
import fxlauncher.LauncherParams;
import fxlauncher.LibraryFile;
import fxlauncher.UIProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.xml.bind.JAXB;

public class Launcher
extends Application {
    private static final Logger log = Logger.getLogger("Launcher");
    private FXManifest manifest;
    private Application app;
    private Stage primaryStage;
    private Stage stage;
    private String phase;
    private UIProvider uiProvider;
    private StackPane root;

    public void init() throws Exception {
        Iterator<UIProvider> providers = ServiceLoader.load(UIProvider.class).iterator();
        this.uiProvider = providers.hasNext() ? providers.next() : new DefaultUIProvider();
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.stage = new Stage(StageStyle.UNDECORATED);
        this.root = new StackPane();
        Scene scene = new Scene((Parent)this.root);
        this.stage.setScene(scene);
        this.uiProvider.init(this.stage);
        this.root.getChildren().add((Object)this.uiProvider.createLoader());
        this.stage.show();
        new Thread(() -> {
            Thread.currentThread().setName("FXLauncher-Thread");
            try {
                this.updateManifest();
                this.createUpdateWrapper();
                Path cacheDir = this.manifest.resolveCacheDir(this.getParameters().getNamed());
                log.info(String.format("Using cache dir %s", cacheDir));
                this.syncFiles(cacheDir);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, String.format("Error during %s phase", this.phase), ex);
            }
            try {
                this.createApplication();
                this.launchAppFromManifest();
            }
            catch (Exception ex) {
                this.reportError(String.format("Error during %s phase", this.phase), ex);
            }
        }).start();
    }

    public static void main(String[] args) {
        Launcher.launch((String[])args);
    }

    private void createUpdateWrapper() {
        this.phase = "Update Wrapper Creation";
        Platform.runLater(() -> {
            Parent updater = this.uiProvider.createUpdater(this.manifest);
            this.root.getChildren().clear();
            this.root.getChildren().add((Object)updater);
        });
    }

    private URLClassLoader createClassLoader(Path cacheDir) {
        List<URL> libs = this.manifest.files.stream().filter(LibraryFile::loadForCurrentPlatform).map(it -> it.toURL(cacheDir)).collect(Collectors.toList());
        return new URLClassLoader(libs.toArray(new URL[libs.size()]));
    }

    private void launchAppFromManifest() throws Exception {
        this.phase = "Application Init";
        this.app.init();
        this.phase = "Application Start";
        PlatformImpl.runAndWait(() -> {
            try {
                this.primaryStage.showingProperty().addListener(observable -> {
                    if (this.stage.isShowing()) {
                        this.stage.close();
                    }
                });
                this.app.start(this.primaryStage);
            }
            catch (Exception ex) {
                this.reportError("Failed to start application", ex);
            }
        });
    }

    private void updateManifest() throws Exception {
        this.phase = "Update Manifest";
        this.syncManifest();
    }

    private void syncFiles(Path cacheDir) throws Exception {
        this.phase = "File Synchronization";
        List needsUpdate = this.manifest.files.stream().filter(LibraryFile::loadForCurrentPlatform).filter(it -> it.needsUpdate(cacheDir)).collect(Collectors.toList());
        Long totalBytes = needsUpdate.stream().mapToLong(f -> f.size).sum();
        Long totalWritten = 0L;
        for (LibraryFile lib : needsUpdate) {
            Path target = cacheDir.resolve(lib.file).toAbsolutePath();
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            URI uri = this.manifest.uri.resolve(lib.file);
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            if (uri.getUserInfo() != null) {
                byte[] payload = uri.getUserInfo().getBytes(StandardCharsets.UTF_8);
                String encoded = Base64.getEncoder().encodeToString(payload);
                connection.setRequestProperty("Authorization", String.format("Basic %s", encoded));
            }
            InputStream input = connection.getInputStream();
            Throwable throwable = null;
            try {
                OutputStream output = Files.newOutputStream(target, new OpenOption[0]);
                Throwable throwable2 = null;
                try {
                    int read;
                    byte[] buf = new byte[65536];
                    while ((read = input.read(buf)) > -1) {
                        output.write(buf, 0, read);
                        totalWritten = totalWritten + (long)read;
                        Double progress = totalWritten.doubleValue() / totalBytes.doubleValue();
                        Platform.runLater(() -> this.uiProvider.updateProgress(progress));
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (output == null) continue;
                    if (throwable2 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                input.close();
            }
        }
    }

    private void createApplication() throws Exception {
        this.phase = "Create Application";
        if (this.manifest == null) {
            throw new IllegalArgumentException("Unable to retrieve embedded or remote manifest.");
        }
        Path cacheDir = this.manifest.resolveCacheDir(this.getParameters() != null ? this.getParameters().getNamed() : null);
        URLClassLoader classLoader = this.createClassLoader(cacheDir);
        FXMLLoader.setDefaultClassLoader((ClassLoader)classLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
        Platform.runLater(() -> Thread.currentThread().setContextClassLoader(classLoader));
        Class<?> appclass = classLoader.loadClass(this.manifest.launchClass);
        PlatformImpl.runAndWait(() -> {
            try {
                this.app = (Application)appclass.newInstance();
                ParametersImpl.registerParameters((Application)this.app, (Application.Parameters)new LauncherParams(this.getParameters(), this.manifest));
                PlatformImpl.setApplicationName((Class)appclass);
            }
            catch (Throwable t) {
                this.reportError("Error creating app class", t);
            }
        });
    }

    public void stop() throws Exception {
        if (this.app != null) {
            this.app.stop();
        }
    }

    private void reportError(String title, Throwable error) {
        log.log(Level.WARNING, title, error);
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle(title);
            alert.setHeaderText(title);
            alert.getDialogPane().setPrefWidth(600.0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            error.printStackTrace(writer);
            writer.close();
            TextArea text = new TextArea(out.toString());
            alert.getDialogPane().setContent((Node)text);
            alert.showAndWait();
            Platform.exit();
        });
    }

    private void syncManifest() throws Exception {
        Map namedParams = this.getParameters().getNamed();
        if (namedParams.containsKey("app")) {
            String manifestURL = (String)namedParams.get("app");
            log.info(String.format("Loading manifest from parameter supplied location %s", manifestURL));
            this.manifest = FXManifest.load(URI.create(manifestURL));
            return;
        }
        URL embeddedManifest = Launcher.class.getResource("/app.xml");
        this.manifest = (FXManifest)JAXB.unmarshal((URL)embeddedManifest, FXManifest.class);
        Path cacheDir = this.manifest.resolveCacheDir(namedParams);
        Path manifestPath = this.manifest.getPath(cacheDir);
        if (Files.exists(manifestPath, new LinkOption[0])) {
            this.manifest = (FXManifest)JAXB.unmarshal((File)manifestPath.toFile(), FXManifest.class);
        }
        try {
            FXManifest remoteManifest = FXManifest.load(this.manifest.getFXAppURI());
            if (remoteManifest == null) {
                log.info(String.format("No remote manifest at %s", this.manifest.getFXAppURI()));
            } else if (!remoteManifest.equals(this.manifest) && (remoteManifest.isNewerThan(this.manifest) || this.manifest.acceptDowngrade.booleanValue())) {
                this.manifest = remoteManifest;
                JAXB.marshal((Object)this.manifest, (File)manifestPath.toFile());
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Unable to update manifest", ex);
        }
    }
}

