/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import fxlauncher.AbstractLauncher;
import fxlauncher.DefaultUIProvider;
import fxlauncher.LauncherParams;
import fxlauncher.UIProvider;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Launcher
extends Application {
    private static final Logger log = Logger.getLogger("Launcher");
    private Application app;
    private Stage primaryStage;
    private Stage stage;
    private UIProvider uiProvider;
    private StackPane root;
    private final AbstractLauncher superLauncher = new AbstractLauncher<Application>(){

        @Override
        protected Application.Parameters getParameters() {
            return Launcher.this.getParameters();
        }

        @Override
        protected void updateProgress(double progress) {
            Platform.runLater(() -> Launcher.this.uiProvider.updateProgress(progress));
        }

        @Override
        protected void createApplication(Class<Application> appClass) {
            PlatformImpl.runAndWait(() -> {
                try {
                    Launcher.this.app = (Application)appClass.newInstance();
                }
                catch (Throwable t) {
                    this.reportError("Error creating app class", t);
                }
            });
        }

        @Override
        protected void reportError(String title, Throwable error) {
            log.log(Level.WARNING, title, error);
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(title);
                alert.setHeaderText(String.format("%s\ncheck the logfile 'fxlauncher.log, usually in the %s directory", title, System.getProperty("java.io.tmpdir")));
                alert.getDialogPane().setPrefWidth(600.0);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(out);
                error.printStackTrace(writer);
                writer.close();
                TextArea text = new TextArea(out.toString());
                alert.getDialogPane().setContent((Node)text);
                alert.showAndWait();
                Platform.exit();
            });
        }

        @Override
        protected void setupClassLoader(ClassLoader classLoader) {
            FXMLLoader.setDefaultClassLoader((ClassLoader)classLoader);
            Platform.runLater(() -> Thread.currentThread().setContextClassLoader(classLoader));
        }
    };

    public void init() throws Exception {
        Iterator<UIProvider> providers = ServiceLoader.load(UIProvider.class).iterator();
        this.uiProvider = providers.hasNext() ? providers.next() : new DefaultUIProvider();
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.stage = new Stage(StageStyle.UNDECORATED);
        this.root = new StackPane();
        boolean[] filesUpdated = new boolean[1];
        Scene scene = new Scene((Parent)this.root);
        this.stage.setScene(scene);
        this.superLauncher.setupLogFile();
        this.superLauncher.checkSSLIgnoreflag();
        this.uiProvider.init(this.stage);
        this.root.getChildren().add((Object)this.uiProvider.createLoader());
        this.stage.show();
        new Thread(() -> {
            block4: {
                Thread.currentThread().setName("FXLauncher-Thread");
                try {
                    this.superLauncher.updateManifest();
                    this.createUpdateWrapper();
                    filesUpdated[0] = this.superLauncher.syncFiles();
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, String.format("Error during %s phase", this.superLauncher.getPhase()), ex);
                    if (!this.superLauncher.checkIgnoreUpdateErrorSetting()) break block4;
                    this.superLauncher.reportError(String.format("Error during %s phase", this.superLauncher.getPhase()), ex);
                    System.exit(1);
                }
            }
            try {
                this.superLauncher.createApplicationEnvironment();
                this.launchAppFromManifest(filesUpdated[0]);
            }
            catch (Exception ex) {
                this.superLauncher.reportError(String.format("Error during %s phase", this.superLauncher.getPhase()), ex);
            }
        }).start();
    }

    private void launchAppFromManifest(boolean showWhatsnew) throws Exception {
        this.superLauncher.setPhase("Application Environment Prepare");
        ParametersImpl.registerParameters((Application)this.app, (Application.Parameters)new LauncherParams(this.getParameters(), this.superLauncher.getManifest()));
        PlatformImpl.setApplicationName(this.app.getClass());
        this.superLauncher.setPhase("Application Init");
        this.app.init();
        this.superLauncher.setPhase("Application Start");
        log.info("Show whats new dialog? " + showWhatsnew);
        PlatformImpl.runAndWait(() -> {
            try {
                if (showWhatsnew && this.superLauncher.getManifest().whatsNewPage != null) {
                    this.showWhatsNewDialog(this.superLauncher.getManifest().whatsNewPage);
                }
                if (this.superLauncher.getManifest().lingeringUpdateScreen.booleanValue()) {
                    this.primaryStage.showingProperty().addListener(observable -> {
                        if (this.stage.isShowing()) {
                            this.stage.close();
                        }
                    });
                } else {
                    this.stage.close();
                }
                this.app.start(this.primaryStage);
            }
            catch (Exception ex) {
                this.superLauncher.reportError("Failed to start application", ex);
            }
        });
    }

    private void showWhatsNewDialog(String whatsNewPage) {
        WebView view = new WebView();
        view.getEngine().load(Launcher.class.getResource(whatsNewPage).toExternalForm());
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("What's new");
        alert.setHeaderText("New in this update");
        alert.getDialogPane().setContent((Node)view);
        alert.showAndWait();
    }

    public static void main(String[] args) {
        Launcher.launch((String[])args);
    }

    private void createUpdateWrapper() {
        this.superLauncher.setPhase("Update Wrapper Creation");
        Platform.runLater(() -> {
            Parent updater = this.uiProvider.createUpdater(this.superLauncher.getManifest());
            this.root.getChildren().clear();
            this.root.getChildren().add((Object)updater);
        });
    }

    public void stop() throws Exception {
        if (this.app != null) {
            this.app.stop();
        }
    }
}

