/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.xml.bind.JAXB;

public class Launcher
extends Application {
    private static final Logger log = Logger.getLogger("Launcher");
    private FXManifest manifest;
    private Application app;
    private StackPane root;
    private Stage primaryStage;
    private ProgressBar progressBar;
    private Stage stage;
    private String phase;

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.root = new StackPane(new Node[]{new ProgressIndicator()});
        this.root.setPrefSize(200.0, 80.0);
        this.root.setPadding(new Insets(10.0));
        this.stage = new Stage(StageStyle.UNDECORATED);
        Scene scene = new Scene((Parent)this.root);
        this.stage.setScene(scene);
        this.stage.show();
        new Thread(() -> {
            try {
                this.updateManifest();
                this.createUpdateWrapper();
                this.syncFiles();
                this.createApplication();
                this.launchAppFromManifest();
            }
            catch (Exception ex) {
                this.reportError(String.format("Error during %s phase", this.phase), ex);
            }
        }).start();
    }

    public static void main(String[] args) {
        Launcher.launch((String[])args);
    }

    private void createUpdateWrapper() {
        this.phase = "Update Wrapper Creation";
        Platform.runLater(() -> {
            this.stage.setTitle(this.manifest.name);
            this.progressBar = new ProgressBar();
            this.progressBar.setStyle(this.manifest.progressBarStyle);
            Label label = new Label(this.manifest.updateText);
            label.setStyle(this.manifest.updateLabelStyle);
            VBox wrapper = new VBox(new Node[]{label, this.progressBar});
            wrapper.setStyle(this.manifest.wrapperStyle);
            this.root.getChildren().clear();
            this.root.getChildren().add((Object)wrapper);
        });
    }

    public URLClassLoader createClassLoader() {
        List<URL> libs = this.manifest.files.stream().map(LibraryFile::toURL).collect(Collectors.toList());
        return new URLClassLoader(libs.toArray(new URL[libs.size()]));
    }

    private void launchAppFromManifest() throws Exception {
        this.phase = "Application Init";
        this.app.init();
        this.phase = "Application Start";
        Platform.runLater(() -> {
            try {
                this.stage.close();
                this.app.start(this.primaryStage);
            }
            catch (Exception ex) {
                this.reportError("Failed to start application", ex);
            }
        });
    }

    private void updateManifest() throws Exception {
        this.phase = "Update Manifest";
        List params = this.getParameters().getRaw();
        if (!params.isEmpty()) {
            this.updateManifest((String)params.get(0));
        } else {
            this.syncManifest();
        }
        this.loadManifest(Launcher.getLocalPath().toUri());
    }

    private void syncFiles() throws Exception {
        this.phase = "File Synchronization";
        List needsUpdate = this.manifest.files.stream().filter(LibraryFile::needsUpdate).collect(Collectors.toList());
        Long totalBytes = needsUpdate.stream().mapToLong(f -> f.size).sum();
        Long totalWritten = 0L;
        for (LibraryFile lib : needsUpdate) {
            Path target = Paths.get(lib.file, new String[0]).toAbsolutePath();
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            InputStream input = this.manifest.uri.resolve(lib.file).toURL().openStream();
            Throwable throwable = null;
            try {
                OutputStream output = Files.newOutputStream(target, new OpenOption[0]);
                Throwable throwable2 = null;
                try {
                    int read;
                    byte[] buf = new byte[65536];
                    while ((read = input.read(buf)) > -1) {
                        output.write(buf, 0, read);
                        totalWritten = totalWritten + (long)read;
                        Double progress = totalWritten.doubleValue() / totalBytes.doubleValue();
                        Platform.runLater(() -> this.progressBar.setProgress(progress.doubleValue()));
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (output == null) continue;
                    if (throwable2 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                input.close();
            }
        }
    }

    private void createApplication() throws Exception {
        this.phase = "Create Application";
        URLClassLoader classLoader = this.createClassLoader();
        FXMLLoader.setDefaultClassLoader((ClassLoader)classLoader);
        Class<?> appclass = classLoader.loadClass(this.manifest.launchClass);
        Thread.currentThread().setContextClassLoader(classLoader);
        this.app = (Application)appclass.newInstance();
    }

    public void stop() throws Exception {
        if (this.app != null) {
            this.app.stop();
        }
    }

    private void reportError(String title, Throwable error) {
        log.log(Level.WARNING, title, error);
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle(title);
            alert.setHeaderText(title);
            alert.getDialogPane().setPrefWidth(600.0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            error.printStackTrace(writer);
            writer.close();
            TextArea text = new TextArea(out.toString());
            alert.getDialogPane().setContent((Node)text);
            alert.showAndWait();
            Platform.exit();
        });
    }

    private static Path getLocalPath() {
        return Paths.get("app.xml", new String[0]);
    }

    private void syncManifest() throws Exception {
        if (!Files.exists(FXManifest.getPath(), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("No %s in current directory", "app.xml"));
        }
        this.manifest = FXManifest.load();
        try {
            byte[] remoteContent = Launcher.toByteArray(this.manifest.getFXAppURI().toURL().openStream());
            byte[] localContent = Files.readAllBytes(FXManifest.getPath());
            if (!Arrays.equals(remoteContent, localContent)) {
                Files.write(FXManifest.getPath(), remoteContent, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Unable to update manifest", ex);
        }
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int read;
            byte[] buf = new byte[16384];
            while ((read = is.read(buf, 0, buf.length)) != -1) {
                buffer.write(buf, 0, read);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private void updateManifest(String uri) {
        try {
            this.loadManifest(URI.create(uri));
            this.manifest.save();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Unable to update manifest from %s", uri));
        }
    }

    private void loadManifest(URI uri) {
        this.manifest = (FXManifest)JAXB.unmarshal((URI)uri, FXManifest.class);
    }
}

