/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import fxlauncher.LibraryFile;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Application")
public class FXManifest {
    @XmlAttribute
    String name;
    @XmlAttribute
    URI uri;
    @XmlAttribute(name="launch")
    String launchClass;
    @XmlElement(name="lib")
    List<LibraryFile> files = new ArrayList<LibraryFile>();
    @XmlElement
    String updateText = "Updating...";
    @XmlElement
    String updateLabelStyle = "-fx-font-weight: bold;";
    @XmlElement
    String progressBarStyle = "-fx-pref-width: 200;";
    @XmlElement
    String wrapperStyle = "-fx-spacing: 10; -fx-padding: 25;";

    public String getFilename() {
        return String.format("%s.xml", this.launchClass);
    }

    public URI getFXAppURI() {
        return this.uri.resolve("app.xml");
    }

    public Path getPath() {
        return Paths.get(this.getFilename(), new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FXManifest that = (FXManifest)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.uri.equals(that.uri)) {
            return false;
        }
        if (!this.launchClass.equals(that.launchClass)) {
            return false;
        }
        if (!this.files.equals(that.files)) {
            return false;
        }
        if (!this.updateText.equals(that.updateText)) {
            return false;
        }
        if (!this.updateLabelStyle.equals(that.updateLabelStyle)) {
            return false;
        }
        if (!this.progressBarStyle.equals(that.progressBarStyle)) {
            return false;
        }
        return this.wrapperStyle.equals(that.wrapperStyle);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + this.launchClass.hashCode();
        result = 31 * result + this.files.hashCode();
        result = 31 * result + this.updateText.hashCode();
        result = 31 * result + this.updateLabelStyle.hashCode();
        result = 31 * result + this.progressBarStyle.hashCode();
        result = 31 * result + this.wrapperStyle.hashCode();
        return result;
    }
}

