/*
 * Decompiled with CFR 0.152.
 */
package fxlauncher;

import com.sun.javafx.application.ParametersImpl;
import fxlauncher.FXManifest;
import fxlauncher.LibraryFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.xml.bind.JAXB;

public class Launcher
extends Application {
    private static final Logger log = Logger.getLogger("Launcher");
    private FXManifest manifest;
    private Application app;
    private StackPane root;
    private Stage primaryStage;
    private ProgressBar progressBar;
    private Stage stage;
    private String phase;

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.root = new StackPane(new Node[]{new ProgressIndicator()});
        this.root.setPrefSize(200.0, 80.0);
        this.root.setPadding(new Insets(10.0));
        this.stage = new Stage(StageStyle.UNDECORATED);
        Scene scene = new Scene((Parent)this.root);
        this.stage.setScene(scene);
        this.stage.show();
        new Thread(() -> {
            try {
                this.updateManifest();
                this.createUpdateWrapper();
                this.syncFiles();
                this.createApplication();
                this.launchAppFromManifest();
            }
            catch (Exception ex) {
                this.reportError(String.format("Error during %s phase", this.phase), ex);
            }
        }).start();
    }

    public static void main(String[] args) {
        Launcher.launch((String[])args);
    }

    private void createUpdateWrapper() {
        this.phase = "Update Wrapper Creation";
        Platform.runLater(() -> {
            this.progressBar = new ProgressBar();
            this.progressBar.setStyle(this.manifest.progressBarStyle);
            Label label = new Label(this.manifest.updateText);
            label.setStyle(this.manifest.updateLabelStyle);
            VBox wrapper = new VBox(new Node[]{label, this.progressBar});
            wrapper.setStyle(this.manifest.wrapperStyle);
            this.root.getChildren().clear();
            this.root.getChildren().add((Object)wrapper);
        });
    }

    public URLClassLoader createClassLoader() {
        List<URL> libs = this.manifest.files.stream().filter(LibraryFile::loadForCurrentPlatform).map(LibraryFile::toURL).collect(Collectors.toList());
        return new URLClassLoader(libs.toArray(new URL[libs.size()]));
    }

    private void launchAppFromManifest() throws Exception {
        this.phase = "Application Init";
        this.app.init();
        this.phase = "Application Start";
        Platform.runLater(() -> {
            try {
                this.stage.close();
                ParametersImpl.registerParameters((Application)this.app, (Application.Parameters)this.getParameters());
                this.app.start(this.primaryStage);
            }
            catch (Exception ex) {
                this.reportError("Failed to start application", ex);
            }
        });
    }

    private void updateManifest() throws Exception {
        this.phase = "Update Manifest";
        this.syncManifest();
    }

    private void syncFiles() throws Exception {
        this.phase = "File Synchronization";
        List needsUpdate = this.manifest.files.stream().filter(LibraryFile::loadForCurrentPlatform).filter(LibraryFile::needsUpdate).collect(Collectors.toList());
        Long totalBytes = needsUpdate.stream().mapToLong(f -> f.size).sum();
        Long totalWritten = 0L;
        for (LibraryFile lib : needsUpdate) {
            Path target = Paths.get(lib.file, new String[0]).toAbsolutePath();
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            InputStream input = this.manifest.uri.resolve(lib.file).toURL().openStream();
            Throwable throwable = null;
            try {
                OutputStream output = Files.newOutputStream(target, new OpenOption[0]);
                Throwable throwable2 = null;
                try {
                    int read;
                    byte[] buf = new byte[65536];
                    while ((read = input.read(buf)) > -1) {
                        output.write(buf, 0, read);
                        totalWritten = totalWritten + (long)read;
                        Double progress = totalWritten.doubleValue() / totalBytes.doubleValue();
                        Platform.runLater(() -> this.progressBar.setProgress(progress.doubleValue()));
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (output == null) continue;
                    if (throwable2 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                input.close();
            }
        }
    }

    private void createApplication() throws Exception {
        this.phase = "Create Application";
        URLClassLoader classLoader = this.createClassLoader();
        FXMLLoader.setDefaultClassLoader((ClassLoader)classLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
        Platform.runLater(() -> Thread.currentThread().setContextClassLoader(classLoader));
        Class<?> appclass = classLoader.loadClass(this.manifest.launchClass);
        this.app = (Application)appclass.newInstance();
    }

    public void stop() throws Exception {
        if (this.app != null) {
            this.app.stop();
        }
    }

    private void reportError(String title, Throwable error) {
        log.log(Level.WARNING, title, error);
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle(title);
            alert.setHeaderText(title);
            alert.getDialogPane().setPrefWidth(600.0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            error.printStackTrace(writer);
            writer.close();
            TextArea text = new TextArea(out.toString());
            alert.getDialogPane().setContent((Node)text);
            alert.showAndWait();
            Platform.exit();
        });
    }

    private void syncManifest() throws Exception {
        URL embeddedManifest = Launcher.class.getResource("/app.xml");
        this.manifest = (FXManifest)JAXB.unmarshal((URL)embeddedManifest, FXManifest.class);
        if (Files.exists(this.manifest.getPath(), new LinkOption[0])) {
            this.manifest = (FXManifest)JAXB.unmarshal((File)this.manifest.getPath().toFile(), FXManifest.class);
        }
        try {
            FXManifest remoteManifest = (FXManifest)JAXB.unmarshal((URI)this.manifest.getFXAppURI(), FXManifest.class);
            if (remoteManifest == null) {
                log.info(String.format("No remote manifest at %s", this.manifest.getFXAppURI()));
            } else if (!remoteManifest.equals(this.manifest)) {
                this.manifest = remoteManifest;
                JAXB.marshal((Object)this.manifest, (File)this.manifest.getPath().toFile());
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Unable to update manifest", ex);
        }
    }
}

